/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableSensitiveData;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.util.PurApRelatedViews;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class PurchasingAccountsPayableModuleServiceImpl
implements PurchasingAccountsPayableModuleService {
    private static final Logger LOG = LogManager.getLogger(PurchasingAccountsPayableModuleServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected PaymentRequestService paymentRequestService;
    protected PurapService purapService;
    protected PurchaseOrderService purchaseOrderService;
    protected RequisitionService requisitionService;
    private ParameterService parameterService;
    private CreditMemoService creditMemoService;
    private NoteService noteService;
    private AccountsPayableService accountsPayableService;

    public void addAssignedAssetNumbers(Integer purchaseOrderNumber, String principalId, String noteText) {
        PurchaseOrderDocument document = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        try {
            Note assetNote = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)document, noteText);
            assetNote.setAuthorUniversalIdentifier(principalId);
            document.addNote(assetNote);
            ((NoteService)SpringContext.getBean(NoteService.class)).save(assetNote);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPurchaseOrderInquiryUrl(Integer purchaseOrderNumber) {
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        if (ObjectUtils.isNotNull((Object)po)) {
            return "purapPurchaseOrder.do?methodToCall=docHandler&docId=" + po.getDocumentNumber() + "&command=displayDocSearchView";
        }
        return "";
    }

    public List<PurchasingAccountsPayableSensitiveData> getAllSensitiveDatas() {
        ArrayList<PurchasingAccountsPayableSensitiveData> sensitiveDatas = new ArrayList<PurchasingAccountsPayableSensitiveData>();
        Collection sensitiveDatasAsObjects = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findAll(SensitiveData.class);
        for (Object rm : sensitiveDatasAsObjects) {
            sensitiveDatas.add((PurchasingAccountsPayableSensitiveData)rm);
        }
        return sensitiveDatas;
    }

    public PurchasingAccountsPayableSensitiveData getSensitiveDataByCode(String sensitiveDataCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("sensitiveDataCode", sensitiveDataCode);
        return (PurchasingAccountsPayableSensitiveData)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(SensitiveData.class, primaryKeys);
    }

    public boolean isPurchasingBatchDocument(String documentTypeCode) {
        return "PREQ".equals(documentTypeCode) || "CM".equals(documentTypeCode);
    }

    public void handlePurchasingBatchCancels(String documentNumber, String documentTypeCode, boolean primaryCancel, boolean disbursedPayment) {
        LOG.info("Begin handlePurchasingBatchCancels(documentNumber=" + documentNumber + ", documentTypeCode=" + documentTypeCode + ", primaryCancel=" + primaryCancel + ", disbursedPayment=" + disbursedPayment);
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        PaymentRequestService paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        CreditMemoService creditMemoService = (CreditMemoService)SpringContext.getBean(CreditMemoService.class);
        String preqCancelNote = parameterService.getParameterValueAsString(PaymentRequestDocument.class, "CANCEL_NOTE");
        String preqResetNote = parameterService.getParameterValueAsString(PaymentRequestDocument.class, "RESET_NOTE");
        String cmCancelNote = parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "CANCEL_NOTE");
        String cmResetNote = parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "RESET_NOTE");
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                if (disbursedPayment || primaryCancel) {
                    paymentRequestService.cancelExtractedPaymentRequest(pr, preqCancelNote);
                } else {
                    paymentRequestService.resetExtractedPaymentRequest(pr, preqResetNote);
                }
            } else {
                LOG.error("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Payment Request with doc type of " + documentTypeCode + " with id " + documentNumber);
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                if (disbursedPayment || primaryCancel) {
                    creditMemoService.cancelExtractedCreditMemo(cm, cmCancelNote);
                } else {
                    creditMemoService.resetExtractedCreditMemo(cm, cmResetNote);
                }
            } else {
                LOG.error("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of " + documentTypeCode + " with id " + documentNumber);
            }
        }
    }

    public void handlePurchasingBatchPaids(String documentNumber, String documentTypeCode, Date processDate) {
        PaymentRequestService paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        CreditMemoService creditMemoService = (CreditMemoService)SpringContext.getBean(CreditMemoService.class);
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                paymentRequestService.markPaid(pr, processDate);
            } else {
                LOG.error("processPdpPaids() DOES NOT EXIST, CANNOT MARK - Payment Request with doc type of " + documentTypeCode + " with id " + documentNumber);
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                creditMemoService.markPaid(cm, processDate);
            } else {
                LOG.error("processPdpPaids() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of " + documentTypeCode + " with id " + documentNumber);
            }
        }
    }

    public void handlePurchasingBatchReissue(String documentNumber, String documentTypeCode) {
        VendorCreditMemoDocument accountsPayableDocument;
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument accountsPayableDocument2 = this.paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (ObjectUtils.isNotNull((Object)accountsPayableDocument2) && "Cancelled".equals(accountsPayableDocument2.getApplicationDocumentStatus())) {
                String preqReissueNote = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "REISSUE_NOTE");
                this.createNoteAndRevertToPreviousAppDocStatus(documentNumber, documentTypeCode, preqReissueNote, accountsPayableDocument2);
            }
        } else if ("CM".equals(documentTypeCode) && ObjectUtils.isNotNull((Object)(accountsPayableDocument = this.creditMemoService.getCreditMemoByDocumentNumber(documentNumber))) && "Cancelled".equals(accountsPayableDocument.getApplicationDocumentStatus())) {
            String cmReissueNote = this.parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "REISSUE_NOTE");
            this.createNoteAndRevertToPreviousAppDocStatus(documentNumber, documentTypeCode, cmReissueNote, accountsPayableDocument);
        }
    }

    private void createNoteAndRevertToPreviousAppDocStatus(String documentNumber, String documentTypeCode, String preqReissueNote, AccountsPayableDocument accountsPayableDocument) {
        if (ObjectUtils.isNotNull((Object)accountsPayableDocument)) {
            Note cancelNote = this.documentService.createNoteFromDocument((Document)accountsPayableDocument, preqReissueNote);
            cancelNote.setAuthorUniversalIdentifier(this.getSystemUserPrincipalId());
            accountsPayableDocument.addNote(cancelNote);
            this.noteService.save(cancelNote);
            this.accountsPayableService.revertToPreviousAppDocStatus(accountsPayableDocument);
        } else {
            LOG.error("DOCUMENT DOES NOT EXIST, CANNOT PROCESS - doc type of " + documentTypeCode + " with id " + documentNumber);
        }
    }

    String getSystemUserPrincipalId() {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId();
    }

    public KualiDecimal getTotalPaidAmountToRequisitions(List<String> documentNumbers) {
        KualiDecimal totalPaidAmountToRequests = KualiDecimal.ZERO;
        HashMap<String, List<String>> fieldValues = new HashMap<String, List<String>>();
        fieldValues.put("documentNumber", documentNumbers);
        Collection reqses = this.businessObjectService.findMatching(RequisitionDocument.class, fieldValues);
        for (RequisitionDocument reqs : reqses) {
            try {
                PurApRelatedViews relatedviews = reqs.getRelatedViews();
                if (relatedviews == null || relatedviews.getRelatedPaymentRequestViews() == null || relatedviews.getRelatedPaymentRequestViews().size() <= 0) continue;
                List<PaymentRequestView> preqViews = relatedviews.getRelatedPaymentRequestViews();
                for (PaymentRequestView preqView : preqViews) {
                    PaymentRequestDocument preqDocument = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(preqView.getDocumentNumber());
                    if (!preqDocument.getDocumentHeader().getWorkflowDocument().isFinal()) continue;
                    totalPaidAmountToRequests = (KualiDecimal)totalPaidAmountToRequests.add((AbstractKualiDecimal)preqDocument.getVendorInvoiceAmount());
                }
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Could not retrieve document to determine totals paid on Requisitions", we);
            }
        }
        return totalPaidAmountToRequests;
    }

    public String determineRelatedRequisitionInitiatorPrincipalId(Document document) {
        if (document instanceof PurchasingAccountsPayableDocumentBase) {
            Integer requisitionIdentifier = null;
            if (document instanceof AccountsPayableDocument) {
                PurchaseOrderDocument purchaseOrder = ((AccountsPayableDocument)document).getPurchaseOrderDocument();
                if (ObjectUtils.isNotNull((Object)purchaseOrder)) {
                    requisitionIdentifier = purchaseOrder.getRequisitionIdentifier();
                }
            } else if (document instanceof PurchaseOrderDocument) {
                requisitionIdentifier = ((PurchaseOrderDocument)document).getRequisitionIdentifier();
            }
            if (ObjectUtils.isNotNull(requisitionIdentifier)) {
                RequisitionDocument requisitionDocument = this.requisitionService.getRequisitionById(requisitionIdentifier);
                return requisitionDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            }
        }
        return null;
    }

    public HashMap<String, String> checkForDuplicatePaymentRequests(Integer vendorHeaderGeneratedId, Integer vendorDetailAssignedId, String invoiceNumber, KualiDecimal invoiceAmount, Date invoiceDate, String vendorToken, String specifiedSourceToken, boolean questionFormat) {
        return this.paymentRequestService.checkForDuplicatePaymentRequests(vendorHeaderGeneratedId, vendorDetailAssignedId, invoiceNumber, invoiceAmount, invoiceDate, vendorToken, specifiedSourceToken, questionFormat);
    }

    public String getB2BUrlString() {
        return "&channelUrl=b2b.do?methodToCall=shopCatalogs";
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setCreditMemoService(CreditMemoService creditMemoService) {
        this.creditMemoService = creditMemoService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setAccountsPayableService(AccountsPayableService accountsPayableService) {
        this.accountsPayableService = accountsPayableService;
    }
}

