/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableAccountingLineAccessibleValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.UpdateAccountingLineEvent;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;

public class PurchaseOrderAmendmentAccountingLineAccessibleValidation
extends PurchasingAccountsPayableAccountingLineAccessibleValidation {
    protected PurapService purapService;

    public boolean validate(AttributedDocumentEvent event) {
        if (this.purapService.isDocumentStoppedInRouteNode((PurchasingAccountsPayableDocument)event.getDocument(), "New Unordered Items")) {
            return true;
        }
        if (((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(event.getDocument().getDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId())) {
            return true;
        }
        if (event instanceof UpdateAccountingLineEvent) {
            PurchaseOrderAmendmentDocument poa = (PurchaseOrderAmendmentDocument)event.getDocument();
            boolean isProportional = StringUtils.equals((CharSequence)poa.getAccountDistributionMethod(), (CharSequence)"P");
            boolean onlyAmountChanged = this.onlyAmountChanged(((UpdateAccountingLineEvent)event).getAccountingLine(), ((UpdateAccountingLineEvent)event).getUpdatedAccountingLine());
            if (isProportional && onlyAmountChanged) {
                return true;
            }
        }
        boolean setDummyAccountIdentifier = false;
        if (this.needsDummyAccountIdentifier()) {
            ((PurApAccountingLine)this.getAccountingLineForValidation()).setAccountIdentifier(Integer.MAX_VALUE);
            setDummyAccountIdentifier = true;
        }
        boolean result = super.validate(event);
        if (setDummyAccountIdentifier) {
            ((PurApAccountingLine)this.getAccountingLineForValidation()).setAccountIdentifier(null);
        }
        return result;
    }

    private boolean onlyAmountChanged(AccountingLine accountingLine, AccountingLine updatedAccountingLine) {
        if (accountingLine.isLike(updatedAccountingLine)) {
            return false;
        }
        PurchaseOrderAccount updatedLine = new PurchaseOrderAccount();
        updatedLine.copyFrom(updatedAccountingLine);
        updatedLine.setAmount(accountingLine.getAmount());
        return accountingLine.isLike((AccountingLine)updatedLine);
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }
}

