/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingDocumentPreRulesBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class PurchaseOrderDocumentPreRules
extends PurchasingDocumentPreRulesBase {
    @Override
    public boolean doPrompts(Document document) {
        boolean preRulesOK = true;
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)document;
        if (StringUtils.isBlank((CharSequence)this.event.getQuestionContext()) || StringUtils.equals((CharSequence)this.question, (CharSequence)"OverrideNotToExceed")) {
            preRulesOK = this.confirmNotToExceedOverride(purchaseOrderDocument);
        }
        if (this.isDocumentInStateToReceiveNextFyWarning(purchaseOrderDocument) && (StringUtils.isBlank((CharSequence)this.event.getQuestionContext()) || StringUtils.equals((CharSequence)this.question, (CharSequence)"NextFiscalYearWarning"))) {
            preRulesOK &= this.confirmNextFYPriorToApoAllowedDate(purchaseOrderDocument);
        }
        if (!purchaseOrderDocument.isUseTaxIndicator()) {
            preRulesOK &= this.checkForTaxRecalculation(purchaseOrderDocument);
        }
        return preRulesOK;
    }

    protected boolean isDocumentInStateToReceiveNextFyWarning(PurchaseOrderDocument poDocument) {
        return "In Process".equals(poDocument.getApplicationDocumentStatus()) || "Awaiting Purchasing Approval".equals(poDocument.getApplicationDocumentStatus());
    }

    protected boolean confirmNotToExceedOverride(PurchaseOrderDocument purchaseOrderDocument) {
        if (!this.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit(purchaseOrderDocument)) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchaseOrder.question.notToExceed.override");
            boolean confirmOverride = super.askOrAnalyzeYesNoQuestion("OverrideNotToExceed", questionText);
            if (confirmOverride && StringUtils.isBlank((CharSequence)this.event.getQuestionContext())) {
                this.event.setQuestionContext("OverrideNotToExceed");
            }
            if (!confirmOverride) {
                this.event.setActionForwardName("basic");
                return false;
            }
        }
        return true;
    }

    public boolean validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit(PurchasingDocument purDocument) {
        boolean valid = true;
        if (ObjectUtils.isNotNull((Object)purDocument.getPurchaseOrderTotalLimit()) && ObjectUtils.isNotNull((Object)((AmountTotaling)purDocument).getTotalDollarAmount()) && ((AmountTotaling)purDocument).getTotalDollarAmount().isGreaterThan((AbstractKualiDecimal)purDocument.getPurchaseOrderTotalLimit())) {
            valid = false;
            KNSGlobalVariables.getMessageList().add("warning.purchaseOrderTotalLimit", new String[0]);
        }
        return valid;
    }

    protected boolean confirmNextFYPriorToApoAllowedDate(PurchaseOrderDocument poDocument) {
        if (poDocument.isPostingYearNext() && !((PurapService)SpringContext.getBean(PurapService.class)).isTodayWithinApoAllowedRange()) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("warning.purchaseOrder.encumber.nextFY");
            boolean confirmOverride = super.askOrAnalyzeYesNoQuestion("NextFiscalYearWarning", questionText);
            if (confirmOverride && StringUtils.isBlank((CharSequence)this.event.getQuestionContext())) {
                this.event.setQuestionContext("NextFiscalYearWarning");
            }
            if (!confirmOverride) {
                this.event.setActionForwardName("basic");
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkCAMSWarningStatus(PurchasingAccountsPayableDocument purapDocument) {
        return PurapConstants.CAMSWarningStatuses.PURCHASEORDER_STATUS_WARNING_NO_CAMS_DATA.contains(purapDocument.getApplicationDocumentStatus());
    }
}

