/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingProcessVendorValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.VendorDetail;

public class PurchaseOrderProcessVendorValidation
extends PurchasingProcessVendorValidation {
    private DataDictionaryService dataDictionaryService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        VendorDetail vendorDetail;
        boolean valid = super.validate(event);
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)event.getDocument();
        PurchaseOrderDocument poDocument = (PurchaseOrderDocument)purapDocument;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        errorMap.addToErrorPath("document.vendor*,document.purchaseOrderVendorChoiceCode,document.alternateVendorName,document.shipmentReceivedDate,document.vendorContractEndDate");
        Integer vendorHeaderID = poDocument.getVendorHeaderGeneratedIdentifier();
        if (ObjectUtils.isNull((Object)vendorHeaderID)) {
            valid = false;
            errorMap.putError("vendorName", "error.nonexist.vendor", new String[0]);
        }
        if (ObjectUtils.isNull((Object)(vendorDetail = super.getVendorService().getVendorDetail(poDocument.getVendorHeaderGeneratedIdentifier(), poDocument.getVendorDetailAssignedIdentifier())))) {
            return valid;
        }
        if (!vendorDetail.isActiveIndicator()) {
            valid = false;
            errorMap.putError("vendorName", "error.inactive.vendor", new String[0]);
        }
        super.getPostalCodeValidationService().validateAddress(poDocument.getVendorCountryCode(), poDocument.getVendorStateCode(), poDocument.getVendorPostalCode(), "vendorStateCode", "vendorPostalCode");
        Integer alternateVendorHdrGeneratedId = poDocument.getAlternateVendorHeaderGeneratedIdentifier();
        Integer alternateVendorHdrDetailAssignedId = poDocument.getAlternateVendorDetailAssignedIdentifier();
        VendorDetail alternateVendor = super.getVendorService().getVendorDetail(alternateVendorHdrGeneratedId, alternateVendorHdrDetailAssignedId);
        if (alternateVendor != null) {
            if (alternateVendor.isVendorDebarred()) {
                errorMap.putError("alternateVendorName", "error.purchaseOrder.alternateVendor.debarred", new String[0]);
                valid = false;
            }
            if (StringUtils.equals((CharSequence)alternateVendor.getVendorHeader().getVendorTypeCode(), (CharSequence)"DV")) {
                errorMap.putError("alternateVendorName", "error.purchaseOrder.alternateVendor.dvType", new String[0]);
                valid = false;
            }
            if (!alternateVendor.isActiveIndicator()) {
                errorMap.putError("alternateVendorName", "error.inactive", new String[]{"Alternate Payee Vendor"});
                valid = false;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)poDocument.getVendorContractName()) && super.getVendorService().isVendorContractExpired((Document)poDocument, poDocument.getVendorContractGeneratedIdentifier(), vendorDetail)) {
            errorMap.putError("vendorContractEndDate", "error.vendor.contract.expired.endDate", new String[0]);
            valid = false;
        }
        errorMap.clearErrorPath();
        return valid;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

