/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorChoice;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchaseOrderVendorChoiceRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderVendorChoiceRule.class);

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean checkForSystemParametersExistence() {
        LOG.info("checkForSystemParametersExistence called");
        boolean success = true;
        ArrayList apoParameterValues = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "DEFAULT_APO_VENDOR_CHOICE"));
        ArrayList b2bParameterValues = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "DEFAULT_B2B_VENDOR_CHOICE"));
        PurchaseOrderVendorChoice newVendorChoice = (PurchaseOrderVendorChoice)((Object)this.getNewBo());
        PurchaseOrderVendorChoice oldVendorChoice = (PurchaseOrderVendorChoice)((Object)this.getOldBo());
        if ((apoParameterValues.contains(newVendorChoice.getPurchaseOrderVendorChoiceCode()) || b2bParameterValues.contains(newVendorChoice.getPurchaseOrderVendorChoiceCode())) && !newVendorChoice.isActive() && oldVendorChoice.isActive()) {
            success = false;
            String documentLabel = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByClass(((Object)((Object)newVendorChoice)).getClass());
            this.putGlobalError("error.document.cannot.inactivate.used.in.system.parameters", documentLabel);
        }
        return success;
    }
}

