/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class PurchasingCommodityCodeValidation
extends GenericValidation {
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private PurApItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]");
        this.itemForValidation.refreshReferenceObject("commodityCode");
        boolean valid = this.validateCommodityCodes(this.itemForValidation, this.commodityCodeIsRequired());
        GlobalVariables.getMessageMap().removeFromErrorPath("document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]");
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    protected boolean validateCommodityCodes(PurApItem item, boolean commodityCodeRequired) {
        boolean valid = true;
        String identifierString = item.getItemIdentifierString();
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        if (commodityCodeRequired && StringUtils.isBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(CommodityCode.class.getName()).getAttributeDefinition("purchasingCommodityCode").getLabel();
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.required", new String[]{attributeLabel + " in " + identifierString});
        } else if (StringUtils.isNotBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("purchasingCommodityCode", purItem.getPurchasingCommodityCode());
            if (this.businessObjectService.countMatching(CommodityCode.class, fieldValues) != 1) {
                valid = false;
                GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.invalid", new String[]{" in " + identifierString});
            } else {
                valid = this.validateThatCommodityCodeIsActive(item);
            }
        }
        return valid;
    }

    protected boolean validateThatCommodityCodeIsActive(PurApItem item) {
        if (!((PurchasingItemBase)item).getCommodityCode().isActive()) {
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.inactive", new String[]{" in " + item.getItemIdentifierString()});
            return false;
        }
        return true;
    }

    protected boolean commodityCodeIsRequired() {
        return false;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

