/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableImportItemValidation;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class PurchasingImportItemValidation
extends PurchasingAccountsPayableImportItemValidation {
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        PurApItem refreshedItem = this.getItemForValidation();
        refreshedItem.refreshReferenceObject("itemType");
        super.setItemForValidation(refreshedItem);
        boolean valid = super.validate(event);
        GlobalVariables.getMessageMap().addToErrorPath("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*");
        if (this.getItemForValidation().getItemType().isLineItemIndicator()) {
            valid &= this.validateItemDescription(this.getItemForValidation());
        }
        valid &= this.validateItemUnitPrice(this.getItemForValidation());
        valid &= this.validateUnitOfMeasureCodeExists(this.getItemForValidation());
        GlobalVariables.getMessageMap().removeFromErrorPath("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*");
        return valid &= this.validateCommodityCodes(this.getItemForValidation(), this.commodityCodeIsRequired());
    }

    protected boolean validateCommodityCodes(PurApItem item, boolean commodityCodeRequired) {
        boolean valid = true;
        String identifierString = item.getItemIdentifierString();
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        if (commodityCodeRequired && StringUtils.isBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(CommodityCode.class.getName()).getAttributeDefinition("purchasingCommodityCode").getLabel();
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.required", new String[]{attributeLabel + " in " + identifierString});
        } else if (StringUtils.isNotBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("purchasingCommodityCode", purItem.getPurchasingCommodityCode());
            if (this.businessObjectService.countMatching(CommodityCode.class, fieldValues) != 1) {
                valid = false;
                GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.invalid", new String[]{" in " + identifierString});
            } else {
                valid = this.validateThatCommodityCodeIsActive(item);
            }
        }
        return valid;
    }

    public boolean validateItemDescription(PurApItem item) {
        boolean valid = true;
        if (StringUtils.isEmpty((CharSequence)item.getItemDescription())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemDescription").getLabel();
            GlobalVariables.getMessageMap().putError("itemDescription", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        return valid;
    }

    public boolean validateItemUnitPrice(PurApItem item) {
        boolean valid = true;
        if (item.getItemType().isLineItemIndicator() && ObjectUtils.isNull((Object)item.getItemUnitPrice())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitPrice").getLabel();
            GlobalVariables.getMessageMap().putError("itemUnitPrice", "error.required", new String[]{attributeLabel + " in " + item.getItemIdentifierString()});
        }
        if (ObjectUtils.isNotNull((Object)item.getItemUnitPrice())) {
            if (BigDecimal.ZERO.compareTo(item.getItemUnitPrice()) > 0 && !item.getItemTypeCode().equals("ORDS") && !item.getItemTypeCode().equals("TRDI")) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.belowZero", new String[]{"Unit Cost", item.getItemIdentifierString()});
                valid = false;
            } else if (BigDecimal.ZERO.compareTo(item.getItemUnitPrice()) < 0 && (item.getItemTypeCode().equals("ORDS") || item.getItemTypeCode().equals("TRDI"))) {
                GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.amount.notBelowZero", new String[]{"Unit Cost", item.getItemIdentifierString()});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateUnitOfMeasureCodeExists(PurApItem item) {
        boolean valid = true;
        if (item.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
            String uomCode = item.getItemUnitOfMeasureCode();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("itemUnitOfMeasureCode", uomCode);
            if (this.businessObjectService.countMatching(UnitOfMeasure.class, fieldValues) != 1) {
                String[] errorParams = new String[]{uomCode, "" + item.getItemLineNumber()};
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "error.itemParser.invalidUOMCode", errorParams);
                valid = false;
            }
        }
        return valid;
    }

    protected boolean commodityCodeIsRequired() {
        return false;
    }

    protected boolean validateThatCommodityCodeIsActive(PurApItem item) {
        if (!((PurchasingItemBase)item).getCommodityCode().isActive()) {
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.inactive", new String[]{" in " + item.getItemIdentifierString()});
            return false;
        }
        return true;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

