/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.pdp.businessobject.PurchasingPaymentDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class PurchasingAccountsPayableFormBase
extends KualiAccountingDocumentFormBase {
    protected transient List<SummaryAccount> summaryAccounts;
    protected boolean readOnlyAccountDistributionMethod;

    public PurchasingAccountsPayableFormBase() {
        this.clearSummaryAccounts();
        this.setupAccountDistributionMethod();
    }

    protected void setupAccountDistributionMethod() {
        String defaultDistributionMethod = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", "DISTRIBUTION_METHOD_FOR_ACCOUNTING_LINES");
        if ("P".equalsIgnoreCase(defaultDistributionMethod) || "S".equalsIgnoreCase(defaultDistributionMethod)) {
            this.setReadOnlyAccountDistributionMethod(true);
        } else {
            this.setReadOnlyAccountDistributionMethod(false);
        }
    }

    public void refreshAccountSummmary() {
        this.clearSummaryAccounts();
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)this.getDocument();
        this.summaryAccounts.addAll(((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).generateSummaryAccounts(purapDocument));
    }

    public void clearSummaryAccounts() {
        this.summaryAccounts = new ArrayList<SummaryAccount>();
    }

    public List getBaselineSourceAccountingLines() {
        ArrayList<PurApAccountingLine> accounts = new ArrayList<PurApAccountingLine>();
        if (ObjectUtils.isNull(accounts) || accounts.isEmpty()) {
            accounts = new ArrayList();
            for (PurApItem item : ((PurchasingAccountsPayableDocument)this.getDocument()).getItems()) {
                List<PurApAccountingLine> lines = item.getBaselineSourceAccountingLines();
                accounts.addAll(lines);
            }
        }
        return accounts;
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        PurchasingAccountsPayableDocument purapDoc = (PurchasingAccountsPayableDocument)this.getDocument();
        purapDoc.fixItemReferences();
    }

    public List<SummaryAccount> getSummaryAccounts() {
        if (this.summaryAccounts == null) {
            this.refreshAccountSummmary();
        }
        return this.summaryAccounts;
    }

    public void setSummaryAccounts(List<SummaryAccount> summaryAccounts) {
        this.summaryAccounts = summaryAccounts;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public String getDisbursementInfoUrl() {
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        String orgCode = parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_BATCH.class, "PRE_DISBURSEMENT_EXTRACT_ORGANIZATION");
        String subUnitCode = parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_BATCH.class, "PRE_DISBURSEMENT_EXTRACT_SUB_UNIT");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "search");
        parameters.put("backLocation", basePath + "/" + "portal" + ".do");
        parameters.put("docFormKey", "88888888");
        parameters.put("businessObjectClassName", PurchasingPaymentDetail.class.getName());
        parameters.put("hideReturnLink", "true");
        parameters.put("suppressActions", "false");
        parameters.put("paymentGroup.batch.customerProfile.unitCode", orgCode);
        parameters.put("paymentGroup.batch.customerProfile.subUnitCode", subUnitCode);
        return UrlFactory.parameterizeUrl((String)(basePath + "/" + "kr/lookup.do"), (Properties)parameters);
    }

    protected void populateAccountingLinesForResponse(String methodToCall, Map parameterMap) {
        super.populateAccountingLinesForResponse(methodToCall, parameterMap);
        this.populateItemAccountingLines(parameterMap);
    }

    protected void populateItemAccountingLines(Map parameterMap) {
        int itemCount = 0;
        for (PurApItem item : ((PurchasingAccountsPayableDocument)this.getDocument()).getItems()) {
            this.populateAccountingLine(item.getNewSourceLine(), "document.item[" + itemCount + "]." + "newSourceLine", parameterMap);
            int sourceLineCount = 0;
            for (PurApAccountingLine purApLine : item.getSourceAccountingLines()) {
                this.populateAccountingLine(purApLine, "document.item[" + itemCount + "]." + "sourceAccountingLine" + "[" + sourceLineCount + "]", parameterMap);
                ++sourceLineCount;
            }
        }
    }

    public boolean isReadOnlyAccountDistributionMethod() {
        return this.readOnlyAccountDistributionMethod;
    }

    public void setReadOnlyAccountDistributionMethod(boolean readOnlyAccountDistributionMethod) {
        this.readOnlyAccountDistributionMethod = readOnlyAccountDistributionMethod;
    }
}

