/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.role.RoleMembership;

public class PaymentRequestHoldCancelInitiatorDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected DocumentService documentService;
    List<String> requiredAttributes = new ArrayList<String>(1);

    public PaymentRequestHoldCancelInitiatorDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("documentNumber");
    }

    public boolean isCheckRequiredAttributes() {
        return true;
    }

    public List<String> getRequiredAttributes() {
        return Collections.unmodifiableList(this.requiredAttributes);
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (qualification != null && !qualification.isEmpty()) {
            try {
                AccountsPayableDocumentBase document = (AccountsPayableDocumentBase)this.getDocumentService().getByDocumentHeaderId(qualification.get("documentNumber"));
                if (document != null && document.getLastActionPerformedByUser() != null) {
                    RoleMembership.Builder roleMember = RoleMembership.Builder.create(null, null, (String)document.getLastActionPerformedByUser().getPrincipalId(), (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, null);
                    members.add(roleMember.build());
                }
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Unable to load document in getPrincipalIdsFromApplicationRole: " + qualification.get("documentNumber"), e);
            }
        }
        return members;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }
}

