/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteLanguage;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.pdf.PurapPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.vnd.businessobject.ContractManager;

public class PurchaseOrderQuotePdf
extends PurapPdf {
    private static final Logger LOG = LogManager.getLogger();

    public void onOpenDocument(PdfWriter writer, Document document) {
        LOG.debug("onOpenDocument() started.");
        try {
            float[] headerWidths = new float[]{0.2f, 0.6f, 0.2f};
            this.headerTable = new PdfPTable(headerWidths);
            this.headerTable.setWidthPercentage(100.0f);
            this.headerTable.setHorizontalAlignment(1);
            this.headerTable.getDefaultCell().setBorderWidth(0.0f);
            this.headerTable.getDefaultCell().setHorizontalAlignment(1);
            this.headerTable.getDefaultCell().setVerticalAlignment(1);
            if (StringUtils.isNotBlank((CharSequence)this.logoImage)) {
                this.logo = Image.getInstance((String)this.logoImage);
                this.logo.scalePercent(3.0f, 3.0f);
                this.headerTable.addCell(new Phrase(new Chunk(this.logo, 0.0f, 0.0f)));
            } else {
                this.headerTable.addCell(new Phrase(new Chunk("")));
            }
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph("REQUEST FOR QUOTATION\nTHIS IS NOT AN ORDER", this.ver_17_normal));
            cell.setBorderWidth(0.0f);
            cell.setHorizontalAlignment(1);
            this.headerTable.addCell(cell);
            Paragraph p = new Paragraph();
            p.add((Object)new Chunk("\n     R.Q. Number: ", this.ver_8_bold));
            p.add((Object)new Chunk(this.po.getPurapDocumentIdentifier() + "\n", this.cour_10_normal));
            cell = new PdfPCell((Phrase)p);
            cell.setBorderWidth(0.0f);
            this.headerTable.addCell(cell);
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public PurchaseOrderQuotePdf getPageEvents() {
        LOG.debug("getPageEvents() started.");
        return new PurchaseOrderQuotePdf();
    }

    public void generatePOQuotePDF(PurchaseOrderDocument po, PurchaseOrderVendorQuote poqv, String campusName, String contractManagerCampusCode, String logoImage, ByteArrayOutputStream byteArrayOutputStream, String environment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("generatePOQuotePDF() started for po number " + po.getPurapDocumentIdentifier());
        }
        try {
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)byteArrayOutputStream);
            this.createPOQuotePdf(po, poqv, campusName, contractManagerCampusCode, logoImage, doc, writer, environment);
        }
        catch (DocumentException de) {
            LOG.error(de.getMessage(), (Throwable)de);
            throw new PurError("Document Exception when trying to save a Purchase Order Quote PDF", de);
        }
    }

    public void savePOQuotePDF(PurchaseOrderDocument po, PurchaseOrderVendorQuote poqv, PurchaseOrderParameters transmitParameters, String environment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("savePOQuotePDF() started for po number " + po.getPurapDocumentIdentifier());
        }
        try {
            PurchaseOrderTransmitParameters orderTransmitParameters = (PurchaseOrderTransmitParameters)transmitParameters;
            CampusParameter deliveryCampus = orderTransmitParameters.getCampusParameter();
            if (deliveryCampus == null) {
                throw new RuntimeException(" delivery campus is null");
            }
            String campusName = deliveryCampus.getCampus().getName();
            if (campusName == null) {
                throw new RuntimeException("Campus Information is missing - campusName: " + null);
            }
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(orderTransmitParameters.getPdfFileLocation() + orderTransmitParameters.getPdfFileName()));
            this.createPOQuotePdf(po, poqv, campusName, orderTransmitParameters.getContractManagerCampusCode(), orderTransmitParameters.getLogoImage(), doc, writer, environment);
        }
        catch (DocumentException de) {
            LOG.error(de.getMessage(), (Throwable)de);
            throw new PurError("Document Exception when trying to save a Purchase Order Quote PDF", de);
        }
        catch (FileNotFoundException f) {
            LOG.error(f.getMessage(), (Throwable)f);
            throw new PurError("FileNotFound Exception when trying to save a Purchase Order Quote PDF", f);
        }
    }

    private void createPOQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote poqv, String campusName, String contractManagerCampusCode, String logoImage, Document document, PdfWriter writer, String environment) throws DocumentException {
        List vendorStipulationsList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("createQuotePdf() started for po number " + po.getPurapDocumentIdentifier());
        }
        this.campusName = campusName;
        this.po = po;
        this.logoImage = logoImage;
        this.environment = environment;
        SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.KUALI_SIMPLE_DATE_FORMAT_2);
        CampusParameter campusParameter = this.getCampusParameter(contractManagerCampusCode);
        String purchasingAddressFull = this.getPurchasingAddressFull(campusParameter);
        PurchaseOrderQuotePdf events = new PurchaseOrderQuotePdf().getPageEvents();
        writer.setPageEvent((PdfPageEvent)this);
        document.open();
        LOG.debug("createQuotePdf() info table started.");
        float[] infoWidths = new float[]{0.45f, 0.55f};
        PdfPTable infoTable = new PdfPTable(infoWidths);
        infoTable.setWidthPercentage(100.0f);
        infoTable.setHorizontalAlignment(1);
        infoTable.setSplitLate(false);
        Paragraph p = new Paragraph();
        ContractManager contractManager = po.getContractManager();
        p.add((Object)new Chunk("\n Return this form to:\n", this.ver_8_bold));
        p.add((Object)new Chunk(purchasingAddressFull + "\n", this.cour_10_normal));
        p.add((Object)new Chunk("\n", this.cour_10_normal));
        p.add((Object)new Chunk(" Fax #: ", this.ver_6_normal));
        p.add((Object)new Chunk(contractManager.getContractManagerFaxNumber() + "\n", this.cour_10_normal));
        p.add((Object)new Chunk(" Contract Manager: ", this.ver_6_normal));
        p.add((Object)new Chunk(contractManager.getContractManagerName() + " " + contractManager.getContractManagerPhoneNumber() + "\n", this.cour_10_normal));
        p.add((Object)new Chunk("\n", this.cour_10_normal));
        p.add((Object)new Chunk(" To:\n", this.ver_6_normal));
        StringBuffer vendorInfo = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorAttentionName())) {
            vendorInfo.append("     ATTN: ").append(poqv.getVendorAttentionName().trim()).append("\n");
        }
        vendorInfo.append("     ").append(poqv.getVendorName()).append("\n");
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorLine1Address())) {
            vendorInfo.append("     ").append(poqv.getVendorLine1Address()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorLine2Address())) {
            vendorInfo.append("     ").append(poqv.getVendorLine2Address()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorCityName())) {
            vendorInfo.append("     ").append(poqv.getVendorCityName());
        }
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorStateCode()) && !poqv.getVendorStateCode().equals("--")) {
            vendorInfo.append(", ").append(poqv.getVendorStateCode());
        }
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorAddressInternationalProvinceName())) {
            vendorInfo.append(", ").append(poqv.getVendorAddressInternationalProvinceName());
        }
        if (StringUtils.isNotBlank((CharSequence)poqv.getVendorPostalCode())) {
            vendorInfo.append(" ").append(poqv.getVendorPostalCode()).append("\n");
        } else {
            vendorInfo.append("\n");
        }
        if (!"US".equalsIgnoreCase(poqv.getVendorCountryCode()) && poqv.getVendorCountryCode() != null) {
            vendorInfo.append("     ").append(poqv.getVendorCountry().getName()).append("\n\n");
        } else {
            vendorInfo.append("     \n\n");
        }
        p.add((Object)new Chunk(vendorInfo.toString(), this.cour_10_normal));
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk("\n     R.Q. Number: ", this.ver_8_bold));
        p.add((Object)new Chunk(po.getPurapDocumentIdentifier() + "\n", this.cour_10_normal));
        Date requestDate = this.getDateTimeService().getCurrentSqlDate();
        if (poqv.getPurchaseOrderQuoteTransmitTimestamp() != null) {
            try {
                requestDate = this.getDateTimeService().convertToSqlDate(poqv.getPurchaseOrderQuoteTransmitTimestamp());
            }
            catch (ParseException e) {
                throw new RuntimeException("ParseException thrown when trying to convert from Timestamp to SqlDate.", e);
            }
        }
        p.add((Object)new Chunk("     R.Q. Date: ", this.ver_8_bold));
        p.add((Object)new Chunk(sdf.format(requestDate) + "\n", this.cour_10_normal));
        p.add((Object)new Chunk("     RESPONSE MUST BE RECEIVED BY: ", this.ver_8_bold));
        if (po.getPurchaseOrderQuoteDueDate() != null) {
            p.add((Object)new Chunk(sdf.format(po.getPurchaseOrderQuoteDueDate()) + "\n\n", this.cour_10_normal));
        } else {
            p.add((Object)new Chunk("N/A\n\n", this.cour_10_normal));
        }
        StringBuffer quoteStipulations = this.getPoQuoteLanguage();
        p.add((Object)new Chunk(quoteStipulations.toString(), this.ver_6_normal));
        p.add((Object)new Chunk("\n ALL QUOTES MUST BE TOTALED", this.ver_12_normal));
        cell = new PdfPCell((Phrase)p);
        infoTable.addCell(cell);
        document.add((Element)infoTable);
        PdfPTable notesStipulationsTable = new PdfPTable(1);
        notesStipulationsTable.setWidthPercentage(100.0f);
        notesStipulationsTable.setSplitLate(false);
        p = new Paragraph();
        p.add((Object)new Chunk("  Vendor Stipulations and Information\n\n", this.ver_6_normal));
        if (po.getPurchaseOrderBeginDate() != null && po.getPurchaseOrderEndDate() != null) {
            p.add((Object)new Chunk("     Order in effect from " + sdf.format(po.getPurchaseOrderBeginDate()) + " to " + sdf.format(po.getPurchaseOrderEndDate()) + ".\n", this.cour_10_normal));
        }
        if ((vendorStipulationsList = po.getPurchaseOrderVendorStipulations()).size() > 0) {
            StringBuffer vendorStipulations = new StringBuffer();
            for (PurchaseOrderVendorStipulation povs : vendorStipulationsList) {
                vendorStipulations.append("     ").append(povs.getVendorStipulationDescription()).append("\n");
            }
            p.add((Object)new Chunk("     " + vendorStipulations.toString(), this.cour_10_normal));
        }
        PdfPCell tableCell = new PdfPCell((Phrase)p);
        tableCell.setHorizontalAlignment(0);
        tableCell.setVerticalAlignment(4);
        notesStipulationsTable.addCell(tableCell);
        document.add((Element)notesStipulationsTable);
        LOG.debug("createQuotePdf() items table started.");
        float[] itemsWidths = new float[]{0.07f, 0.1f, 0.07f, 0.5f, 0.13f, 0.13f};
        PdfPTable itemsTable = new PdfPTable(6);
        itemsTable.setWidthPercentage(100.0f);
        itemsTable.setWidths(itemsWidths);
        itemsTable.setSplitLate(false);
        tableCell = this.createCell("Item\nNo.", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        tableCell = this.createCell("Quantity", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        tableCell = this.createCell("UOM", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        tableCell = this.createCell("Description", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        tableCell = this.createCell("Unit Cost\n(Required)", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        tableCell = this.createCell("Extended Cost\n(Required)", false, false, false, false, 1, this.ver_6_normal);
        itemsTable.addCell(tableCell);
        if (StringUtils.isNotBlank((CharSequence)po.getPurchaseOrderQuoteVendorNoteText())) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            tableCell = this.createCell(po.getPurchaseOrderQuoteVendorNoteText(), false, false, false, false, 0, this.cour_10_normal);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        for (PurchaseOrderItem poi : po.getItems()) {
            if (poi.getItemType() == null || !StringUtils.isNotBlank((CharSequence)poi.getItemDescription()) || !poi.getItemType().isLineItemIndicator() && !poi.getItemTypeCode().equals("SPHD") && !poi.getItemTypeCode().equals("FRHT") && !poi.getItemTypeCode().equals("ORDS") && !poi.getItemTypeCode().equals("TRDI")) continue;
            String description = StringUtils.isNotBlank((CharSequence)poi.getItemCatalogNumber()) ? poi.getItemCatalogNumber().trim() + " - " : "";
            description = description + (StringUtils.isNotBlank((CharSequence)poi.getItemDescription()) ? poi.getItemDescription().trim() : "");
            if (StringUtils.isNotBlank((CharSequence)poi.getItemDescription()) && (poi.getItemTypeCode().equals("ORDS") || poi.getItemTypeCode().equals("TRDI"))) {
                description = poi.getItemType().getItemTypeDescription() + " - " + description;
            }
            String itemLineNumber = poi.getItemType().isLineItemIndicator() ? poi.getItemLineNumber().toString() : "";
            tableCell = this.createCell(itemLineNumber, false, false, false, false, 1, this.cour_10_normal);
            itemsTable.addCell(tableCell);
            String quantity = poi.getItemQuantity() != null ? poi.getItemQuantity().toString() : " ";
            tableCell = this.createCell(quantity, false, false, false, false, 1, this.cour_10_normal);
            itemsTable.addCell(tableCell);
            tableCell = this.createCell(poi.getItemUnitOfMeasureCode(), false, false, false, false, 1, this.cour_10_normal);
            itemsTable.addCell(tableCell);
            tableCell = this.createCell(description, false, false, false, false, 0, this.cour_10_normal);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        this.createBlankRowInItemsTable(itemsTable);
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        tableCell = this.createCell("Total: ", false, false, false, false, 2, this.ver_10_normal);
        itemsTable.addCell(tableCell);
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        this.createBlankRowInItemsTable(itemsTable);
        document.add((Element)itemsTable);
        LOG.debug("createQuotePdf() vendorFillsIn table started.");
        float[] vendorFillsInWidths = new float[]{0.5f, 0.5f};
        PdfPTable vendorFillsInTable = new PdfPTable(vendorFillsInWidths);
        vendorFillsInTable.setWidthPercentage(100.0f);
        vendorFillsInTable.setHorizontalAlignment(1);
        vendorFillsInTable.setSplitLate(false);
        vendorFillsInTable.getDefaultCell().setBorderWidth(0.0f);
        vendorFillsInTable.getDefaultCell().setHorizontalAlignment(1);
        vendorFillsInTable.getDefaultCell().setVerticalAlignment(1);
        String important = "\nIMPORTANT: The information and signature below MUST BE COMPLETED or your offer may be rejected.\n";
        cell = this.createCell(important, true, false, false, false, 0, this.ver_8_normal);
        cell.setColspan(2);
        vendorFillsInTable.addCell(cell);
        String cashDiscount = "Terms of Payment:  Cash discount_________%_________Days-Net________Days\n";
        cell = this.createCell(cashDiscount, true, false, false, false, 0, this.ver_8_normal);
        cell.setColspan(2);
        vendorFillsInTable.addCell(cell);
        String fob = " FOB: __ Destination (Title)\n";
        cell = this.createCell(fob, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String freightVendor = " __ Freight Vendor Paid (Allowed)\n";
        cell = this.createCell(freightVendor, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String shipping = "          __ Shipping Point (Title)\n";
        cell = this.createCell(shipping, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String freightPrepaid = " __ Freight Prepaid & Added Amount $_________\n";
        cell = this.createCell(freightPrepaid, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String commonCarrier = "      If material will ship common carrier, please provide the following:\n";
        cell = this.createCell(commonCarrier, true, false, false, false, 0, this.ver_8_bold);
        cell.setColspan(2);
        vendorFillsInTable.addCell(cell);
        String origin = "      Point of origin and zip code: ______________________ Weight: _________ Class: _________\n";
        cell = this.createCell(origin, true, false, false, false, 0, this.ver_8_bold);
        cell.setColspan(2);
        vendorFillsInTable.addCell(cell);
        p = new Paragraph();
        p.add((Object)new Chunk(" Unless otherwise stated, all material to be shipped to ", this.ver_8_normal));
        String purchasingAddressPartial = po.getAddressToVendorIndicator() ? po.getReceivingCityName() + ", " + po.getReceivingStateCode() + " " + po.getReceivingPostalCode() : po.getDeliveryCityName() + ", " + po.getDeliveryStateCode() + " " + po.getDeliveryPostalCode();
        p.add((Object)new Chunk(purchasingAddressPartial + "\n", this.cour_10_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setColspan(2);
        cell.setHorizontalAlignment(0);
        cell.setBorderWidth(0.0f);
        vendorFillsInTable.addCell(cell);
        String offerEffective = " Offer effective until (Date):_____________\n";
        cell = this.createCell(offerEffective, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String deliverBy = " Delivery can be made by (Date):_____________\n";
        cell = this.createCell(deliverBy, true, false, false, false, 0, this.ver_8_normal);
        vendorFillsInTable.addCell(cell);
        String sign = " SIGN HERE:____________________________\n";
        cell = this.createCell(sign, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        String date = " DATE:____________________________\n";
        cell = this.createCell(date, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        String name = " PRINT NAME:____________________________\n";
        cell = this.createCell(name, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        String phone = " PHONE:____________________________\n";
        cell = this.createCell(phone, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        String company = " COMPANY:____________________________\n";
        cell = this.createCell(company, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        String fax = " FAX:____________________________\n";
        cell = this.createCell(fax, true, false, false, false, 2, this.ver_10_bold);
        vendorFillsInTable.addCell(cell);
        document.add((Element)vendorFillsInTable);
        document.close();
        LOG.debug("createQuotePdf()pdf document closed.");
    }

    private StringBuffer getPoQuoteLanguage() {
        StringBuffer quoteLanguage = new StringBuffer();
        HashMap criteria = new HashMap();
        Collection poqlList = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatchingOrderBy(PurchaseOrderQuoteLanguage.class, criteria, "purchaseOrderQuoteLanguageIdentifier", true);
        for (PurchaseOrderQuoteLanguage poql : poqlList) {
            quoteLanguage.append(poql.getPurchaseOrderQuoteLanguageDescription());
            quoteLanguage.append("\n");
        }
        return quoteLanguage;
    }

    private void createBlankRowInItemsTable(PdfPTable itemsTable) {
        for (int i = 0; i < 6; ++i) {
            itemsTable.addCell(" ");
        }
    }

    private PdfPCell createCell(String content, boolean borderless, boolean noBottom, boolean noRight, boolean noTop, int horizontalAlignment, Font font) {
        PdfPCell tableCell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (borderless) {
            tableCell.setBorder(0);
        }
        if (noBottom) {
            tableCell.setBorderWidthBottom(0.0f);
        }
        if (noTop) {
            tableCell.setBorderWidthTop(0.0f);
        }
        if (noRight) {
            tableCell.setBorderWidthRight(0.0f);
        }
        tableCell.setHorizontalAlignment(horizontalAlignment);
        return tableCell;
    }

    private CampusParameter getCampusParameter(String contractManagerCampusCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("campusCode", contractManagerCampusCode);
        return (CampusParameter)((List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(CampusParameter.class, criteria)).get(0);
    }

    private String getPurchasingAddressFull(CampusParameter campusParameter) {
        String indent = "     ";
        StringBuffer addressBuffer = new StringBuffer();
        addressBuffer.append(indent).append(campusParameter.getPurchasingInstitutionName()).append("\n");
        addressBuffer.append(indent).append(campusParameter.getPurchasingDepartmentName()).append("\n");
        addressBuffer.append(indent).append(campusParameter.getPurchasingDepartmentLine1Address()).append("\n");
        if (ObjectUtils.isNotNull((Object)campusParameter.getPurchasingDepartmentLine2Address())) {
            addressBuffer.append(indent).append(campusParameter.getPurchasingDepartmentLine2Address()).append("\n");
        }
        addressBuffer.append(indent).append(campusParameter.getPurchasingDepartmentCityName()).append(", ");
        addressBuffer.append(campusParameter.getPurchasingDepartmentStateCode()).append(" ");
        addressBuffer.append(campusParameter.getPurchasingDepartmentZipCode()).append(" ");
        addressBuffer.append(ObjectUtils.isNotNull((Object)campusParameter.getPurchasingDepartmentCountryCode()) ? campusParameter.getPurchasingDepartmentCountryCode() : "");
        return addressBuffer.toString();
    }
}

