/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderContractLanguage;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.exception.PurapConfigurationException;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.service.ImageService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class PurchaseOrderTransmitParameters
implements PurchaseOrderParameters {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderTransmitParameters.class);
    private String imageTempLocation;
    private String key;
    private String logoImage;
    private String directorSignatureImage;
    private String contractManagerSignatureImage;
    private CampusParameter campusParameter;
    private String statusInquiryUrl;
    private String contractLanguage;
    private String contractManagerCampusCode;
    private boolean useImage;
    private String pdfFileLocation;
    private String pdfFileName;
    String recipientFaxNumber;
    String vendorName;
    String faxDescription;

    @Override
    public void setPurchaseOrderPdfParameters(PurchaseOrderDocument po) {
        this.setPurchaseOrderPdfParameters(po, null);
    }

    @Override
    public void setPurchaseOrderPdfParameters(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq) {
        this.key = povq == null ? po.getPurapDocumentIdentifier().toString() : po.getPurapDocumentIdentifier().toString() + povq.getPurchaseOrderVendorQuoteIdentifier().toString();
        String campusCode = po.getDeliveryCampusCode().toLowerCase();
        boolean useImage = true;
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND").booleanValue()) {
            useImage = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND");
        }
        this.pickLogoImage(po, campusCode, useImage);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("campusCode", po.getDeliveryCampusCode());
        this.campusParameter = (CampusParameter)((List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(CampusParameter.class, criteria)).get(0);
        if (this.getStatusInquiryUrl() == null) {
            LOG.debug("generatePurchaseOrderPdf() ended");
            throw new PurapConfigurationException("Application Setting INVOICE_STATUS_INQUIRY_URL is missing.");
        }
        criteria.put("active", true);
        List contractLanguageList = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PurchaseOrderContractLanguage.class, criteria);
        this.contractLanguage = this.updateContractLanguage(po, contractLanguageList);
        if (this.getPdfFileLocation() == null) {
            LOG.debug("savePurchaseOrderPdf() ended");
            throw new PurapConfigurationException("Application Setting PDF_DIRECTORY is missing.");
        }
        String environment = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("environment");
        this.pdfFileName = povq != null ? "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_Quote" + povq.getPurchaseOrderVendorQuoteIdentifier().toString() + "_" + environment + "_" + System.currentTimeMillis() + ".pdf" : "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_" + environment + "_" + System.currentTimeMillis() + ".pdf";
        this.contractManagerCampusCode = po.getContractManager().getContractManagerPerson() != null ? po.getContractManager().getContractManagerPerson().getCampusCode() : "";
    }

    protected void pickLogoImage(PurchaseOrderDocument po, String campusCode, boolean useImage) {
        if (useImage) {
            if (this.getImageTempLocation() == null) {
                throw new PurapConfigurationException("IMAGE_TEMP_PATH is missing");
            }
            this.logoImage = ((ImageService)SpringContext.getBean(ImageService.class)).getLogo(this.key, campusCode, this.imageTempLocation);
            if (this.logoImage == null) {
                throw new PurapConfigurationException("logoImage is null.");
            }
            this.directorSignatureImage = ((ImageService)SpringContext.getBean(ImageService.class)).getPurchasingDirectorImage(this.key, campusCode, this.imageTempLocation);
            if (this.directorSignatureImage == null) {
                throw new PurapConfigurationException("directorSignatureImage is null.");
            }
            this.contractManagerSignatureImage = ((ImageService)SpringContext.getBean(ImageService.class)).getContractManagerImage(this.key, po.getContractManagerCode(), this.imageTempLocation);
            if (this.contractManagerSignatureImage == null) {
                throw new PurapConfigurationException("contractManagerSignatureImage is null.");
            }
        }
    }

    @Override
    public void setPurchaseOrderFaxParameters(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq) {
        String environmentCode;
        if (this.getPdfFileLocation() == null) {
            LOG.debug("savePurchaseOrderPdf() ended");
            throw new PurapConfigurationException("Application Setting PDF_DIRECTORY is missing.");
        }
        this.pdfFileName = povq != null ? "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_Quote" + povq.getPurchaseOrderVendorQuoteIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf" : "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf";
        this.faxDescription = povq != null ? "PO: " + po.getPurapDocumentIdentifier() + " Quote ID: " + povq.getPurchaseOrderVendorQuoteIdentifier() : "PO: " + po.getPurapDocumentIdentifier() + " Cntrct Mgr: " + po.getContractManager().getContractManagerCode();
        String productionEnvironmentCode = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("production.environment.code");
        if (!StringUtils.equals((CharSequence)productionEnvironmentCode, (CharSequence)(environmentCode = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("environment")))) {
            this.faxDescription = environmentCode + " TEST - " + this.faxDescription;
        }
        this.vendorName = povq != null ? povq.getVendorName() : po.getVendorName();
    }

    @Override
    public void setPurchaseOrderPdfAndFaxParameters(PurchaseOrderDocument po) {
        this.setPurchaseOrderPdfAndFaxParameters(po, null);
    }

    @Override
    public void setPurchaseOrderPdfAndFaxParameters(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq) {
        String environmentCode;
        this.key = povq == null ? po.getPurapDocumentIdentifier().toString() : po.getPurapDocumentIdentifier().toString() + povq.getPurchaseOrderVendorQuoteIdentifier().toString();
        String campusCode = po.getDeliveryCampusCode().toLowerCase();
        boolean useImage = true;
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND").booleanValue()) {
            useImage = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND");
        }
        this.pickLogoImage(po, campusCode, useImage);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("campusCode", po.getDeliveryCampusCode());
        this.campusParameter = (CampusParameter)((List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(CampusParameter.class, criteria)).get(0);
        if (this.getStatusInquiryUrl() == null) {
            LOG.debug("generatePurchaseOrderPdf() ended");
            throw new PurapConfigurationException("Application Setting INVOICE_STATUS_INQUIRY_URL is missing.");
        }
        criteria.put("active", true);
        List contractLanguageList = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PurchaseOrderContractLanguage.class, criteria);
        this.contractLanguage = this.updateContractLanguage(po, contractLanguageList);
        if (this.getPdfFileLocation() == null) {
            LOG.debug("savePurchaseOrderPdf() ended");
            throw new PurapConfigurationException("Application Setting PDF_DIRECTORY is missing.");
        }
        this.pdfFileName = povq != null ? "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_Quote" + povq.getPurchaseOrderVendorQuoteIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf" : "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf";
        this.contractManagerCampusCode = po.getContractManager().getContractManagerPerson() != null ? po.getContractManager().getContractManagerPerson().getCampusCode() : "";
        this.faxDescription = povq != null ? "PO: " + po.getPurapDocumentIdentifier() + " Quote ID: " + povq.getPurchaseOrderVendorQuoteIdentifier() : "PO: " + po.getPurapDocumentIdentifier() + " Cntrct Mgr: " + po.getContractManager().getContractManagerCode();
        String productionEnvironmentCode = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("production.environment.code");
        if (!StringUtils.equals((CharSequence)productionEnvironmentCode, (CharSequence)(environmentCode = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("environment")))) {
            this.faxDescription = environmentCode + " TEST - " + this.faxDescription;
        }
        this.vendorName = povq != null ? povq.getVendorName() : po.getVendorName();
        this.recipientFaxNumber = povq == null ? po.getVendorFaxNumber() : povq.getVendorFaxNumber();
    }

    protected String updateContractLanguage(PurchaseOrderDocument po, List<PurchaseOrderContractLanguage> contractLanguageList) {
        StringBuilder builder = new StringBuilder();
        if (!contractLanguageList.isEmpty()) {
            int lineNumber = 1;
            for (PurchaseOrderContractLanguage row : contractLanguageList) {
                if (!row.getCampusCode().equals(po.getDeliveryCampusCode())) continue;
                builder.append(lineNumber).append(" ").append(row.getPurchaseOrderContractLanguageDescription()).append("\n");
                ++lineNumber;
            }
        }
        return builder.toString();
    }

    public String getContractManagerCampusCode() {
        return this.contractManagerCampusCode;
    }

    public void setContractManagerCampusCode(String contractManagerCampusCode) {
        this.contractManagerCampusCode = contractManagerCampusCode;
    }

    public String getPdfFileName() {
        return this.pdfFileName;
    }

    public void setPdfFileName(String pdfFileName) {
        this.pdfFileName = pdfFileName;
    }

    public String getPdfFileLocation() {
        if (this.pdfFileLocation == null) {
            this.pdfFileLocation = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTORY");
        }
        return this.pdfFileLocation;
    }

    public void setPdfFileLocation(String pdfFileLocation) {
        this.pdfFileLocation = pdfFileLocation;
    }

    public CampusParameter getCampusParameter() {
        return this.campusParameter;
    }

    public void setCampusParameter(CampusParameter campusParameter) {
        this.campusParameter = campusParameter;
    }

    public String getContractLanguage() {
        return this.contractLanguage;
    }

    public void setContractLanguage(String contractLanguage) {
        this.contractLanguage = contractLanguage;
    }

    public String getContractManagerSignatureImage() {
        return this.contractManagerSignatureImage;
    }

    public void setContractManagerSignatureImage(String contractManagerSignatureImage) {
        this.contractManagerSignatureImage = contractManagerSignatureImage;
    }

    public String getDirectorSignatureImage() {
        return this.directorSignatureImage;
    }

    public void setDirectorSignatureImage(String directorSignatureImage) {
        this.directorSignatureImage = directorSignatureImage;
    }

    public String getImageTempLocation() {
        if (this.imageTempLocation == null) {
            this.imageTempLocation = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("temp.directory") + "/";
        }
        return this.imageTempLocation;
    }

    public void setImageTempLocation(String imageTempLocation) {
        this.imageTempLocation = imageTempLocation;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLogoImage() {
        return this.logoImage;
    }

    public void setLogoImage(String logoImage) {
        this.logoImage = logoImage;
    }

    public String getStatusInquiryUrl() {
        if (this.statusInquiryUrl == null) {
            this.statusInquiryUrl = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_STATUS_INQUIRY_URL");
        }
        return this.statusInquiryUrl;
    }

    public void setStatusInquiryUrl(String statusInquiryUrl) {
        this.statusInquiryUrl = statusInquiryUrl;
    }

    public boolean isUseImage() {
        return this.useImage;
    }

    public void setUseImage(boolean useImage) {
        this.useImage = useImage;
    }

    public String getRecipientFaxNumber() {
        return this.recipientFaxNumber;
    }

    public void setRecipientFaxNumber(String recipientFaxNumber) {
        this.recipientFaxNumber = recipientFaxNumber;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getFaxDescription() {
        return this.faxDescription;
    }

    public void setFaxDescription(String faxDescription) {
        this.faxDescription = faxDescription;
    }
}

