/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public final class PurApObjectUtils {
    private static final Logger LOG = LogManager.getLogger(PurApObjectUtils.class);

    private PurApObjectUtils() {
    }

    public static void populateFromBaseClass(Class base, BusinessObject src, BusinessObject target, Map supplementalUncopyable) {
        Field[] fields;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields = base.getDeclaredFields()) {
            if (!Modifier.isTransient(field.getModifiers())) {
                fieldNames.add(field.getName());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("field " + field.getName() + " is transient, skipping ");
        }
        int counter = 0;
        for (String fieldName : fieldNames) {
            if (!PurApObjectUtils.isProcessableField(base, fieldName, PurapConstants.KNOWN_UNCOPYABLE_FIELDS) || !PurApObjectUtils.isProcessableField(base, fieldName, supplementalUncopyable)) continue;
            PurApObjectUtils.attemptCopyOfFieldName(base.getName(), fieldName, src, target, supplementalUncopyable);
            ++counter;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Population complete for " + counter + " fields out of a total of " + fieldNames.size() + " potential fields in object with base class '" + base + "'");
        }
    }

    protected static boolean isProcessableField(Class baseClass, String fieldName, Map excludedFieldNames) {
        if (excludedFieldNames.containsKey(fieldName)) {
            Class potentialClassName = (Class)excludedFieldNames.get(fieldName);
            return ObjectUtils.isNotNull((Object)potentialClassName) && !potentialClassName.equals(baseClass);
        }
        return true;
    }

    protected static void attemptCopyOfFieldName(String baseClassName, String fieldName, BusinessObject sourceObject, BusinessObject targetObject, Map supplementalUncopyable) {
        block6: {
            try {
                Object propertyValue = ObjectUtils.getPropertyValue((Object)sourceObject, (String)fieldName);
                if (ObjectUtils.isNotNull((Object)propertyValue) && Collection.class.isAssignableFrom(propertyValue.getClass())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("attempting to copy collection field '" + fieldName + "' using base class '" + baseClassName + "' and property value class '" + propertyValue.getClass() + "'");
                    }
                    PurApObjectUtils.copyCollection(fieldName, targetObject, (Collection)propertyValue, supplementalUncopyable);
                } else {
                    String propertyValueClass;
                    String string = propertyValueClass = ObjectUtils.isNotNull((Object)propertyValue) ? propertyValue.getClass().toString() : "(null)";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("attempting to set field '" + fieldName + "' using base class '" + baseClassName + "' and property value class '" + propertyValueClass + "'");
                    }
                    ObjectUtils.setObjectProperty((Object)targetObject, (String)fieldName, (Object)propertyValue);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("couldn't set field '" + fieldName + "' using base class '" + baseClassName + "' due to exception with class name '" + e.getClass().getName() + "'", (Throwable)e);
            }
        }
    }

    protected static <T extends BusinessObject> void copyCollection(String fieldName, BusinessObject targetObject, Collection<T> sourceList, Map supplementalUncopyable) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList<BusinessObject> listToSet;
        if (ObjectUtils.isNotNull(sourceList)) {
            ObjectUtils.materializeObjects(sourceList);
        }
        try {
            listToSet = (ArrayList<BusinessObject>)sourceList.getClass().newInstance();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("couldn't set class '" + sourceList.getClass() + "' on collection..." + fieldName + " using " + sourceList.getClass());
            }
            listToSet = new ArrayList<BusinessObject>();
        }
        for (BusinessObject sourceCollectionObject : sourceList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("attempting to copy collection member with class '" + sourceCollectionObject.getClass() + "'");
            }
            BusinessObject targetCollectionObject = (BusinessObject)PurApObjectUtils.createNewObjectFromClass(sourceCollectionObject.getClass());
            PurApObjectUtils.populateFromBaseWithSuper(sourceCollectionObject, targetCollectionObject, supplementalUncopyable, new HashSet<Class>());
            Map pkMap = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)targetCollectionObject);
            Set pkFields = pkMap.keySet();
            for (String field : pkFields) {
                ObjectUtils.setObjectProperty((Object)targetCollectionObject, (String)field, null);
            }
            listToSet.add(targetCollectionObject);
        }
        ObjectUtils.setObjectProperty((Object)targetObject, (String)fieldName, listToSet);
    }

    protected static Object createNewObjectFromClass(Class clazz) {
        if (clazz == null) {
            throw new RuntimeException("BO class was passed in as null");
        }
        try {
            if (clazz.getSuperclass().equals(ExternalizableBusinessObject.class)) {
                Class eboInterface = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface((Class)clazz);
                ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(eboInterface);
                return moduleService.createNewObjectFromExternalizableClass(eboInterface);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while trying to create a new instance for class " + clazz);
        }
    }

    public static void populateFromBaseClass(Class base, BusinessObject src, BusinessObject target) {
        PurApObjectUtils.populateFromBaseClass(base, src, target, new HashMap());
    }

    public static void populateFromBaseWithSuper(BusinessObject sourceObject, BusinessObject targetObject, Map supplementalUncopyableFieldNames, Set<Class> classesToExclude) {
        ArrayList classesToCopy = new ArrayList();
        Class<?> sourceObjectClass = sourceObject.getClass();
        classesToCopy.add(sourceObjectClass);
        while (sourceObjectClass.getSuperclass() != null) {
            if (classesToExclude.contains(sourceObjectClass = sourceObjectClass.getSuperclass())) continue;
            classesToCopy.add(sourceObjectClass);
        }
        for (int i = classesToCopy.size() - 1; i >= 0; --i) {
            Class temp = (Class)classesToCopy.get(i);
            PurApObjectUtils.populateFromBaseClass(temp, sourceObject, targetObject, supplementalUncopyableFieldNames);
        }
    }

    public static BusinessObject retrieveObjectWithIdentitcalKey(Collection controlList, BusinessObject bo) {
        BusinessObject returnBo = null;
        for (Object control : controlList) {
            BusinessObject listBo = (BusinessObject)control;
            if (!PurApObjectUtils.equalByKeys(listBo, bo)) continue;
            returnBo = listBo;
        }
        return returnBo;
    }

    public static boolean equalByKeys(BusinessObject bo1, BusinessObject bo2) {
        if (bo1 == null && bo2 == null) {
            return true;
        }
        if (bo1 == null || bo2 == null) {
            return false;
        }
        if (!bo1.getClass().getName().equals(bo2.getClass().getName())) {
            return false;
        }
        Map bo1Keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)bo1);
        Map bo2Keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)bo2);
        for (Object key : bo1Keys.keySet()) {
            String keyName = (String)key;
            if (bo1Keys.get(keyName) != null && bo2Keys.get(keyName) != null) {
                if (bo1Keys.get(keyName).toString().equals(bo2Keys.get(keyName).toString())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

