/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Mar 7, 2006
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElectronicInvoiceContact {

    private String role;
    private String addressID;
    private String name;
    private List postalAddresses = new ArrayList();
    private Map<String, String> emailAddresses = new HashMap<>();
    private Map<String, String> phoneNumbers = new HashMap<>();
    private Map<String, String> faxNumbers = new HashMap<>();
    private List<String> webAddresses = new ArrayList<>();

    public ElectronicInvoiceContact() {
        super();
    }

    public void addPostalAddress(ElectronicInvoicePostalAddress cpa) {
        this.postalAddresses.add(cpa);
    }

    public void addEmailAddress(String name, String address) {
        this.emailAddresses.put(name, address);
    }

    public void addPhoneNumber(String name, String countryCode, String cityOrAreaCode, String number) {
        this.phoneNumbers.put(name, countryCode + cityOrAreaCode + number);
    }

    public void addFaxNumber(String name, String countryCode, String cityOrAreaCode, String number) {
        this.faxNumbers.put(name, countryCode + cityOrAreaCode + number);
    }

    public void addFaxNumber(String name, String number) {
        this.faxNumbers.put(name, number);
    }

    public void addWebAddress(String address) {
        this.webAddresses.add(address);
    }

    public String getAddressID() {
        return addressID;
    }

    public void setAddressID(String addressID) {
        this.addressID = addressID;
    }

    public Map<String, String> getEmailAddresses() {
        return emailAddresses;
    }

    public void setEmailAddresses(Map emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public Map<String, String> getFaxNumbers() {
        return faxNumbers;
    }

    public void setFaxNumbers(Map faxNumbers) {
        this.faxNumbers = faxNumbers;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getPhoneNumbers() {
        return phoneNumbers;
    }

    public void setPhoneNumbers(Map phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public List<ElectronicInvoicePostalAddress> getPostalAddresses() {
        return postalAddresses;
    }

    public void setPostalAddresses(List<ElectronicInvoicePostalAddress> postalAddresses) {
        this.postalAddresses = postalAddresses;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public List<String> getWebAddresses() {
        return webAddresses;
    }

    public void setWebAddresses(List webAddresses) {
        this.webAddresses = webAddresses;
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder(this);
        toString.append("Role", getRole());
        toString.append("Name", getName());
        toString.append("AddressId", getAddressID());
        toString.append("PostalAddress", getPostalAddresses());
        toString.append("EmailAddresses", getEmailAddresses());
        toString.append("phoneNumbers", getPhoneNumbers());
        toString.append("FaxNumbers", getFaxNumbers());
        toString.append("URLs", getWebAddresses());
        return toString.toString();
    }
}


