/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;

/**
 * Purap Accounting Line Interface.
 */
public interface PurApAccountingLine extends AccountingLine {

    Integer getAccountIdentifier();

    void setAccountIdentifier(Integer accountIdentifier);

    Integer getItemIdentifier();

    void setItemIdentifier(Integer itemIdentifier);

    BigDecimal getAccountLinePercent();

    void setAccountLinePercent(BigDecimal accountLinePercent);

    Integer getSequenceNumber();

    void setSequenceNumber(Integer sequenceNumber);

    Integer getPurApSequenceNumber();

    /**
     * @return boolean true if the current purap accounting line is in an empty state.
     */
    boolean isEmpty();

    /**
     * Creates a copy of the current purap accounting line and sets the percentage and the amount to zero.
     *
     * @return purap accounting line copy with blank percent and amount
     */
    PurApAccountingLine createBlankAmountsCopy();

    /**
     * Compares the current accounting line values with a source accounting line to see if both accounting lines are
     * equal.
     *
     * @param accountingLine accounting line to compare
     * @return boolean true if passed in and current accounting line are equal, false otherwise
     */
    boolean accountStringsAreEqual(SourceAccountingLine accountingLine);

    /**
     * Compares the current accounting line values with a purap accounting line to see if both accounting lines are
     * equal.
     *
     * @param accountingLine accounting line to compare
     * @return boolean true if passed in and current accounting line are equal, false otherwise
     */
    boolean accountStringsAreEqual(PurApAccountingLine accountingLine);

    /**
     * @return source accounting line based on current purap accounting line
     */
    SourceAccountingLine generateSourceAccountingLine();

    KualiDecimal getAlternateAmountForGLEntryCreation();

    void setAlternateAmountForGLEntryCreation(KualiDecimal alternateAmountForGLEntryCreation);

    <T extends PurApItem> T getPurapItem();

    void setPurapItem(PurApItem item);

    /**
     * @return String representation of accounting line for user uniqueness so it should not include fields like
     *         sequence number or object id
     */
    String getString();

    String getPostingPeriodCode();

    void setPostingPeriodCode(String postingPeriodCode);

}
