/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.dataaccess;

import org.kuali.kfs.module.purap.businessobject.AutoClosePurchaseOrderView;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;

import java.util.List;

public interface PurchaseOrderDao {

    Integer getPurchaseOrderIdForCurrentPurchaseOrderByRelatedDocId(
            Integer accountsPayablePurchasingDocumentLinkIdentifier);

    PurchaseOrderDocument getCurrentPurchaseOrder(Integer id);

    /**
     * @param id purapDocument Identifier
     * @return the document number of the purchase order found using the purapDocumentIdentifier as criteria or null
     *         if no purchase order found
     */
    String getDocumentNumberForPurchaseOrderId(Integer id);

    /**
     * @param id purapDocument Identifier
     * @return the document number of the purchase order found using the purapDocumentIdentifier or null if no
     *         purchase order found
     */
    String getDocumentNumberForCurrentPurchaseOrder(Integer id);

    /**
     * @param id the purapDocumentIdentifier.
     * @return the document numbers of the the oldest purchase order's (defined by the one having the smallest
     *         document number) document number or null if none found
     */
    String getOldestPurchaseOrderDocumentNumber(Integer id);

    /**
     * Determines if the purchase order item exists on the current purchase order.
     *
     * @param poItemLineNumber
     * @param docNumber
     * @return
     */
    boolean itemExistsOnPurchaseOrder(Integer poItemLineNumber, String docNumber);

    /**
     * @param excludedVendorChoiceCodes list of strings of excluded vendor choice codes
     * @return List of PurchaseOrderAutoClose objects that relate to POs with no recurring payment type, status of
     *         'OPEN', and total encumbrance of 0 that do not have any of the excluded vendor choice codes.
     */
    List<AutoClosePurchaseOrderView> getAllOpenPurchaseOrders(List<String> excludedVendorChoiceCodes);

    /**
     * @param excludedVendorChoiceCodes list of strings of excluded vendor choice codes
     * @return List of PurchaseOrderAutoClose objects that relate to POs with a recurring payment type, status of
     *         'OPEN', and that do not have any of the excluded vendor choice codes.
     */
    List<AutoClosePurchaseOrderView> getAutoCloseRecurringPurchaseOrders(List<String> excludedVendorChoiceCodes);

    /**
     * @return List of all the Purchase orders that are waiting for faxing.
     */
    List<PurchaseOrderDocument> getPendingPurchaseOrdersForFaxing();
}
