/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.PurapParameterConstants;
import org.kuali.kfs.module.purap.PurapRuleConstants;
import org.kuali.kfs.module.purap.document.RequisitionDocument;

public class RequisitionNewIndividualItemValidation extends PurchasingNewIndividualItemValidation {

    @Override
    protected boolean commodityCodeIsRequired() {
        // if the ENABLE_COMMODITY_CODE_IND parameter is N then we don't need to check for the
        // ITEMS_REQUIRE_COMMODITY_CODE_IND parameter anymore, just return false.
        boolean enableCommodityCode = parameterService.getParameterValueAsBoolean(PurapConstants.PURAP_NAMESPACE,
                "Document", PurapParameterConstants.ENABLE_COMMODITY_CODE_IND);
        if (!enableCommodityCode) {
            return false;
        } else {
            return parameterService.getParameterValueAsBoolean(RequisitionDocument.class,
                    PurapRuleConstants.ITEMS_REQUIRE_COMMODITY_CODE_IND);
        }
    }

}
