/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.util;

import org.apache.commons.lang3.EnumUtils;

import java.util.List;

public enum ThresholdCriteria {

    CHART("CHART"),
    CHART_AND_ACCOUNTTYPE("CHART_AND_ACCOUNT-TYPE"),
    CHART_AND_SUBFUND("CHART_AND_SUB-FUND"),
    CHART_AND_COMMODITYCODE("CHART_AND_COMMODITY-CODE"),
    CHART_AND_OBJECTCODE("CHART_AND_OBJECT-CODE"),
    CHART_AND_ORGANIZATIONCODE("CHART_AND_ORGANIZATION-CODE"),
    CHART_AND_VENDOR("CHART_AND_VENDOR");

    public final String name;

    ThresholdCriteria(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static List<ThresholdCriteria> getEnumList() {
        return EnumUtils.getEnumList(ThresholdCriteria.class);
    }

}
