/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItemBase;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.ObjectPopulationUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class PaymentRequestItem
extends AccountsPayableItemBase {
    private static final Logger LOG = LogManager.getLogger(PaymentRequestItem.class);
    private BigDecimal purchaseOrderItemUnitPrice;
    private KualiDecimal itemOutstandingInvoiceQuantity;
    private KualiDecimal itemOutstandingInvoiceAmount;

    public PaymentRequestItem() {
    }

    public PaymentRequestItem(PurchaseOrderItem poi, PaymentRequestDocument preq) {
        this(poi, preq, new HashMap<String, ExpiredOrClosedAccountEntry>());
    }

    public PaymentRequestItem(PurchaseOrderItem poi, PaymentRequestDocument preq, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        ObjectPopulationUtils.populateFromBaseClass(PurApItemBase.class, (BusinessObject)poi, (BusinessObject)this, PurapConstants.PREQ_ITEM_UNCOPYABLE_FIELDS);
        this.setItemDescription(poi.getItemDescription());
        this.resetAccount();
        ArrayList<PurApAccountingLine> accounts = new ArrayList<PurApAccountingLine>();
        for (PurApAccountingLine account : poi.getSourceAccountingLines()) {
            PurchaseOrderAccount poa = (PurchaseOrderAccount)account;
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).processExpiredOrClosedAccount(poa, expiredOrClosedAccountList);
            if (poa.getAmount().isZero()) {
                if (!((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).canCopyAccountingLinesWithZeroAmount()) continue;
                accounts.add(new PaymentRequestAccount(this, poa));
                continue;
            }
            accounts.add(new PaymentRequestAccount(this, poa));
        }
        this.setSourceAccountingLines(accounts);
        this.getUseTaxItems().clear();
        if (ObjectUtils.isNotNull((Object)((Object)this.getItemType())) && this.getItemType().isAmountBasedGeneralLedgerIndicator()) {
            this.setItemUnitPrice(null);
        }
        this.purchaseOrderItemUnitPrice = poi.getItemUnitPrice();
        this.setPurapDocumentIdentifier(preq.getPurapDocumentIdentifier());
        this.setPurapDocument(preq);
    }

    @Override
    public PurchaseOrderItem getPurchaseOrderItem() {
        if (ObjectUtils.isNotNull((Object)this.getPurapDocumentIdentifier()) && ObjectUtils.isNull((Object)this.getPaymentRequest())) {
            this.refreshReferenceObject("purapDocument");
        }
        if (this.getPaymentRequest() != null) {
            PurchaseOrderDocument po = this.getPaymentRequest().getPurchaseOrderDocument();
            PurchaseOrderItem poi = null;
            if (this.getItemType().isLineItemIndicator()) {
                List items = po.getItems();
                if (items != null) {
                    for (Object object : items) {
                        PurchaseOrderItem item = (PurchaseOrderItem)object;
                        if (item == null || !item.getItemLineNumber().equals(this.getItemLineNumber())) continue;
                        poi = item;
                        break;
                    }
                }
            } else {
                poi = (PurchaseOrderItem)((PurapService)SpringContext.getBean(PurapService.class)).getBelowTheLineByType(po, this.getItemType());
            }
            if (poi != null) {
                return poi;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getPurchaseOrderItem() Returning null because PurchaseOrderItem object for line number" + this.getItemLineNumber() + "or itemType " + this.getItemTypeCode() + " is null");
            }
            return null;
        }
        LOG.error("getPurchaseOrderItem() Returning null because paymentRequest object is null");
        throw new PurError("Payment Request Object in Purchase Order item line number " + this.getItemLineNumber() + "or itemType " + this.getItemTypeCode() + " is null");
    }

    public KualiDecimal getPoOutstandingAmount() {
        PurchaseOrderItem poi = this.getPurchaseOrderItem();
        if (ObjectUtils.isNull((Object)this.getPurchaseOrderItemUnitPrice()) || KualiDecimal.ZERO.equals((Object)this.getPurchaseOrderItemUnitPrice())) {
            return null;
        }
        return this.getPoOutstandingAmount(poi);
    }

    private KualiDecimal getPoOutstandingAmount(PurchaseOrderItem poi) {
        if (poi == null) {
            return KualiDecimal.ZERO;
        }
        return poi.getItemOutstandingEncumberedAmount();
    }

    public KualiDecimal getPoOriginalAmount() {
        PurchaseOrderItem poi = this.getPurchaseOrderItem();
        if (poi == null) {
            return null;
        }
        return poi.getExtendedPrice();
    }

    @Deprecated
    public void setPoOutstandingAmount(KualiDecimal amount) {
    }

    public KualiDecimal getPoOutstandingQuantity() {
        PurchaseOrderItem poi = this.getPurchaseOrderItem();
        if (poi == null) {
            return null;
        }
        if ("SRVC".equals(this.getItemTypeCode())) {
            return null;
        }
        return poi.getOutstandingQuantity();
    }

    @Deprecated
    public void setPoOutstandingQuantity(KualiDecimal qty) {
    }

    public BigDecimal getPurchaseOrderItemUnitPrice() {
        return this.purchaseOrderItemUnitPrice;
    }

    public BigDecimal getOriginalAmountfromPO() {
        return this.purchaseOrderItemUnitPrice;
    }

    public void setOriginalAmountfromPO(BigDecimal purchaseOrderItemUnitPrice) {
    }

    public void setPurchaseOrderItemUnitPrice(BigDecimal purchaseOrderItemUnitPrice) {
        this.purchaseOrderItemUnitPrice = purchaseOrderItemUnitPrice;
    }

    public KualiDecimal getItemOutstandingInvoiceAmount() {
        return this.itemOutstandingInvoiceAmount;
    }

    public void setItemOutstandingInvoiceAmount(KualiDecimal itemOutstandingInvoiceAmount) {
        this.itemOutstandingInvoiceAmount = itemOutstandingInvoiceAmount;
    }

    public KualiDecimal getItemOutstandingInvoiceQuantity() {
        return this.itemOutstandingInvoiceQuantity;
    }

    public void setItemOutstandingInvoiceQuantity(KualiDecimal itemOutstandingInvoiceQuantity) {
        this.itemOutstandingInvoiceQuantity = itemOutstandingInvoiceQuantity;
    }

    public PaymentRequestDocument getPaymentRequest() {
        if (ObjectUtils.isNotNull((Object)this.getPurapDocumentIdentifier()) && ObjectUtils.isNull(this.getPurapDocument())) {
            this.refreshReferenceObject("purapDocument");
        }
        return (PaymentRequestDocument)super.getPurapDocument();
    }

    public void setPaymentRequest(PaymentRequestDocument paymentRequest) {
        this.setPurapDocument(paymentRequest);
    }

    public void generateAccountListFromPoItemAccounts(List<PurApAccountingLine> accounts) {
        for (PurApAccountingLine line : accounts) {
            PurchaseOrderAccount poa = (PurchaseOrderAccount)line;
            if (line.isEmpty()) continue;
            this.getSourceAccountingLines().add(new PaymentRequestAccount(this, poa));
        }
    }

    @Override
    public Class getAccountingLineClass() {
        return PaymentRequestAccount.class;
    }

    public boolean isDisplayOnPreq() {
        PurchaseOrderItem poi = this.getPurchaseOrderItem();
        if (ObjectUtils.isNull((Object)poi)) {
            LOG.debug("poi was null");
            return false;
        }
        if (!poi.isItemActiveIndicator()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("poi was not active: " + poi.toString());
            }
            return false;
        }
        ItemType poiType = poi.getItemType();
        if (poiType.isQuantityBasedGeneralLedgerIndicator()) {
            if (poi.getItemQuantity().isGreaterThan((AbstractKualiDecimal)poi.getItemInvoicedTotalQuantity())) {
                return true;
            }
            return ObjectUtils.isNotNull((Object)this.getItemQuantity()) && this.getItemQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO);
        }
        if (poi.getItemOutstandingEncumberedAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return true;
        }
        return PurApItemUtils.isNonZeroExtended(this);
    }

    @Override
    public void resetAccount() {
        super.resetAccount();
        this.getNewSourceLine().setAmount(null);
        this.getNewSourceLine().setAccountLinePercent(null);
    }

    public void addToUnitPrice(BigDecimal addThisValue) {
        if (this.getItemUnitPrice() == null) {
            this.setItemUnitPrice(BigDecimal.ZERO);
        }
        BigDecimal addedPrice = this.getItemUnitPrice().add(addThisValue);
        this.setItemUnitPrice(addedPrice);
    }

    public void addToExtendedPrice(KualiDecimal addThisValue) {
        if (this.getExtendedPrice() == null) {
            this.setExtendedPrice(KualiDecimal.ZERO);
        }
        KualiDecimal addedPrice = (KualiDecimal)this.getExtendedPrice().add((AbstractKualiDecimal)addThisValue);
        this.setExtendedPrice(addedPrice);
    }

    @Override
    public Class getUseTaxClass() {
        return PaymentRequestItemUseTax.class;
    }
}

