/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.Carrier;
import org.kuali.kfs.module.purap.businessobject.CorrectionReceivingItem;
import org.kuali.kfs.module.purap.businessobject.DeliveryRequiredDateReason;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingItem;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocumentBase;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class CorrectionReceivingDocument
extends ReceivingDocumentBase {
    protected String lineItemReceivingDocumentNumber;
    protected List<CorrectionReceivingItem> items = new ArrayList<CorrectionReceivingItem>();
    protected LineItemReceivingDocument lineItemReceivingDocument;

    public void populateCorrectionReceivingFromReceivingLine(LineItemReceivingDocument rlDoc) {
        this.setPurchaseOrderIdentifier(rlDoc.getPurchaseOrderIdentifier());
        this.getDocumentHeader().setDocumentDescription(rlDoc.getDocumentHeader().getDocumentDescription());
        this.getDocumentHeader().setOrganizationDocumentNumber(rlDoc.getDocumentHeader().getOrganizationDocumentNumber());
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(rlDoc.getAccountsPayablePurchasingDocumentLinkIdentifier());
        this.setLineItemReceivingDocumentNumber(rlDoc.getDocumentNumber());
        for (LineItemReceivingItem rli : rlDoc.getItems()) {
            this.getItems().add(new CorrectionReceivingItem(rli, this));
        }
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
            ((ReceivingService)SpringContext.getBean(ReceivingService.class)).completeCorrectionReceivingDocument(this);
        }
        super.doRouteStatusChange(statusChangeEvent);
    }

    public String getLineItemReceivingDocumentNumber() {
        return this.lineItemReceivingDocumentNumber;
    }

    public void setLineItemReceivingDocumentNumber(String lineItemReceivingDocumentNumber) {
        this.lineItemReceivingDocumentNumber = lineItemReceivingDocumentNumber;
    }

    public LineItemReceivingDocument getLineItemReceivingDocument() {
        this.refreshLineReceivingDocument();
        return this.lineItemReceivingDocument;
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        this.refreshLineReceivingDocument();
    }

    protected void refreshLineReceivingDocument() {
        if (ObjectUtils.isNull((Object)this.lineItemReceivingDocument) || this.lineItemReceivingDocument.getDocumentNumber() == null) {
            this.refreshReferenceObject("lineItemReceivingDocument");
            if (ObjectUtils.isNull((Object)this.lineItemReceivingDocument.getDocumentHeader().getDocumentNumber())) {
                this.lineItemReceivingDocument.refreshReferenceObject("documentHeader");
            }
        } else if (ObjectUtils.isNull((Object)this.lineItemReceivingDocument.getDocumentHeader().getDocumentNumber())) {
            this.lineItemReceivingDocument.refreshReferenceObject("documentHeader");
        }
    }

    @Override
    public Integer getPurchaseOrderIdentifier() {
        if (ObjectUtils.isNull((Object)super.getPurchaseOrderIdentifier())) {
            this.refreshLineReceivingDocument();
            if (ObjectUtils.isNotNull((Object)this.lineItemReceivingDocument)) {
                this.setPurchaseOrderIdentifier(this.lineItemReceivingDocument.getPurchaseOrderIdentifier());
            }
        }
        return super.getPurchaseOrderIdentifier();
    }

    public void setLineItemReceivingDocument(LineItemReceivingDocument lineItemReceivingDocument) {
        this.lineItemReceivingDocument = lineItemReceivingDocument;
    }

    @Override
    public Class getItemClass() {
        return CorrectionReceivingItem.class;
    }

    @Override
    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public ReceivingItem getItem(int pos) {
        return this.items.get(pos);
    }

    public void addItem(ReceivingItem item) {
        this.getItems().add(item);
    }

    public void deleteItem(int lineNum) {
        this.getItems().remove(lineNum);
    }

    @Override
    public Integer getAlternateVendorDetailAssignedIdentifier() {
        return this.getLineItemReceivingDocument().getAlternateVendorDetailAssignedIdentifier();
    }

    @Override
    public Integer getAlternateVendorHeaderGeneratedIdentifier() {
        return this.getLineItemReceivingDocument().getAlternateVendorHeaderGeneratedIdentifier();
    }

    @Override
    public String getAlternateVendorName() {
        return this.getLineItemReceivingDocument().getAlternateVendorName();
    }

    @Override
    public String getAlternateVendorNumber() {
        return this.getLineItemReceivingDocument().getAlternateVendorNumber();
    }

    @Override
    public Carrier getCarrier() {
        return this.getLineItemReceivingDocument().getCarrier();
    }

    @Override
    public String getCarrierCode() {
        return this.getLineItemReceivingDocument().getCarrierCode();
    }

    @Override
    public String getDeliveryBuildingCode() {
        return this.getLineItemReceivingDocument().getDeliveryBuildingCode();
    }

    @Override
    public String getDeliveryBuildingLine1Address() {
        return this.getLineItemReceivingDocument().getDeliveryBuildingLine1Address();
    }

    @Override
    public String getDeliveryBuildingLine2Address() {
        return this.getLineItemReceivingDocument().getDeliveryBuildingLine2Address();
    }

    @Override
    public String getDeliveryBuildingName() {
        return this.getLineItemReceivingDocument().getDeliveryBuildingName();
    }

    @Override
    public String getDeliveryBuildingRoomNumber() {
        return this.getLineItemReceivingDocument().getDeliveryBuildingRoomNumber();
    }

    @Override
    public CampusParameter getDeliveryCampus() {
        return this.getLineItemReceivingDocument().getDeliveryCampus();
    }

    @Override
    public String getDeliveryCampusCode() {
        return this.getLineItemReceivingDocument().getDeliveryCampusCode();
    }

    @Override
    public String getDeliveryCityName() {
        return this.getLineItemReceivingDocument().getDeliveryCityName();
    }

    @Override
    public String getDeliveryCountryCode() {
        return this.getLineItemReceivingDocument().getDeliveryCountryCode();
    }

    @Override
    public String getDeliveryInstructionText() {
        return this.getLineItemReceivingDocument().getDeliveryInstructionText();
    }

    @Override
    public String getDeliveryPostalCode() {
        return this.getLineItemReceivingDocument().getDeliveryPostalCode();
    }

    @Override
    public Date getDeliveryRequiredDate() {
        return this.getLineItemReceivingDocument().getDeliveryRequiredDate();
    }

    @Override
    public DeliveryRequiredDateReason getDeliveryRequiredDateReason() {
        return this.getLineItemReceivingDocument().getDeliveryRequiredDateReason();
    }

    @Override
    public String getDeliveryRequiredDateReasonCode() {
        return this.getLineItemReceivingDocument().getDeliveryRequiredDateReasonCode();
    }

    @Override
    public String getDeliveryStateCode() {
        return this.getLineItemReceivingDocument().getDeliveryStateCode();
    }

    @Override
    public String getDeliveryToEmailAddress() {
        return this.getLineItemReceivingDocument().getDeliveryToEmailAddress();
    }

    @Override
    public String getDeliveryToName() {
        return this.getLineItemReceivingDocument().getDeliveryToName();
    }

    @Override
    public String getDeliveryToPhoneNumber() {
        return this.getLineItemReceivingDocument().getDeliveryToPhoneNumber();
    }

    @Override
    public String getShipmentBillOfLadingNumber() {
        return this.getLineItemReceivingDocument().getShipmentBillOfLadingNumber();
    }

    @Override
    public String getShipmentPackingSlipNumber() {
        return this.getLineItemReceivingDocument().getShipmentPackingSlipNumber();
    }

    @Override
    public Date getShipmentReceivedDate() {
        return this.getLineItemReceivingDocument().getShipmentReceivedDate();
    }

    @Override
    public String getShipmentReferenceNumber() {
        return this.getLineItemReceivingDocument().getShipmentReferenceNumber();
    }

    @Override
    public Integer getVendorAddressGeneratedIdentifier() {
        return this.getLineItemReceivingDocument().getVendorAddressGeneratedIdentifier();
    }

    @Override
    public String getVendorCityName() {
        return this.getLineItemReceivingDocument().getVendorCityName();
    }

    @Override
    public Country getVendorCountry() {
        return this.getLineItemReceivingDocument().getVendorCountry();
    }

    @Override
    public String getVendorCountryCode() {
        return this.getLineItemReceivingDocument().getVendorCountryCode();
    }

    @Override
    public VendorDetail getVendorDetail() {
        return this.getLineItemReceivingDocument().getVendorDetail();
    }

    @Override
    public Integer getVendorDetailAssignedIdentifier() {
        return this.getLineItemReceivingDocument().getVendorDetailAssignedIdentifier();
    }

    @Override
    public Integer getVendorHeaderGeneratedIdentifier() {
        return this.getLineItemReceivingDocument().getVendorHeaderGeneratedIdentifier();
    }

    @Override
    public String getVendorLine1Address() {
        return this.getLineItemReceivingDocument().getVendorLine1Address();
    }

    @Override
    public String getVendorLine2Address() {
        return this.getLineItemReceivingDocument().getVendorLine2Address();
    }

    @Override
    public String getVendorName() {
        return this.getLineItemReceivingDocument().getVendorName();
    }

    @Override
    public String getVendorNumber() {
        return this.getLineItemReceivingDocument().getVendorNumber();
    }

    @Override
    public String getVendorPostalCode() {
        return this.getLineItemReceivingDocument().getVendorPostalCode();
    }

    @Override
    public String getVendorStateCode() {
        return this.getLineItemReceivingDocument().getVendorStateCode();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getItems());
        return managedLists;
    }
}

