/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RecurringPaymentType;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.PaymentTermType;
import org.kuali.kfs.vnd.businessobject.PurchaseOrderCostSource;
import org.kuali.kfs.vnd.businessobject.ShippingPaymentTerms;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class PaymentRequestDocument
extends AccountsPayableDocumentBase {
    private static final Logger LOG = LogManager.getLogger(PaymentRequestDocument.class);
    protected Date invoiceDate;
    protected String invoiceNumber;
    protected KualiDecimal vendorInvoiceAmount;
    protected String vendorPaymentTermsCode;
    protected String vendorShippingPaymentTermsCode;
    protected Date paymentRequestPayDate;
    protected String paymentRequestCostSourceCode;
    protected boolean paymentRequestedCancelIndicator;
    protected boolean paymentAttachmentIndicator;
    protected boolean immediatePaymentIndicator;
    protected String specialHandlingInstructionLine1Text;
    protected String specialHandlingInstructionLine2Text;
    protected String specialHandlingInstructionLine3Text;
    protected Timestamp paymentPaidTimestamp;
    protected boolean paymentRequestElectronicInvoiceIndicator;
    protected String accountsPayableRequestCancelIdentifier;
    protected Integer originalVendorHeaderGeneratedIdentifier;
    protected Integer originalVendorDetailAssignedIdentifier;
    protected Integer alternateVendorHeaderGeneratedIdentifier;
    protected Integer alternateVendorDetailAssignedIdentifier;
    protected String purchaseOrderNotes;
    protected String recurringPaymentTypeCode;
    protected boolean receivingDocumentRequiredIndicator;
    protected boolean paymentRequestPositiveApprovalIndicator;
    private boolean achSignUpStatusFlag;
    protected boolean autoApprovedIndicator;
    protected String taxClassificationCode;
    protected String taxCountryCode;
    protected String taxNQIId;
    protected BigDecimal taxFederalPercent;
    protected BigDecimal taxStatePercent;
    protected KualiDecimal taxSpecialW4Amount;
    protected Boolean taxGrossUpIndicator;
    protected Boolean taxExemptTreatyIndicator;
    protected Boolean taxForeignSourceIndicator;
    protected Boolean taxUSAIDPerDiemIndicator;
    protected Boolean taxOtherExemptIndicator;
    protected String justification;
    protected String vendorShippingTitleCode;
    protected Date purchaseOrderEndDate;
    protected String primaryVendorName;
    protected Integer requisitionIdentifier;
    protected PaymentTermType vendorPaymentTerms;
    protected ShippingPaymentTerms vendorShippingPaymentTerms;
    protected PurchaseOrderCostSource paymentRequestCostSource;
    protected RecurringPaymentType recurringPaymentType;

    public PaymentRequestDocument() {
        this.setAutoApprovedIndicator(false);
    }

    public boolean isBoNotesSupport() {
        return true;
    }

    public Integer getPostingYearPriorOrCurrent() {
        if (((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).allowBackpost(this)) {
            return ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear() - 1;
        }
        return ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
    }

    @Override
    public boolean isInquiryRendered() {
        return !this.isPostingYearPrior() || !this.getApplicationDocumentStatus().equals("Department-Approved") && !this.getApplicationDocumentStatus().equals("Auto-Approved") && !this.getApplicationDocumentStatus().equals("Cancelled") && !this.getApplicationDocumentStatus().equals("Cancelled In Process");
    }

    public Integer getRequisitionIdentifier() {
        return this.getPurchaseOrderDocument().getRequisitionIdentifier();
    }

    public void setRequisitionIdentifier(Integer requisitionIdentifier) {
        this.requisitionIdentifier = requisitionIdentifier;
    }

    @Override
    public void populateDocumentForRouting() {
        this.setRequisitionIdentifier(this.getPurchaseOrderDocument().getRequisitionIdentifier());
        super.populateDocumentForRouting();
    }

    public boolean isEnableReceivingDocumentRequiredIndicator() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "RECEIVING_DOCUMENT_REQUIRED_IND");
    }

    public boolean isEnablePaymentRequestPositiveApprovalIndicator() {
        return ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PAYMENT_REQUEST_POSITIVE_APPROVAL_IND");
    }

    public Date getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = !StringUtils.isEmpty((CharSequence)invoiceNumber) ? invoiceNumber.toUpperCase() : invoiceNumber;
    }

    public KualiDecimal getVendorInvoiceAmount() {
        return this.vendorInvoiceAmount;
    }

    public void setVendorInvoiceAmount(KualiDecimal vendorInvoiceAmount) {
        this.vendorInvoiceAmount = vendorInvoiceAmount;
    }

    public String getVendorPaymentTermsCode() {
        return this.vendorPaymentTermsCode;
    }

    public void setVendorPaymentTermsCode(String vendorPaymentTermsCode) {
        this.vendorPaymentTermsCode = vendorPaymentTermsCode;
        this.refreshReferenceObject("vendorPaymentTerms");
    }

    public PaymentTermType getVendorPaymentTerms() {
        if (ObjectUtils.isNull((Object)this.vendorPaymentTerms) || !StringUtils.equalsIgnoreCase((CharSequence)this.getVendorPaymentTermsCode(), (CharSequence)this.vendorPaymentTerms.getVendorPaymentTermsCode())) {
            this.refreshReferenceObject("vendorPaymentTerms");
        }
        return this.vendorPaymentTerms;
    }

    public void setVendorPaymentTerms(PaymentTermType vendorPaymentTerms) {
        this.vendorPaymentTerms = vendorPaymentTerms;
    }

    public String getVendorShippingPaymentTermsCode() {
        if (ObjectUtils.isNull((Object)this.vendorPaymentTerms)) {
            this.refreshReferenceObject("vendorShippingPaymentTerms");
        }
        return this.vendorShippingPaymentTermsCode;
    }

    public void setVendorShippingPaymentTermsCode(String vendorShippingPaymentTermsCode) {
        this.vendorShippingPaymentTermsCode = vendorShippingPaymentTermsCode;
    }

    public Date getPaymentRequestPayDate() {
        return this.paymentRequestPayDate;
    }

    public void setPaymentRequestPayDate(Date paymentRequestPayDate) {
        this.paymentRequestPayDate = paymentRequestPayDate;
    }

    public String getPaymentRequestCostSourceCode() {
        return this.paymentRequestCostSourceCode;
    }

    public void setPaymentRequestCostSourceCode(String paymentRequestCostSourceCode) {
        this.paymentRequestCostSourceCode = paymentRequestCostSourceCode;
    }

    public boolean getPaymentRequestedCancelIndicator() {
        return this.paymentRequestedCancelIndicator;
    }

    public boolean isPaymentRequestedCancelIndicator() {
        return this.paymentRequestedCancelIndicator;
    }

    public void setPaymentRequestedCancelIndicator(boolean paymentRequestedCancelIndicator) {
        this.paymentRequestedCancelIndicator = paymentRequestedCancelIndicator;
    }

    public boolean getPaymentAttachmentIndicator() {
        return this.paymentAttachmentIndicator;
    }

    public void setPaymentAttachmentIndicator(boolean paymentAttachmentIndicator) {
        this.paymentAttachmentIndicator = paymentAttachmentIndicator;
    }

    public boolean getImmediatePaymentIndicator() {
        return this.immediatePaymentIndicator;
    }

    public void setImmediatePaymentIndicator(boolean immediatePaymentIndicator) {
        this.immediatePaymentIndicator = immediatePaymentIndicator;
    }

    public String getSpecialHandlingInstructionLine1Text() {
        return this.specialHandlingInstructionLine1Text;
    }

    public void setSpecialHandlingInstructionLine1Text(String specialHandlingInstructionLine1Text) {
        this.specialHandlingInstructionLine1Text = specialHandlingInstructionLine1Text;
    }

    public String getSpecialHandlingInstructionLine2Text() {
        return this.specialHandlingInstructionLine2Text;
    }

    public void setSpecialHandlingInstructionLine2Text(String specialHandlingInstructionLine2Text) {
        this.specialHandlingInstructionLine2Text = specialHandlingInstructionLine2Text;
    }

    public String getSpecialHandlingInstructionLine3Text() {
        return this.specialHandlingInstructionLine3Text;
    }

    public void setSpecialHandlingInstructionLine3Text(String specialHandlingInstructionLine3Text) {
        this.specialHandlingInstructionLine3Text = specialHandlingInstructionLine3Text;
    }

    public Timestamp getPaymentPaidTimestamp() {
        return this.paymentPaidTimestamp;
    }

    public void setPaymentPaidTimestamp(Timestamp paymentPaidTimestamp) {
        this.paymentPaidTimestamp = paymentPaidTimestamp;
    }

    public boolean getPaymentRequestElectronicInvoiceIndicator() {
        return this.paymentRequestElectronicInvoiceIndicator;
    }

    public void setPaymentRequestElectronicInvoiceIndicator(boolean paymentRequestElectronicInvoiceIndicator) {
        this.paymentRequestElectronicInvoiceIndicator = paymentRequestElectronicInvoiceIndicator;
    }

    public String getAccountsPayableRequestCancelIdentifier() {
        return this.accountsPayableRequestCancelIdentifier;
    }

    public void setAccountsPayableRequestCancelIdentifier(String accountsPayableRequestCancelIdentifier) {
        this.accountsPayableRequestCancelIdentifier = accountsPayableRequestCancelIdentifier;
    }

    public Integer getOriginalVendorHeaderGeneratedIdentifier() {
        return this.originalVendorHeaderGeneratedIdentifier;
    }

    public void setOriginalVendorHeaderGeneratedIdentifier(Integer originalVendorHeaderGeneratedIdentifier) {
        this.originalVendorHeaderGeneratedIdentifier = originalVendorHeaderGeneratedIdentifier;
    }

    public Integer getOriginalVendorDetailAssignedIdentifier() {
        return this.originalVendorDetailAssignedIdentifier;
    }

    public void setOriginalVendorDetailAssignedIdentifier(Integer originalVendorDetailAssignedIdentifier) {
        this.originalVendorDetailAssignedIdentifier = originalVendorDetailAssignedIdentifier;
    }

    public Integer getAlternateVendorHeaderGeneratedIdentifier() {
        return this.alternateVendorHeaderGeneratedIdentifier;
    }

    public void setAlternateVendorHeaderGeneratedIdentifier(Integer alternateVendorHeaderGeneratedIdentifier) {
        this.alternateVendorHeaderGeneratedIdentifier = alternateVendorHeaderGeneratedIdentifier;
    }

    public Integer getAlternateVendorDetailAssignedIdentifier() {
        return this.alternateVendorDetailAssignedIdentifier;
    }

    public void setAlternateVendorDetailAssignedIdentifier(Integer alternateVendorDetailAssignedIdentifier) {
        this.alternateVendorDetailAssignedIdentifier = alternateVendorDetailAssignedIdentifier;
    }

    public ShippingPaymentTerms getVendorShippingPaymentTerms() {
        return this.vendorShippingPaymentTerms;
    }

    public void setVendorShippingPaymentTerms(ShippingPaymentTerms vendorShippingPaymentTerms) {
        this.vendorShippingPaymentTerms = vendorShippingPaymentTerms;
    }

    public String getVendorShippingTitleCode() {
        if (ObjectUtils.isNotNull((Object)this.getPurchaseOrderDocument())) {
            return this.getPurchaseOrderDocument().getVendorShippingTitleCode();
        }
        return this.vendorShippingTitleCode;
    }

    public void setVendorShippingTitleCode(String vendorShippingTitleCode) {
        this.vendorShippingTitleCode = vendorShippingTitleCode;
    }

    public Date getPurchaseOrderEndDate() {
        return this.purchaseOrderEndDate;
    }

    public void setPurchaseOrderEndDate(Date purchaseOrderEndDate) {
        this.purchaseOrderEndDate = purchaseOrderEndDate;
    }

    public boolean isPaymentRequestPositiveApprovalIndicator() {
        return this.paymentRequestPositiveApprovalIndicator;
    }

    public void setPaymentRequestPositiveApprovalIndicator(boolean paymentRequestPositiveApprovalIndicator) {
        this.paymentRequestPositiveApprovalIndicator = !this.isEnablePaymentRequestPositiveApprovalIndicator() ? false : paymentRequestPositiveApprovalIndicator;
    }

    public boolean isReceivingDocumentRequiredIndicator() {
        return this.receivingDocumentRequiredIndicator;
    }

    public void setReceivingDocumentRequiredIndicator(boolean receivingDocumentRequiredIndicator) {
        this.receivingDocumentRequiredIndicator = !this.isEnableReceivingDocumentRequiredIndicator() ? false : receivingDocumentRequiredIndicator;
    }

    public void initiateDocument() throws WorkflowException {
        LOG.debug("initiateDocument() started");
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        this.updateAndSaveAppDocStatus("Initiated");
        this.setAccountsPayableProcessorIdentifier(currentUser.getPrincipalId());
        this.setProcessingCampusCode(currentUser.getCampusCode());
        this.refreshNonUpdateableReferences();
    }

    public void clearInitFields() {
        LOG.debug("clearDocument() started");
        this.getDocumentHeader().setDocumentDescription(null);
        this.getDocumentHeader().setExplanation(null);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(null);
        this.getDocumentHeader().setOrganizationDocumentNumber(null);
        this.setPurchaseOrderIdentifier(null);
        this.setInvoiceNumber(null);
        this.setInvoiceDate(null);
        this.setVendorInvoiceAmount(null);
        this.setSpecialHandlingInstructionLine1Text(null);
        this.setSpecialHandlingInstructionLine2Text(null);
        this.setSpecialHandlingInstructionLine3Text(null);
    }

    public void populatePaymentRequestFromPurchaseOrder(PurchaseOrderDocument po) {
        this.populatePaymentRequestFromPurchaseOrder(po, new HashMap<String, ExpiredOrClosedAccountEntry>());
    }

    public void populatePaymentRequestFromPurchaseOrder(PurchaseOrderDocument po, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        this.setPurchaseOrderIdentifier(po.getPurapDocumentIdentifier());
        this.getDocumentHeader().setOrganizationDocumentNumber(po.getDocumentHeader().getOrganizationDocumentNumber());
        this.setPostingYear(po.getPostingYear());
        this.setReceivingDocumentRequiredIndicator(po.isReceivingDocumentRequiredIndicator());
        this.setUseTaxIndicator(po.isUseTaxIndicator());
        this.setPaymentRequestPositiveApprovalIndicator(po.isPaymentRequestPositiveApprovalIndicator());
        this.setVendorCustomerNumber(po.getVendorCustomerNumber());
        this.setAccountDistributionMethod(po.getAccountDistributionMethod());
        if (po.getPurchaseOrderCostSource() != null) {
            this.setPaymentRequestCostSource(po.getPurchaseOrderCostSource());
            this.setPaymentRequestCostSourceCode(po.getPurchaseOrderCostSourceCode());
        }
        if (po.getVendorShippingPaymentTerms() != null) {
            this.setVendorShippingPaymentTerms(po.getVendorShippingPaymentTerms());
            this.setVendorShippingPaymentTermsCode(po.getVendorShippingPaymentTermsCode());
        }
        if (po.getVendorPaymentTerms() != null) {
            this.setVendorPaymentTermsCode(po.getVendorPaymentTermsCode());
            this.setVendorPaymentTerms(po.getVendorPaymentTerms());
        }
        if (po.getRecurringPaymentType() != null) {
            this.setRecurringPaymentType(po.getRecurringPaymentType());
            this.setRecurringPaymentTypeCode(po.getRecurringPaymentTypeCode());
        }
        this.setVendorHeaderGeneratedIdentifier(po.getVendorHeaderGeneratedIdentifier());
        this.setVendorDetailAssignedIdentifier(po.getVendorDetailAssignedIdentifier());
        this.setVendorCustomerNumber(po.getVendorCustomerNumber());
        this.setVendorName(po.getVendorName());
        this.setOriginalVendorHeaderGeneratedIdentifier(po.getVendorHeaderGeneratedIdentifier());
        this.setOriginalVendorDetailAssignedIdentifier(po.getVendorDetailAssignedIdentifier());
        this.setAlternateVendorHeaderGeneratedIdentifier(po.getAlternateVendorHeaderGeneratedIdentifier());
        this.setAlternateVendorDetailAssignedIdentifier(po.getAlternateVendorDetailAssignedIdentifier());
        String userCampus = GlobalVariables.getUserSession().getPerson().getCampusCode();
        VendorAddress vendorAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress(po.getVendorHeaderGeneratedIdentifier(), po.getVendorDetailAssignedIdentifier(), "RM", userCampus);
        if (vendorAddress != null) {
            this.templateVendorAddress(vendorAddress);
            this.setVendorAddressGeneratedIdentifier(vendorAddress.getVendorAddressGeneratedIdentifier());
            this.setVendorAttentionName(StringUtils.defaultString((String)vendorAddress.getVendorAttentionName()));
        } else {
            this.setVendorAddressGeneratedIdentifier(po.getVendorAddressGeneratedIdentifier());
            this.setVendorLine1Address(po.getVendorLine1Address());
            this.setVendorLine2Address(po.getVendorLine2Address());
            this.setVendorCityName(po.getVendorCityName());
            this.setVendorAddressInternationalProvinceName(po.getVendorAddressInternationalProvinceName());
            this.setVendorStateCode(po.getVendorStateCode());
            this.setVendorPostalCode(po.getVendorPostalCode());
            this.setVendorCountryCode(po.getVendorCountryCode());
            boolean blankAttentionLine = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", "BLANK_ATTENTION_LINE_FOR_PO_TYPE_ADDRESS"));
            if (blankAttentionLine) {
                this.setVendorAttentionName("");
            } else {
                this.setVendorAttentionName(StringUtils.defaultString((String)po.getVendorAttentionName()));
            }
        }
        this.setPaymentRequestPayDate(((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePayDate(this.getInvoiceDate(), this.getVendorPaymentTerms()));
        if (((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).encumberedItemExistsForInvoicing(po)) {
            for (PurchaseOrderItem poi : po.getItems()) {
                if (!this.getDocumentSpecificService().poItemEligibleForAp(this, poi)) continue;
                PaymentRequestItem paymentRequestItem = new PaymentRequestItem(poi, this, expiredOrClosedAccountList);
                this.getItems().add(paymentRequestItem);
                PurchasingCapitalAssetItem purchasingCAMSItem = po.getPurchasingCapitalAssetItemByItemIdentifier(poi.getItemIdentifier());
                if (purchasingCAMSItem == null) continue;
                paymentRequestItem.setCapitalAssetTransactionTypeCode(purchasingCAMSItem.getCapitalAssetTransactionTypeCode());
            }
        }
        ((PurapService)SpringContext.getBean(PurapService.class)).addBelowLineItems(this);
        this.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).removeIneligibleAdditionalCharges(this);
        this.fixItemReferences();
        this.refreshNonUpdateableReferences();
    }

    public String getDocumentTitle() {
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(PaymentRequestDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND").booleanValue()) {
            return this.getCustomDocumentTitle();
        }
        return this.buildDocumentTitle(super.getDocumentTitle());
    }

    protected String getCustomDocumentTitle() {
        String poNumber = this.getPurchaseOrderIdentifier().toString();
        String vendorName = StringUtils.trimToEmpty((String)this.getVendorName());
        String preqAmount = this.getGrandTotal().toString();
        String documentTitle = "";
        Set nodeNames = this.getFinancialSystemDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
        if (CollectionUtils.isEmpty((Collection)nodeNames) || this.getFinancialSystemDocumentHeader().getWorkflowDocument().isFinal()) {
            documentTitle = "PO: " + poNumber + " Vendor: " + vendorName + " Amount: " + preqAmount;
        } else {
            PurApAccountingLine theAccount = this.getFirstAccount();
            String accountNumber = theAccount != null ? StringUtils.trimToEmpty((String)theAccount.getAccountNumber()) : "n/a";
            String subAccountNumber = theAccount != null ? StringUtils.trimToEmpty((String)theAccount.getSubAccountNumber()) : "";
            String accountChart = theAccount != null ? theAccount.getChartOfAccountsCode() : "";
            String payDate = PaymentRequestDocument.getDateTimeService().toDateString((java.util.Date)this.getPaymentRequestPayDate());
            String indicator = this.getTitleIndicator();
            documentTitle = "PO: " + poNumber + " Vendor: " + vendorName + " Account: " + accountChart + " " + accountNumber + " " + subAccountNumber + " Amount: " + preqAmount + " Pay Date: " + payDate + " " + indicator;
        }
        return documentTitle;
    }

    public PurApAccountingLine getFirstAccount() {
        if (this.getItems() != null && !this.getItems().isEmpty()) {
            for (Object anItem : this.getItems()) {
                PaymentRequestItem item = (PaymentRequestItem)anItem;
                if (!item.isConsideredEntered() || item.getSourceAccountingLines() == null || item.getSourceAccountingLines().isEmpty()) continue;
                PurApAccountingLine accountLine = item.getSourceAccountingLine(0);
                accountLine.refreshNonUpdateableReferences();
                return accountLine;
            }
        }
        return null;
    }

    protected String getTitleIndicator() {
        if (this.isHoldIndicator()) {
            return "HOLD";
        }
        if (this.isPaymentRequestedCancelIndicator()) {
            return "REQUEST CANCEL";
        }
        return "";
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() started");
        super.doRouteStatusChange(statusChangeEvent);
        try {
            if (this.isAutoApprovedIndicator()) {
                this.updateAndSaveAppDocStatus("Auto-Approved");
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                if (!"Auto-Approved".equals(this.getApplicationDocumentStatus())) {
                    this.populateDocumentForRouting();
                    this.updateAndSaveAppDocStatus("Department-Approved");
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getDocumentHeader().getWorkflowDocument());
                String disapprovalStatus = PurapConstants.PaymentRequestStatuses.getPaymentRequestAppDocDisapproveStatuses().get(nodeName);
                if (ObjectUtils.isNotNull((Object)nodeName)) {
                    if (StringUtils.isBlank((CharSequence)disapprovalStatus) && ("Initiated".equals(this.getApplicationDocumentStatus()) || "In Process".equals(this.getApplicationDocumentStatus()))) {
                        disapprovalStatus = "Cancelled In Process";
                    }
                    if (StringUtils.isNotBlank((CharSequence)disapprovalStatus)) {
                        ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).cancelAccountsPayableDocument(this, nodeName);
                    }
                } else {
                    this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + nodeName + "'");
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                String currentNodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getDocumentHeader().getWorkflowDocument());
                String cancelledStatus = PurapConstants.PaymentRequestStatuses.getPaymentRequestAppDocDisapproveStatuses().get(currentNodeName);
                if (StringUtils.isBlank((CharSequence)cancelledStatus) && StringUtils.isBlank((CharSequence)PurapConstants.PaymentRequestStatuses.getPaymentRequestAppDocDisapproveStatuses().get(currentNodeName)) && ("Initiated".equals(this.getApplicationDocumentStatus()) || "In Process".equals(this.getApplicationDocumentStatus()))) {
                    cancelledStatus = "Cancelled In Process";
                }
                if (ObjectUtils.isNotNull((Object)cancelledStatus)) {
                    ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).cancelAccountsPayableDocument(this, currentNodeName);
                    this.updateAndSaveAppDocStatus(cancelledStatus);
                } else {
                    this.logAndThrowRuntimeException("No status found to set for document being canceled in node '" + currentNodeName + "'");
                }
            }
        }
        catch (WorkflowException e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
        }
    }

    public void doActionTaken(ActionTakenEvent event) {
        Object[] names;
        super.doActionTaken(event);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        String currentNode = null;
        Set currentNodes = workflowDocument.getCurrentNodeNames();
        if (CollectionUtils.isNotEmpty((Collection)currentNodes) && (names = currentNodes.toArray()).length > 0) {
            currentNode = (String)names[0];
        }
        if (PurapConstants.PaymentRequestStatuses.getNodesRequiringCorrectingGeneralLedgerEntries().contains(currentNode)) {
            ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).generateEntriesModifyPaymentRequest(this);
        }
    }

    @Override
    public boolean processNodeChange(String newNodeName, String oldNodeName) {
        if ("Auto-Approved".equals(this.getApplicationDocumentStatus())) {
            return false;
        }
        if ("AdHoc".equals(oldNodeName)) {
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).performLogicForFullEntryCompleted(this);
        }
        return true;
    }

    @Override
    public void saveDocumentFromPostProcessing() {
        PurapService purapService = (PurapService)SpringContext.getBean(PurapService.class);
        purapService.saveDocumentNoValidation((Document)this);
        if (purapService.isFullDocumentEntryCompleted(this) && this.isClosePurchaseOrderIndicator()) {
            purapService.performLogicForCloseReopenPO(this);
        }
    }

    @Override
    public Class getItemClass() {
        return PaymentRequestItem.class;
    }

    @Override
    public Class getItemUseTaxClass() {
        return PaymentRequestItemUseTax.class;
    }

    @Override
    public PurchaseOrderDocument getPurApSourceDocumentIfPossible() {
        return this.getPurchaseOrderDocument();
    }

    @Override
    public String getPurApSourceDocumentLabelIfPossible() {
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByTypeName("PO");
    }

    public String getPurchaseOrderNotes() {
        ArrayList poNotes = (ArrayList)this.getPurchaseOrderDocument().getNotes();
        if (poNotes.size() > 0) {
            return "Yes";
        }
        return "No";
    }

    public void setPurchaseOrderNotes(String purchaseOrderNotes) {
        this.purchaseOrderNotes = purchaseOrderNotes;
    }

    public String getRecurringPaymentTypeCode() {
        return this.recurringPaymentTypeCode;
    }

    public void setRecurringPaymentTypeCode(String recurringPaymentTypeCode) {
        this.recurringPaymentTypeCode = recurringPaymentTypeCode;
    }

    public KualiDecimal getItemTotalPoEncumbranceAmount() {
        return this.getPurchaseOrderDocument().getTotalDollarAmount(false, false);
    }

    public KualiDecimal getItemTotalPoEncumbranceAmountRelieved() {
        return this.getItemTotalPoEncumbranceAmountRelieved(false);
    }

    public KualiDecimal getItemTotalPoEncumbranceAmountRelieved(boolean includeBelowTheLine) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (PurchaseOrderItem item : this.getPurchaseOrderDocument().getItems()) {
            ItemType it = item.getItemType();
            if (!includeBelowTheLine && !it.isLineItemIndicator()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)item.getItemEncumbranceRelievedAmount());
        }
        return total;
    }

    public KualiDecimal getLineItemTotal() {
        return this.getTotalDollarAmountAboveLineItems();
    }

    public KualiDecimal getLineItemPreTaxTotal() {
        return this.getTotalPreTaxDollarAmountAboveLineItems();
    }

    public KualiDecimal getLineItemTaxAmount() {
        return this.getTotalTaxAmountAboveLineItems();
    }

    @Override
    public KualiDecimal getGrandTotal() {
        return this.getTotalDollarAmount();
    }

    public KualiDecimal getGrandTotalExcludingDiscount() {
        String[] discountCode = new String[]{"DISC"};
        return this.getTotalDollarAmountWithExclusions(discountCode, true);
    }

    public void setGrandTotalExcludingDiscount(KualiDecimal amount) {
    }

    public KualiDecimal getGrandPreTaxTotal() {
        return this.getTotalPreTaxDollarAmount();
    }

    public KualiDecimal getGrandPreTaxTotalExcludingDiscount() {
        String[] discountCode = new String[]{"DISC"};
        return this.getTotalPreTaxDollarAmountWithExclusions(discountCode, true);
    }

    public KualiDecimal getGrandTaxAmount() {
        return this.getTotalTaxAmount();
    }

    public KualiDecimal getGrandTaxAmountExcludingDiscount() {
        String[] discountCode = new String[]{"DISC"};
        return this.getTotalTaxAmountWithExclusions(discountCode, true);
    }

    public boolean isDiscount() {
        return ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).hasDiscountItem(this);
    }

    public KualiDecimal getItemTotalPoPaidAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (PurchaseOrderItem item : this.getPurchaseOrderDocument().getItems()) {
            ItemType iT = item.getItemType();
            if (!iT.isLineItemIndicator()) continue;
            KualiDecimal itemPaid = item.getItemPaidAmount();
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemPaid);
        }
        return total;
    }

    public String getAccountsPayableRequestCancelPersonName() {
        Person user = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(this.getAccountsPayableRequestCancelIdentifier());
        String personName = user != null ? user.getName() : "";
        return personName;
    }

    public void setItemTotalPoPaidAmount(KualiDecimal amount) {
    }

    public void setItemTotalPoEncumbranceAmount(KualiDecimal amount) {
    }

    public void setItemTotalPoEncumbranceAmountRelieved(KualiDecimal amount) {
    }

    protected List<String> getCurrentRouteLevels(WorkflowDocument workflowDocument) {
        Set names = workflowDocument.getCurrentNodeNames();
        if (CollectionUtils.isNotEmpty((Collection)names)) {
            return new ArrayList<String>(names);
        }
        return null;
    }

    public RecurringPaymentType getRecurringPaymentType() {
        if (ObjectUtils.isNull((Object)((Object)this.recurringPaymentType))) {
            this.refreshReferenceObject("recurringPaymentType");
        }
        return this.recurringPaymentType;
    }

    public void setRecurringPaymentType(RecurringPaymentType recurringPaymentType) {
        this.recurringPaymentType = recurringPaymentType;
    }

    public PurchaseOrderCostSource getPaymentRequestCostSource() {
        return this.paymentRequestCostSource;
    }

    public void setPaymentRequestCostSource(PurchaseOrderCostSource paymentRequestCostSource) {
        this.paymentRequestCostSource = paymentRequestCostSource;
    }

    @Override
    public String getPoDocumentTypeForAccountsPayableDocumentCancel() {
        return "POR";
    }

    @Override
    public KualiDecimal getInitialAmount() {
        return this.getVendorInvoiceAmount();
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        String workflowDocumentTitle = this.buildDocumentTitle(workflowDocument.getTitle());
        this.getFinancialSystemDocumentHeader().getWorkflowDocument().setTitle(workflowDocumentTitle);
        if (event instanceof AttributedContinuePurapEvent) {
            ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).populatePaymentRequest(this);
        }
        super.prepareForSave(event);
    }

    @Override
    protected boolean isAttachmentRequired() {
        if (this.getPaymentRequestElectronicInvoiceIndicator()) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(PaymentRequestDocument.class, "REQUIRE_ATTACHMENT_IND"));
    }

    @Override
    public AccountsPayableDocumentSpecificService getDocumentSpecificService() {
        return (AccountsPayableDocumentSpecificService)SpringContext.getBean(PaymentRequestService.class);
    }

    @Override
    public PurApItem getItem(int pos) {
        PaymentRequestItem item = (PaymentRequestItem)super.getItem(pos);
        if (item.getPaymentRequest() == null) {
            item.setPaymentRequest(this);
        }
        return item;
    }

    public String getPrimaryVendorName() {
        VendorDetail vd;
        if (this.primaryVendorName == null && (vd = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(this.getOriginalVendorHeaderGeneratedIdentifier(), this.getOriginalVendorDetailAssignedIdentifier())) != null) {
            this.primaryVendorName = vd.getVendorName();
        }
        return this.primaryVendorName;
    }

    @Deprecated
    public void setPrimaryVendorName(String primaryVendorName) {
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurchaseOrderIdentifier(), this.getDebitCreditCodeForGLEntries(), "PREQ", this.isGenerateEncumbranceEntries());
        explicitEntry.setFinancialDocumentApprovedCode("A");
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RequiresImageAttachment")) {
            return this.requiresAccountsPayableReviewRouting();
        }
        if (nodeName.equals("PurchaseWasReceived")) {
            return this.shouldWaitForReceiving();
        }
        if (nodeName.equals("VendorIsEmployeeOrNonResidentAlien")) {
            return this.isVendorEmployeeOrNonResidentAlien();
        }
        if (nodeName.equals("RequiresAutoApprovalNotification")) {
            return this.isAutoApprovedIndicator();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean isVendorEmployeeOrNonResidentAlien() {
        String vendorHeaderGeneratedId = this.getVendorHeaderGeneratedIdentifier().toString();
        if (StringUtils.isBlank((CharSequence)vendorHeaderGeneratedId)) {
            return false;
        }
        VendorService vendorService = (VendorService)SpringContext.getBean(VendorService.class);
        boolean routeDocumentAsEmployeeVendor = vendorService.isVendorInstitutionEmployee(Integer.valueOf(vendorHeaderGeneratedId));
        boolean routeDocumentAsForeignVendor = vendorService.isVendorForeign(Integer.valueOf(vendorHeaderGeneratedId));
        return routeDocumentAsEmployeeVendor || routeDocumentAsForeignVendor;
    }

    protected boolean shouldWaitForReceiving() {
        if (this.isReceivingDocumentRequiredIndicator()) {
            return !this.isReceivingRequirementMet();
        }
        return false;
    }

    public boolean isReceivingRequirementMet() {
        for (Object item : this.getItems()) {
            KualiDecimal poQuantityInvoiced;
            KualiDecimal poQuantityReceived;
            PaymentRequestItem preqItem = (PaymentRequestItem)item;
            if (!preqItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) continue;
            PurchaseOrderItem poItem = preqItem.getPurchaseOrderItem();
            KualiDecimal preqQuantityInvoiced = preqItem.getItemQuantity() == null ? KualiDecimal.ZERO : preqItem.getItemQuantity();
            if (preqQuantityInvoiced.compareTo((poQuantityReceived = poItem.getItemReceivedTotalQuantity() == null ? KualiDecimal.ZERO : poItem.getItemReceivedTotalQuantity()).subtract((AbstractKualiDecimal)((KualiDecimal)(poQuantityInvoiced = poItem.getItemInvoicedTotalQuantity() == null ? KualiDecimal.ZERO : poItem.getItemInvoicedTotalQuantity()).subtract((AbstractKualiDecimal)preqQuantityInvoiced)))) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Date getTransactionTaxDate() {
        return this.getInvoiceDate();
    }

    public String getTaxClassificationCode() {
        return this.taxClassificationCode;
    }

    public void setTaxClassificationCode(String taxClassificationCode) {
        this.taxClassificationCode = taxClassificationCode;
    }

    public KualiDecimal getTaxFederalPercentShort() {
        return new KualiDecimal(this.taxFederalPercent);
    }

    public BigDecimal getTaxFederalPercent() {
        return this.taxFederalPercent;
    }

    public void setTaxFederalPercent(BigDecimal taxFederalPercent) {
        this.taxFederalPercent = taxFederalPercent;
    }

    public KualiDecimal getTaxStatePercentShort() {
        return new KualiDecimal(this.taxStatePercent);
    }

    public BigDecimal getTaxStatePercent() {
        return this.taxStatePercent;
    }

    public void setTaxStatePercent(BigDecimal taxStatePercent) {
        this.taxStatePercent = taxStatePercent;
    }

    public String getTaxCountryCode() {
        return this.taxCountryCode;
    }

    public void setTaxCountryCode(String taxCountryCode) {
        this.taxCountryCode = taxCountryCode;
    }

    public Boolean getTaxGrossUpIndicator() {
        return this.taxGrossUpIndicator;
    }

    public void setTaxGrossUpIndicator(Boolean taxGrossUpIndicator) {
        this.taxGrossUpIndicator = taxGrossUpIndicator;
    }

    public Boolean getTaxExemptTreatyIndicator() {
        return this.taxExemptTreatyIndicator;
    }

    public void setTaxExemptTreatyIndicator(Boolean taxExemptTreatyIndicator) {
        this.taxExemptTreatyIndicator = taxExemptTreatyIndicator;
    }

    public Boolean getTaxForeignSourceIndicator() {
        return this.taxForeignSourceIndicator;
    }

    public void setTaxForeignSourceIndicator(Boolean taxForeignSourceIndicator) {
        this.taxForeignSourceIndicator = taxForeignSourceIndicator;
    }

    public KualiDecimal getTaxSpecialW4Amount() {
        return this.taxSpecialW4Amount;
    }

    public void setTaxSpecialW4Amount(KualiDecimal taxSpecialW4Amount) {
        this.taxSpecialW4Amount = taxSpecialW4Amount;
    }

    public Boolean getTaxUSAIDPerDiemIndicator() {
        return this.taxUSAIDPerDiemIndicator;
    }

    public void setTaxUSAIDPerDiemIndicator(Boolean taxUSAIDPerDiemIndicator) {
        this.taxUSAIDPerDiemIndicator = taxUSAIDPerDiemIndicator;
    }

    public Boolean getTaxOtherExemptIndicator() {
        return this.taxOtherExemptIndicator;
    }

    public void setTaxOtherExemptIndicator(Boolean taxOtherExemptIndicator) {
        this.taxOtherExemptIndicator = taxOtherExemptIndicator;
    }

    public String getTaxNQIId() {
        return this.taxNQIId;
    }

    public void setTaxNQIId(String taxNQIId) {
        this.taxNQIId = taxNQIId;
    }

    public boolean isPaymentRequestedCancelIndicatorForSearching() {
        return this.paymentRequestedCancelIndicator;
    }

    public boolean getPaymentRequestPositiveApprovalIndicatorForSearching() {
        return this.paymentRequestPositiveApprovalIndicator;
    }

    public boolean isAchSignUpStatusFlag() {
        return this.achSignUpStatusFlag;
    }

    public void setAchSignUpStatusFlag(boolean achSignUpStatusFlag) {
        this.achSignUpStatusFlag = achSignUpStatusFlag;
    }

    public boolean getReceivingDocumentRequiredIndicatorForSearching() {
        return this.receivingDocumentRequiredIndicator;
    }

    public String getRequestCancelIndicatorForResult() {
        return this.isPaymentRequestedCancelIndicator() ? "Yes" : "No";
    }

    public String getPaidIndicatorForResult() {
        return this.getPaymentPaidTimestamp() != null ? "Yes" : "No";
    }

    public Date getAccountsPayableApprovalDateForSearching() {
        if (this.getAccountsPayableApprovalTimestamp() == null) {
            return null;
        }
        try {
            Date date = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).convertToSqlDate(this.getAccountsPayableApprovalTimestamp());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAccountsPayableApprovalDateForSearching() returns " + date);
            }
            return date;
        }
        catch (Exception e) {
            return new Date(this.getAccountsPayableApprovalTimestamp().getTime());
        }
    }

    @Override
    public boolean documentHasNoImagesAttached() {
        List boNotes = this.getNotes();
        if (ObjectUtils.isNotNull((Object)boNotes)) {
            for (Object obj : boNotes) {
                Note note = (Note)obj;
                note.refreshReferenceObject("attachment");
                if (!ObjectUtils.isNotNull((Object)note.getAttachment()) || !"Invoice Image".equals(note.getAttachment().getAttachmentTypeCode())) continue;
                return false;
            }
        }
        return true;
    }

    public String getJustification() {
        return this.justification;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public boolean isAutoApprovedIndicator() {
        return this.autoApprovedIndicator;
    }

    public void setAutoApprovedIndicator(boolean autoApprovedIndicator) {
        this.autoApprovedIndicator = autoApprovedIndicator;
    }

    @Override
    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        if (ObjectUtils.isNull((Object)this.getDocumentHeader()) || StringUtils.isBlank((CharSequence)this.getDocumentHeader().getDocumentNumber())) {
            WorkflowDocument workflowDocument = null;
            if (this.getDocumentHeader().hasWorkflowDocument()) {
                workflowDocument = this.getDocumentHeader().getWorkflowDocument();
            }
            this.refreshReferenceObject("documentHeader");
            if (!ObjectUtils.isNull((Object)this.getDocumentHeader())) {
                this.getDocumentHeader().setWorkflowDocument(workflowDocument);
            }
        }
    }
}

