/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.purap.businessobject.AutoClosePurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurchaseOrderDaoOjb
extends PlatformAwareDaoBaseOjb
implements PurchaseOrderDao {
    private static final Logger LOG = LogManager.getLogger(PurchaseOrderDaoOjb.class);

    @Override
    public Integer getPurchaseOrderIdForCurrentPurchaseOrderByRelatedDocId(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("accountsPayablePurchasingDocumentLinkIdentifier", (Object)accountsPayablePurchasingDocumentLinkIdentifier);
        criteria.addEqualTo("purchaseOrderCurrentIndicator", (Object)"Y");
        Collection poList = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PurchaseOrderDocument.class, criteria));
        return poList.stream().findFirst().map(PurchasingAccountsPayableDocumentBase::getPurapDocumentIdentifier).orElse(null);
    }

    @Override
    public PurchaseOrderDocument getCurrentPurchaseOrder(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        criteria.addEqualTo("purchaseOrderCurrentIndicator", (Object)"Y");
        return (PurchaseOrderDocument)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(PurchaseOrderDocument.class, criteria));
    }

    @Override
    public String getDocumentNumberForPurchaseOrderId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        return this.getDocumentNumberUsingPurchaseOrderCriteria(criteria);
    }

    @Override
    public String getDocumentNumberForCurrentPurchaseOrder(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        criteria.addEqualTo("purchaseOrderCurrentIndicator", (Object)"Y");
        return this.getDocumentNumberUsingPurchaseOrderCriteria(criteria);
    }

    @Override
    public String getOldestPurchaseOrderDocumentNumber(Integer id) {
        Criteria criteria = new Criteria();
        String oldestDocumentNumber = null;
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        ReportQueryByCriteria query = new ReportQueryByCriteria(PurchaseOrderDocument.class, new String[]{"documentNumber"}, criteria);
        query.addOrderByAscending("documentHeader.workflowCreateDate");
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        if (iter.hasNext()) {
            Object[] res = (Object[])iter.next();
            oldestDocumentNumber = (String)res[0];
        }
        TransactionalServiceUtils.exhaustIterator((Iterator)iter);
        return oldestDocumentNumber;
    }

    protected String getDocumentNumberUsingPurchaseOrderCriteria(Criteria criteria) {
        List<String> returnList = this.getDocumentNumbersUsingPurchaseOrderCriteria(criteria);
        if (returnList.isEmpty()) {
            return null;
        }
        if (returnList.size() > 1) {
            String errorMsg = "Expected single document number for given criteria but multiple (at least 2) were returned";
            LOG.error(errorMsg);
            throw new RuntimeException();
        }
        return returnList.get(0);
    }

    protected List<String> getDocumentNumbersUsingPurchaseOrderCriteria(Criteria criteria) {
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(PurchaseOrderDocument.class, criteria);
        ArrayList<String> returnList = new ArrayList<String>();
        rqbc.addOrderByAscending("documentNumber");
        List poDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        for (PurchaseOrderDocument poDoc : poDocs) {
            returnList.add(poDoc.getDocumentNumber());
        }
        return returnList;
    }

    @Override
    public boolean itemExistsOnPurchaseOrder(Integer poItemLineNumber, String docNumber) {
        boolean existsInPo = false;
        Criteria criteria = new Criteria();
        criteria.addEqualTo("documentNumber", (Object)docNumber);
        criteria.addEqualTo("itemLineNumber", (Object)poItemLineNumber);
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(PurchaseOrderItem.class, criteria);
        rqbc.addOrderByAscending("documentNumber");
        List poItems = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        if (!poItems.isEmpty()) {
            existsInPo = true;
        }
        return existsInPo;
    }

    @Override
    public List<AutoClosePurchaseOrderView> getAllOpenPurchaseOrders(List<String> excludedVendorChoiceCodes) {
        LOG.debug("getAllOpenPurchaseOrdersForAutoClose() started");
        Criteria criteria = new Criteria();
        criteria.addIsNull("recurringPaymentTypeCode");
        criteria.addEqualTo("totalEncumbrance", (Object)new KualiDecimal(0));
        criteria.addEqualTo("purchaseOrderCurrentIndicator", (Object)true);
        for (String excludeCode : excludedVendorChoiceCodes) {
            criteria.addNotEqualTo((Object)"vendorChoiceCode", (Object)excludeCode);
        }
        criteria.addEqualTo("documentHeader.applicationDocumentStatus", (Object)"Open");
        QueryByCriteria qbc = new QueryByCriteria(AutoClosePurchaseOrderView.class, criteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllOpenPurchaseOrdersForAutoClose() Query criteria is " + criteria.toString());
        }
        List l = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        LOG.debug("getAllOpenPurchaseOrdersForAutoClose() ended.");
        return l;
    }

    @Override
    public List<AutoClosePurchaseOrderView> getAutoCloseRecurringPurchaseOrders(List<String> excludedVendorChoiceCodes) {
        LOG.debug("getAutoCloseRecurringPurchaseOrders() started.");
        Criteria criteria = new Criteria();
        criteria.addNotNull("recurringPaymentTypeCode");
        for (String excludeCode : excludedVendorChoiceCodes) {
            criteria.addNotEqualTo((Object)"vendorChoiceCode", (Object)excludeCode);
        }
        QueryByCriteria qbc = new QueryByCriteria(AutoClosePurchaseOrderView.class, criteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAutoCloseRecurringPurchaseOrders() Query criteria is " + criteria.toString());
        }
        List l = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        LOG.debug("getAutoCloseRecurringPurchaseOrders() ended.");
        return l;
    }

    @Override
    public List<PurchaseOrderDocument> getPendingPurchaseOrdersForFaxing() {
        LOG.debug("Getting pending purchase orders for faxing");
        Criteria criteria = new Criteria();
        QueryByCriteria qbc = new QueryByCriteria(PurchaseOrderDocument.class, criteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }
}

