/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.FaxBatchDocumentsService;
import org.kuali.kfs.module.purap.document.service.FaxService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class FaxBatchDocumentsServiceImpl
implements FaxBatchDocumentsService {
    private static final Logger LOG = LogManager.getLogger();
    private PurchaseOrderService purchaseOrderService;
    private FaxService faxService;
    private PurapService purapService;
    private DateTimeService dateTimeService;
    private DocumentService documentService;

    @Override
    public boolean faxPendingPurchaseOrders() {
        List<PurchaseOrderDocument> pendingPOs = this.purchaseOrderService.getPendingPurchaseOrderFaxes();
        boolean result = true;
        for (PurchaseOrderDocument po : pendingPOs) {
            if (!po.getDocumentHeader().hasWorkflowDocument()) {
                try {
                    po = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(po.getDocumentNumber());
                }
                catch (WorkflowException e) {
                    throw new RuntimeException(e);
                }
            }
            GlobalVariables.getMessageMap().clearErrorMessages();
            this.faxService.faxPurchaseOrderPdf(po, false);
            if (GlobalVariables.getMessageMap().hasErrors()) {
                try {
                    po.updateAndSaveAppDocStatus("Open");
                }
                catch (WorkflowException we) {
                    String errorMsg = "Workflow Exception caught trying to create and save PO document of type PurchaseOrderSplitDocument using source document with doc id '" + po.getDocumentNumber() + "'";
                    LOG.error(errorMsg, (Throwable)we);
                    throw new RuntimeException(errorMsg, we);
                }
                po.setPurchaseOrderInitialOpenTimestamp(this.dateTimeService.getCurrentTimestamp());
                po.setPurchaseOrderLastTransmitTimestamp(this.dateTimeService.getCurrentTimestamp());
                this.purapService.saveDocumentNoValidation((Document)po);
                continue;
            }
            result = false;
        }
        return result;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setFaxService(FaxService faxService) {
        this.faxService = faxService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

