/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.impl.BankCodeValidation;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;

public class AccountsPayableBankCodeValidation
extends GenericValidation {
    private static final Logger LOG = LogManager.getLogger();
    private AccountingDocument accountingDocumentForValidation;
    private ParameterEvaluatorService parameterEvaluatorService;

    public boolean validate(AttributedDocumentEvent event) {
        LOG.debug("validate start");
        AccountsPayableDocumentBase apDocument = (AccountsPayableDocumentBase)this.accountingDocumentForValidation;
        boolean isValid = true;
        if (this.isDocumentTypeUsingBankCode(apDocument)) {
            isValid = BankCodeValidation.validate((Document)apDocument, (String)apDocument.getBankCode(), (String)"bankCode", (boolean)false, (boolean)true);
        }
        return isValid;
    }

    private boolean isDocumentTypeUsingBankCode(AccountsPayableDocumentBase apDocument) {
        String documentTypeName = apDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        ParameterEvaluator evaluator = this.parameterEvaluatorService.getParameterEvaluator(Bank.class, "BANK_CODE_DOCUMENT_TYPES", documentTypeName);
        return evaluator.evaluationSucceeds();
    }

    public void setAccountingDocumentForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }
}

