/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ItemTypeRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(ItemTypeRule.class);

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence() && this.checkIndicators();
        return success && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkForSystemParametersExistence();
        return success && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean checkForSystemParametersExistence() {
        LOG.info("checkForSystemParametersExistence called");
        boolean success = true;
        ArrayList cmAdditionalCharges = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(VendorCreditMemoDocument.class, "ADDITIONAL_CHARGES_ITEM_TYPES"));
        ArrayList preqAdditionalCharges = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ADDITIONAL_CHARGES_ITEM_TYPES"));
        ArrayList poAdditionalCharges = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ADDITIONAL_CHARGES_ITEM_TYPES"));
        ArrayList reqAdditionalCharges = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ADDITIONAL_CHARGES_ITEM_TYPES"));
        ArrayList defaultNonQuantityItemTypes = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "DEFAULT_NON_QUANTITY_ITEM_TYPE"));
        ArrayList defaultQuantityItemTypes = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "DEFAULT_QUANTITY_ITEM_TYPE"));
        ArrayList cmAllowNegative = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(VendorCreditMemoDocument.class, "ITEM_TYPES_ALLOWING_NEGATIVE"));
        ArrayList preqAllowNegative = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ITEM_TYPES_ALLOWING_NEGATIVE"));
        ArrayList poAllowNegative = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ITEM_TYPES_ALLOWING_NEGATIVE"));
        ArrayList reqAllowNegative = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ITEM_TYPES_ALLOWING_NEGATIVE"));
        ArrayList cmAllowPositive = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(VendorCreditMemoDocument.class, "ITEM_TYPES_ALLOWING_POSITIVE"));
        ArrayList preqAllowPositive = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ITEM_TYPES_ALLOWING_POSITIVE"));
        ArrayList poAllowPositive = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ITEM_TYPES_ALLOWING_POSITIVE"));
        ArrayList reqAllowPositive = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ITEM_TYPES_ALLOWING_POSITIVE"));
        ArrayList cmAllowZero = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(VendorCreditMemoDocument.class, "ITEM_TYPES_ALLOWING_ZERO"));
        ArrayList preqAllowZero = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ITEM_TYPES_ALLOWING_ZERO"));
        ArrayList poAllowZero = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ITEM_TYPES_ALLOWING_ZERO"));
        ArrayList reqAllowZero = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ITEM_TYPES_ALLOWING_ZERO"));
        ArrayList cmRequireDescription = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(VendorCreditMemoDocument.class, "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION"));
        ArrayList preqRequireDescription = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION"));
        ArrayList poRequireDescription = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION"));
        ArrayList reqRequireDescription = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION"));
        ArrayList preqRestrictingAccountEdit = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PaymentRequestDocument.class, "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        ArrayList poRestrictingAccountEdit = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        ArrayList reqRestrictingAccountEdit = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(RequisitionDocument.class, "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
        ItemType newBo = (ItemType)((Object)this.getNewBo());
        ItemType oldBo = (ItemType)((Object)this.getOldBo());
        if (!newBo.isActive() && oldBo.isActive() && (cmAdditionalCharges.contains(newBo.getItemTypeCode()) || preqAdditionalCharges.contains(newBo.getItemTypeCode()) || poAdditionalCharges.contains(newBo.getItemTypeCode()) || reqAdditionalCharges.contains(newBo.getItemTypeCode()) || defaultNonQuantityItemTypes.contains(newBo.getItemTypeCode()) || defaultQuantityItemTypes.contains(newBo.getItemTypeCode()) || cmAllowNegative.contains(newBo.getItemTypeCode()) || preqAllowNegative.contains(newBo.getItemTypeCode()) || poAllowNegative.contains(newBo.getItemTypeCode()) || reqAllowNegative.contains(newBo.getItemTypeCode()) || cmAllowPositive.contains(newBo.getItemTypeCode()) || preqAllowPositive.contains(newBo.getItemTypeCode()) || poAllowPositive.contains(newBo.getItemTypeCode()) || reqAllowPositive.contains(newBo.getItemTypeCode()) || cmAllowZero.contains(newBo.getItemTypeCode()) || preqAllowZero.contains(newBo.getItemTypeCode()) || poAllowZero.contains(newBo.getItemTypeCode()) || reqAllowZero.contains(newBo.getItemTypeCode()) || cmRequireDescription.contains(newBo.getItemTypeCode()) || preqRequireDescription.contains(newBo.getItemTypeCode()) || poRequireDescription.contains(newBo.getItemTypeCode()) || reqRequireDescription.contains(newBo.getItemTypeCode()) || preqRestrictingAccountEdit.contains(newBo.getItemTypeCode()) || poRestrictingAccountEdit.contains(newBo.getItemTypeCode()) || reqRestrictingAccountEdit.contains(newBo.getItemTypeCode()))) {
            success = false;
            String documentLabel = ((BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class)).getMaintainableLabel(((Object)((Object)newBo)).getClass());
            this.putFieldError("active", "error.document.cannot.inactivate.used.in.system.parameters", documentLabel);
        }
        return success;
    }

    protected boolean checkIndicators() {
        boolean checkResult = true;
        ItemType newBo = (ItemType)((Object)this.getNewBo());
        if (newBo.isActive() && newBo.isAdditionalChargeIndicator() && newBo.isQuantityBasedGeneralLedgerIndicator()) {
            this.putFieldError("quantityBasedGeneralLedgerIndicator", "errors.itemType.quantityBased.isNotAllowedWithAdditionalCharge");
            checkResult = false;
        }
        return checkResult;
    }
}

