/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.businessobject.PurapEnterableItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingItem;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocument;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.document.validation.AddReceivingItemRule;
import org.kuali.kfs.module.purap.document.validation.ContinuePurapRule;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class LineItemReceivingDocumentRule
extends DocumentRuleBase
implements ContinuePurapRule,
AddReceivingItemRule {
    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        LineItemReceivingDocument lineItemReceivingDocument = (LineItemReceivingDocument)document;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        valid &= this.canCreateLineItemReceivingDocument(lineItemReceivingDocument);
        valid &= this.isAtLeastOneItemEntered(lineItemReceivingDocument);
        valid &= this.validateItemUnitOfMeasure(lineItemReceivingDocument);
        return valid &= this.validateAllReceivingLinesHaveSaneQuantities(lineItemReceivingDocument);
    }

    protected boolean isAtLeastOneItemEntered(ReceivingDocument receivingDocument) {
        for (ReceivingItem item : receivingDocument.getItems()) {
            if (!((PurapEnterableItem)((Object)item)).isConsideredEntered()) continue;
            return true;
        }
        GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.receiving.lineitem.required", new String[0]);
        return false;
    }

    @Override
    public boolean processContinuePurapBusinessRules(TransactionalDocument document) {
        LineItemReceivingDocument lineItemReceivingDocument = (LineItemReceivingDocument)document;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean valid = this.hasRequiredFieldsForContinue(lineItemReceivingDocument);
        if (valid) {
            valid = this.canCreateLineItemReceivingDocument(lineItemReceivingDocument);
        }
        return valid;
    }

    protected boolean hasRequiredFieldsForContinue(LineItemReceivingDocument lineItemReceivingDocument) {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)lineItemReceivingDocument.getPurchaseOrderIdentifier())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.required", new String[]{"Purchase Order Identifier"});
            valid = false;
        }
        if (ObjectUtils.isNull((Object)lineItemReceivingDocument.getShipmentReceivedDate())) {
            GlobalVariables.getMessageMap().putError("shipmentReceivedDate", "error.required", new String[]{"Vendor Date"});
            valid = false;
        }
        return valid;
    }

    protected boolean canCreateLineItemReceivingDocument(LineItemReceivingDocument lineItemReceivingDocument) {
        boolean valid = true;
        if (!((ReceivingService)SpringContext.getBean(ReceivingService.class)).canCreateLineItemReceivingDocument(lineItemReceivingDocument.getPurchaseOrderIdentifier(), lineItemReceivingDocument.getDocumentNumber())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.receivingLine.documentActiveForPo", new String[]{lineItemReceivingDocument.getDocumentNumber(), lineItemReceivingDocument.getPurchaseOrderIdentifier().toString()});
        }
        return valid;
    }

    protected boolean validateItemUnitOfMeasure(ReceivingDocument receivingDocument) {
        boolean valid = true;
        for (ReceivingItem item : receivingDocument.getItems()) {
            if (!item.getItemType().isQuantityBasedGeneralLedgerIndicator()) continue;
            String uomCode = item.getItemUnitOfMeasureCode();
            if (StringUtils.isEmpty((CharSequence)uomCode)) {
                valid = false;
                String attributeLabel = ((BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class)).getBusinessObjectEntry(item.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
                GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "error.required", new String[]{attributeLabel + item.getItemUnitOfMeasureCode()});
                continue;
            }
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("itemUnitOfMeasureCode", item.getItemUnitOfMeasureCode());
            if (((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).countMatching(UnitOfMeasure.class, fieldValues) == 1) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("itemUnitOfMeasureCode", "error.item.unitOfMeasureCode.invalid", new String[]{item.getItemUnitOfMeasureCode()});
        }
        return valid;
    }

    @Override
    public boolean processAddReceivingItemRules(ReceivingDocument document, LineItemReceivingItem item, String errorPathPrefix) {
        boolean valid = ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).isBusinessObjectValid((BusinessObject)item, errorPathPrefix);
        valid &= this.validateQuantityReturnedNotMoreThanReceived(document, item, errorPathPrefix, 0);
        return valid &= this.validateQuantityDamagedNotMoreThanReceived(document, item, errorPathPrefix, 0);
    }

    protected boolean validateQuantityReturnedNotMoreThanReceived(ReceivingDocument document, LineItemReceivingItem item, String errorPathPrefix, Integer lineNumber) {
        if (item.getItemReturnedTotalQuantity() != null && item.getItemReceivedTotalQuantity() != null && item.getItemReturnedTotalQuantity().isGreaterThan((AbstractKualiDecimal)item.getItemReceivedTotalQuantity())) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.receivingLine.quantityReturnedGreaterThanQuantityReceived", new String[]{lineNumber == 0 ? "Add Line" : lineNumber.toString()});
            return false;
        }
        return true;
    }

    protected boolean validateQuantityDamagedNotMoreThanReceived(ReceivingDocument document, LineItemReceivingItem item, String errorPathPrefix, Integer lineNumber) {
        if (item.getItemDamagedTotalQuantity() != null && item.getItemReceivedTotalQuantity() != null && item.getItemDamagedTotalQuantity().isGreaterThan((AbstractKualiDecimal)item.getItemReceivedTotalQuantity())) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.receivingLine.quantityDamagedGreaterThanQuantityReceived", new String[]{lineNumber == 0 ? "Add Line" : lineNumber.toString()});
            return false;
        }
        return true;
    }

    protected boolean validateAllReceivingLinesHaveSaneQuantities(ReceivingDocument document) {
        GlobalVariables.getMessageMap().clearErrorPath();
        boolean valid = true;
        for (int i = 0; i < document.getItems().size(); ++i) {
            LineItemReceivingItem item = (LineItemReceivingItem)document.getItems().get(i);
            valid &= this.validateQuantityReturnedNotMoreThanReceived(document, item, "", i + 1);
            valid &= this.validateQuantityDamagedNotMoreThanReceived(document, item, "", i + 1);
        }
        return valid;
    }
}

