/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.OrganizationParameter;
import org.kuali.kfs.sys.context.SpringContext;

public class OrganizationParameterRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(OrganizationParameterRule.class);
    protected OrganizationParameter newOrganizationParameter;
    protected BusinessObjectService boService;

    public void setupConvenienceObjects() {
        this.newOrganizationParameter = (OrganizationParameter)((Object)super.getNewBo());
        this.boService = super.getBoService();
        super.setupConvenienceObjects();
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkChartOfAccountsCode();
        return (success &= this.checkOrganizationCode()) && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkChartOfAccountsCode();
        return (success &= this.checkOrganizationCode()) && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkChartOfAccountsCode();
        return (success &= this.checkOrganizationCode()) && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean checkChartOfAccountsCode() {
        LOG.info("checkChartOfAccountsCode called");
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean success = true;
        Chart chart = ((ChartService)SpringContext.getBean(ChartService.class)).getByPrimaryId(this.newOrganizationParameter.getChartOfAccountsCode());
        if (ObjectUtils.isNull((Object)chart)) {
            success = false;
            errorMap.putError("document.newMaintainableObject.chartOfAccountsCode", "error.document.purap.invalidChartOfAccountsCode", new String[0]);
        }
        return success;
    }

    protected boolean checkOrganizationCode() {
        LOG.info("checkOrganizationCode called");
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean success = true;
        Organization org = ((OrganizationService)SpringContext.getBean(OrganizationService.class)).getByPrimaryId(this.newOrganizationParameter.getChartOfAccountsCode(), this.newOrganizationParameter.getOrganizationCode());
        if (ObjectUtils.isNull((Object)org)) {
            success = false;
            errorMap.putError("document.newMaintainableObject.organizationCode", "error.document.purap.invalidOrganizationCode", new String[0]);
        }
        return success;
    }
}

