/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;

public class PurchaseOrderAmendmentContainsAtLeastOneActiveItemValidation
extends GenericValidation {
    private DocumentTypeService documentTypeService;

    public boolean validate(AttributedDocumentEvent event) {
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)event.getDocument();
        List<PurApItem> items = purapDocument.getItems();
        for (PurApItem item : items) {
            if (!((PurchaseOrderItem)item).isItemActiveIndicator() || ((PurchaseOrderItem)item).isEmpty() || !item.getItemType().isLineItemIndicator()) continue;
            return true;
        }
        String documentType = this.getDocumentTypeLabel(purapDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.required", new String[]{documentType});
        return false;
    }

    protected String getDocumentTypeLabel(String documentTypeName) {
        return this.documentTypeService.getDocumentTypeByName(documentTypeName).getLabel();
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

