/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingItemQuantityValidation
extends GenericValidation {
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private PurApItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PurchasingItemBase purItem = (PurchasingItemBase)this.itemForValidation;
        String errorPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]." + "itemQuantity";
        if (purItem.getItemType().isQuantityBasedGeneralLedgerIndicator() && ObjectUtils.isNull((Object)purItem.getItemQuantity())) {
            valid = false;
            String attributeLabel = this.businessObjectDictionaryService.getBusinessObjectEntry(purItem.getClass().getName()).getAttributeDefinition("itemQuantity").getLabel();
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.required", new String[]{attributeLabel + " in " + purItem.getItemIdentifierString()});
        } else if (purItem.getItemType().isAmountBasedGeneralLedgerIndicator() && ObjectUtils.isNotNull((Object)purItem.getItemQuantity())) {
            valid = false;
            String attributeLabel = this.businessObjectDictionaryService.getBusinessObjectEntry(purItem.getClass().getName()).getAttributeDefinition("itemQuantity").getLabel();
            GlobalVariables.getMessageMap().putError(errorPrefix, "errors.item.quantity.isNotAllowed", new String[]{attributeLabel + " in " + purItem.getItemIdentifierString()});
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }
}

