/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingUnitOfMeasureValidation
extends GenericValidation {
    private PurApItem itemForValidation;
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        String errorPrefix;
        boolean valid = true;
        PurchasingItemBase purItem = (PurchasingItemBase)this.itemForValidation;
        if (purItem.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
            errorPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]." + "itemUnitOfMeasureCode";
            String uomCode = purItem.getItemUnitOfMeasureCode();
            if (StringUtils.isEmpty((CharSequence)uomCode)) {
                valid = false;
                String attributeLabel = this.businessObjectDictionaryService.getBusinessObjectEntry(purItem.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
                GlobalVariables.getMessageMap().putError(errorPrefix, "error.required", new String[]{attributeLabel + " in " + purItem.getItemIdentifierString()});
            } else {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("itemUnitOfMeasureCode", purItem.getItemUnitOfMeasureCode());
                if (this.businessObjectService.countMatching(UnitOfMeasure.class, fieldValues) != 1) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError(errorPrefix, "error.item.unitOfMeasureCode.invalid", new String[]{" in " + purItem.getItemIdentifierString()});
                }
                if (ObjectUtils.isNotNull((Object)purItem.getItemUnitOfMeasure()) && !purItem.getItemUnitOfMeasure().isActive()) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError(errorPrefix, "errors.item.uom.inactive", new String[]{" in " + purItem.getItemIdentifierString()});
                }
            }
        }
        if (purItem.getItemType().isAmountBasedGeneralLedgerIndicator() && StringUtils.isNotBlank((CharSequence)purItem.getItemUnitOfMeasureCode())) {
            valid = false;
            errorPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]." + "itemUnitOfMeasureCode";
            String attributeLabel = this.businessObjectDictionaryService.getBusinessObjectEntry(purItem.getClass().getName()).getAttributeDefinition("itemUnitOfMeasureCode").getLabel();
            GlobalVariables.getMessageMap().putError(errorPrefix, "errors.item.uom.isNotAllowed", new String[]{attributeLabel + " in " + purItem.getItemIdentifierString()});
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

