/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class RequisitionAssignToTradeInValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        PurApItem tradeInItem;
        boolean foundTradeIn = false;
        boolean valid = true;
        PurchasingAccountsPayableDocumentBase purapDoc = (PurchasingAccountsPayableDocumentBase)event.getDocument();
        List items = purapDoc.getItems();
        for (PurApItem item : items) {
            item.refreshReferenceObject("itemType");
            if (!item.getItemAssignedToTradeInIndicator()) continue;
            foundTradeIn = true;
            break;
        }
        if (foundTradeIn && (tradeInItem = purapDoc.getTradeInItem()) != null) {
            if (StringUtils.isEmpty((CharSequence)tradeInItem.getItemDescription())) {
                tradeInItem.getItemLineNumber();
                GlobalVariables.getMessageMap().putError("document.item[" + (items.size() - 1) + "]." + "itemDescription", "errors.item.belowTheLine", new String[]{"The item description of " + tradeInItem.getItemType().getItemTypeDescription(), "empty"});
                valid = false;
            } else if (ObjectUtils.isNull((Object)tradeInItem.getItemUnitPrice())) {
                GlobalVariables.getMessageMap().putError("document.item[" + (items.size() - 1) + "]." + "itemUnitPrice", "errors.item.belowTheLine", new String[]{tradeInItem.getItemType().getItemTypeDescription(), "zero"});
                valid = false;
            }
        }
        return valid;
    }
}

