/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class VendorCreditMemoItemQuantityValidation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;
    private CreditMemoItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)event.getDocument();
        String errorKeyPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "].";
        String errorKey = errorKeyPrefix + "itemQuantity";
        if (this.itemForValidation.getItemQuantity() != null) {
            if (this.itemForValidation.getItemQuantity().isNegative()) {
                String label = this.dataDictionaryService.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity");
                GlobalVariables.getMessageMap().putError(errorKey, "errors.creditMemo.itemAmount.aboveZero", new String[]{label});
                valid = false;
            }
            KualiDecimal invoicedQuantity = this.getSourceTotalInvoiceQuantity(cmDocument, this.itemForValidation);
            if (this.itemForValidation.getItemQuantity().isGreaterThan((AbstractKualiDecimal)invoicedQuantity)) {
                GlobalVariables.getMessageMap().putError(errorKey, "errors.creditMemo.item.quantity.tooMuch", new String[0]);
                valid = false;
            }
        } else {
            KualiDecimal invoicedQuantity = this.getSourceTotalInvoiceQuantity(cmDocument, this.itemForValidation);
            if (this.itemForValidation.getItemType().isQuantityBasedGeneralLedgerIndicator() && invoicedQuantity != null && invoicedQuantity.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && this.itemForValidation.getExtendedPrice() != null && this.itemForValidation.getExtendedPrice().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                String label = this.dataDictionaryService.getAttributeErrorLabel(CreditMemoItem.class, "itemQuantity");
                GlobalVariables.getMessageMap().putError(errorKey, "error.required", new String[]{label});
                valid = false;
            }
        }
        return valid;
    }

    protected KualiDecimal getSourceTotalInvoiceQuantity(VendorCreditMemoDocument cmDocument, CreditMemoItem item) {
        KualiDecimal invoicedQuantity = cmDocument.isSourceDocumentPurchaseOrder() ? item.getPoInvoicedTotalQuantity() : item.getPreqInvoicedTotalQuantity();
        return invoicedQuantity;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public CreditMemoItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(CreditMemoItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

