/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class VendorCreditMemoItemUnitPriceValidation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;
    private CreditMemoItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        String errorKeyPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "].";
        String errorKey = errorKeyPrefix + "itemUnitPrice";
        if (this.itemForValidation.getItemUnitPrice() != null && this.itemForValidation.getItemUnitPrice().signum() == -1) {
            String label = this.dataDictionaryService.getAttributeErrorLabel(CreditMemoItem.class, "itemUnitPrice");
            GlobalVariables.getMessageMap().putError(errorKey, "errors.creditMemo.itemAmount.aboveZero", new String[]{label});
            valid = false;
        }
        return valid;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public CreditMemoItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(CreditMemoItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

