/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.web.struts.ElectronicInvoiceTestForm;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.PaymentTermType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ElectronicInvoiceTestAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(ElectronicInvoiceTestAction.class);
    private static final String AREA_C0DE = "areaCode";
    private static final String PHONE_NUMBER = "phoneNumber";
    protected static volatile DocumentService documentService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodToCall = this.findMethodToCall(form, request);
        if (StringUtils.equals((CharSequence)methodToCall, (CharSequence)"generate")) {
            return this.generate(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        if (KRADUtils.isProductionEnvironment()) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), methodToCall, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public ActionForward generate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.checkAuthorization(form, "");
        ElectronicInvoiceTestForm testForm = (ElectronicInvoiceTestForm)form;
        String poDocNumber = testForm.getPoDocNumber();
        LOG.info("Generating Electronic Invoice XML file for Purchase Order Document " + poDocNumber);
        PurchaseOrderService poService = (PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class);
        if (StringUtils.isBlank((CharSequence)poDocNumber)) {
            GlobalVariables.getMessageMap().putError("poDocNumber", "error.electronicInvoice.generate.purchase.order.number.empty", new String[]{poDocNumber});
            return mapping.findForward("basic");
        }
        if (!this.getDocumentService().documentExists(poDocNumber)) {
            GlobalVariables.getMessageMap().putError("poDocNumber", "error.electronicInvoice.generate.purchase.order.nonexisting", new String[]{poDocNumber});
            return mapping.findForward("basic");
        }
        PurchaseOrderDocument po = poService.getPurchaseOrderByDocumentNumber(poDocNumber);
        response.setHeader("Cache-Control", "max-age=30");
        response.setContentType("application/xml");
        StringBuffer sbContentDispValue = new StringBuffer();
        String useJavascript = request.getParameter("useJavascript");
        if (useJavascript == null || "false".equalsIgnoreCase(useJavascript)) {
            sbContentDispValue.append("attachment");
        } else {
            sbContentDispValue.append("inline");
        }
        StringBuffer sbFilename = new StringBuffer();
        sbFilename.append("PO_");
        sbFilename.append(poDocNumber);
        sbFilename.append(".xml");
        sbContentDispValue.append("; filename=");
        sbContentDispValue.append(sbFilename);
        response.setHeader("Content-disposition", sbContentDispValue.toString());
        if (po != null) {
            String duns = "";
            if (po.getVendorDetail() != null) {
                duns = StringUtils.defaultString((String)po.getVendorDetail().getVendorDunsNumber());
            }
            DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            String currDate = ElectronicInvoiceUtils.getDateDisplayText(dateTimeService.getCurrentDate());
            String vendorNumber = po.getVendorDetail().getVendorNumber();
            String eInvoiceFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- ******Testing tool generated XML****** Version 1.2.\n\n  Generated On " + currDate + " for PO " + po.getPurapDocumentIdentifier() + " (Doc# " + poDocNumber + ") -->\n\n<!-- All the cXML attributes are junk values -->\n<cXML payloadID=\"200807260401062080.964@eai002\"\n    timestamp=\"2008-07-26T04:01:06-08:00\"\n    version=\"1.2.014\" xml:lang=\"en\" \n    xmlns=\"http://www.kuali.org/kfs/purap/electronicInvoice\" \n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <Header>\n      <From>\n          <Credential domain=\"DUNS\">\n              <Identity>" + duns + "</Identity> <!-- DUNS number from PO Vendor " + vendorNumber + "-->\n          </Credential>\n      </From>\n      <To>\n          <Credential domain=\"NetworkId\">\n              <Identity>IU</Identity> <!-- Hardcoded --> \n          </Credential>\n      </To>\n      <Sender>\n          <Credential domain=\"DUNS\">\n              <Identity>" + duns + "</Identity> <!-- DUNS number from PO Vendor " + vendorNumber + "-->\n          </Credential>\n          <UserAgent/>\n      </Sender>\n  </Header>\n  <Request deploymentMode=\"production\">\n      <InvoiceDetailRequest>\n          <InvoiceDetailRequestHeader\n              invoiceDate=\"" + currDate + "\" invoiceID=\"" + RandomUtils.nextInt() + "\" operation=\"new\" purpose=\"standard\"> <!-- invoiceID=Random unique Id, invoiceDate=Curr date -->\n              <InvoiceDetailHeaderIndicator/>\n              <InvoiceDetailLineIndicator/>\n              <InvoicePartner>\n" + this.getContactXMLChunk("billTo", po) + "              </InvoicePartner>\n              <InvoicePartner>\n                  <Contact addressID=\"" + RandomUtils.nextInt() + "\" role=\"remitTo\"> <!-- Vendor address -->\n                      <Name xml:lang=\"en\">\n                          " + po.getVendorName() + "\n                      </Name>\n                      <PostalAddress>\n                          <Street>" + StringUtils.defaultString((String)po.getVendorLine1Address()) + "</Street>\n                          <Street>" + StringUtils.defaultString((String)po.getVendorLine2Address()) + "</Street>\n                          <City>" + StringUtils.defaultString((String)po.getVendorCityName()) + "</City>\n                          <State>" + StringUtils.defaultString((String)po.getVendorStateCode()) + "</State>\n                          <PostalCode>" + StringUtils.defaultString((String)po.getVendorPostalCode()) + "</PostalCode>\n                          <Country isoCountryCode=\"" + StringUtils.defaultString((String)po.getVendorCountryCode()) + "\">\n                              " + StringUtils.defaultString((String)po.getVendorCountry().getName()) + "\n                          </Country>\n                      </PostalAddress>\n                  </Contact>\n              </InvoicePartner>\n" + this.getDeliveryAddressXMLChunk("shipTo", po) + this.getPaymentTermXML(po) + "          </InvoiceDetailRequestHeader>\n          <InvoiceDetailOrder>\n              <InvoiceDetailOrderInfo>\n                  <OrderReference\n                      orderDate=\"" + ElectronicInvoiceUtils.getDateDisplayText(dateTimeService.getCurrentDate()) + "\" orderID=\"" + po.getPurapDocumentIdentifier() + "\"> <!--orderDate=Curr date,orderID=PO#-->\n                      <DocumentReference payloadID=\"NA\" /> <!--HardCoded-->\n                  </OrderReference>\n              </InvoiceDetailOrderInfo>\n              <!-- No junk values in Items-->\n";
            for (int i = 0; i < po.getItems().size(); ++i) {
                List items = po.getItems();
                PurchaseOrderItem item = (PurchaseOrderItem)items.get(i);
                if (item.getItemType().isAdditionalChargeIndicator()) continue;
                eInvoiceFile = eInvoiceFile + this.getPOItemXMLChunk(item);
            }
            KualiDecimal totalDollarAmt = po.getTotalDollarAmount() == null ? KualiDecimal.ZERO : po.getTotalDollarAmount();
            eInvoiceFile = eInvoiceFile + "          </InvoiceDetailOrder>\n          <InvoiceDetailSummary>\n              <SubtotalAmount>\n                  <Money currency=\"USD\">" + po.getTotalPreTaxDollarAmount() + "</Money>\n              </SubtotalAmount>\n              <Tax>\n                  <Money currency=\"USD\">" + po.getTotalTaxAmount() + "</Money>\n                  <Description xml:lang=\"en\">Total Tax</Description>\n              </Tax>\n              <SpecialHandlingAmount>\n                  <Money currency=\"USD\">0.00</Money>\n              </SpecialHandlingAmount>\n              <ShippingAmount>\n                  <Money currency=\"USD\">0.00</Money>\n              </ShippingAmount>\n              <GrossAmount>\n                  <Money currency=\"USD\">" + totalDollarAmt + "</Money>\n              </GrossAmount>\n              <InvoiceDetailDiscount>\n                  <Money currency=\"USD\">0.00</Money>\n                  </InvoiceDetailDiscount>\n              <NetAmount>\n                  <Money currency=\"USD\">" + totalDollarAmt + "</Money>\n              </NetAmount>\n              <DepositAmount>\n                  <Money currency=\"USD\">0.00</Money>\n              </DepositAmount>\n              <DueAmount>\n                  <Money currency=\"USD\">" + totalDollarAmt + "</Money>\n              </DueAmount>\n          </InvoiceDetailSummary>\n      </InvoiceDetailRequest>\n  </Request>\n</cXML>";
            ServletOutputStream sos = response.getOutputStream();
            ByteArrayOutputStream baOutStream = new ByteArrayOutputStream();
            StringBufferInputStream inStream = new StringBufferInputStream(eInvoiceFile);
            this.convert(baOutStream, inStream);
            response.setContentLength(baOutStream.size());
            baOutStream.writeTo((OutputStream)sos);
            sos.flush();
        }
        return mapping.findForward("basic");
    }

    private String getPaymentTermXML(PurchaseOrderDocument po) {
        String returnXML = "";
        PaymentTermType paymentTerm = null;
        if (po.getVendorDetail() != null) {
            paymentTerm = po.getVendorDetail().getVendorPaymentTerms();
        }
        if (paymentTerm != null) {
            if (paymentTerm.getVendorNetDueNumber() != null) {
                returnXML = "              <InvoiceDetailPaymentTerm payInNumberOfDays=\"" + paymentTerm.getVendorNetDueNumber().toString() + "\" percentageRate=\"0\" />\n";
            } else if (paymentTerm.getVendorPaymentTermsPercent() != null) {
                returnXML = "              <InvoiceDetailPaymentTerm payInNumberOfDays=\"0\" percentageRate=\"" + paymentTerm.getVendorPaymentTermsPercent() + "\" />\n";
            }
        }
        return returnXML;
    }

    private String getPOItemXMLChunk(PurchaseOrderItem item) {
        String itemUnitPrice = item.getItemUnitPrice() == null ? "" : item.getItemUnitPrice().toString();
        String subTotal = "";
        if (item.getItemUnitPrice() != null && item.getItemQuantity() != null) {
            subTotal = item.getItemUnitPrice().multiply(item.getItemQuantity().bigDecimalValue()).toString();
        }
        return "              <InvoiceDetailItem invoiceLineNumber=\"" + item.getItemLineNumber() + "\"\n                  quantity=\"" + item.getItemQuantity() + "\">\n                  <UnitOfMeasure>" + item.getItemUnitOfMeasureCode() + "</UnitOfMeasure>\n                  <UnitPrice>\n                      <Money currency=\"USD\">" + itemUnitPrice + "</Money>\n                  </UnitPrice>\n                  <InvoiceDetailItemReference lineNumber=\"" + item.getItemLineNumber() + "\">\n                      <ItemID>\n                          <SupplierPartID>" + StringUtils.defaultString((String)item.getItemCatalogNumber()) + "</SupplierPartID>\n                      </ItemID>\n                      <Description xml:lang=\"en\">" + StringUtils.defaultString((String)item.getItemDescription()) + "</Description>\n                  </InvoiceDetailItemReference>\n                  <SubtotalAmount>\n                      <Money currency=\"USD\" >" + subTotal + "</Money>\n                  </SubtotalAmount>\n              </InvoiceDetailItem>\n";
    }

    private String getDeliveryAddressXMLChunk(String addressType, PurchaseOrderDocument po) {
        String deliveryDate = "";
        if (po.getDeliveryRequiredDate() != null) {
            deliveryDate = ElectronicInvoiceUtils.getDateDisplayText(po.getDeliveryRequiredDate());
        }
        String returnXML = "";
        returnXML = StringUtils.isNotEmpty((CharSequence)deliveryDate) ? returnXML + "              <InvoiceDetailShipping shippingDate=\"" + deliveryDate + "\"> <!--Delivery reqd date -->\n" : returnXML + "              <InvoiceDetailShipping> <!-- shipTo address same as billTo-->\n";
        returnXML = returnXML + this.getContactXMLChunk("shipTo", po) + "              </InvoiceDetailShipping>\n";
        return returnXML;
    }

    private String getContactXMLChunk(String addressType, PurchaseOrderDocument po) {
        String returnXML = "                  <Contact addressID=\"" + RandomUtils.nextInt() + "\" role=\"" + addressType + "\"> <!-- addressId=Random Unique Id -->\n                      <Name xml:lang=\"en\">" + po.getDeliveryCampusCode() + " - " + po.getDeliveryBuildingName() + "</Name> <!-- Format:CampusCode - Bldg Nm -->\n                      <PostalAddress>\n                          <Street>" + StringUtils.defaultString((String)po.getDeliveryBuildingLine1Address()) + "</Street>\n                          <Street>" + StringUtils.defaultString((String)po.getDeliveryBuildingLine2Address()) + "</Street>\n                          <City>" + StringUtils.defaultString((String)po.getDeliveryCityName()) + "</City>\n                          <State>" + StringUtils.defaultString((String)po.getDeliveryStateCode()) + "</State>\n                          <PostalCode>" + StringUtils.defaultString((String)po.getDeliveryPostalCode()) + "</PostalCode>\n                          <Country isoCountryCode=\"" + StringUtils.defaultString((String)po.getDeliveryCountryCode()) + "\">\n                              " + StringUtils.defaultString((String)po.getDeliveryCountryName()) + "\n                          </Country>\n                      </PostalAddress>\n";
        if (StringUtils.isNotEmpty((CharSequence)po.getDeliveryToEmailAddress())) {
            returnXML = returnXML + "                      <Email name=\"" + po.getDeliveryToEmailAddress() + "\">" + po.getDeliveryToEmailAddress() + "</Email>\n";
        }
        if (StringUtils.isNotEmpty((CharSequence)po.getDeliveryToPhoneNumber())) {
            returnXML = returnXML + "                      <Phone name=\"" + po.getDeliveryToPhoneNumber() + "\">\n                          <TelephoneNumber>\n                              <CountryCode isoCountryCode=\"US\">1</CountryCode>\n                              <AreaOrCityCode>" + this.getPhoneNumber(AREA_C0DE, po.getDeliveryToPhoneNumber()) + "</AreaOrCityCode>\n                              <Number>" + this.getPhoneNumber(PHONE_NUMBER, po.getDeliveryToPhoneNumber()) + "</Number>\n                          </TelephoneNumber>\n                      </Phone>\n";
        }
        returnXML = returnXML + "                  </Contact>\n";
        return returnXML;
    }

    private String getPhoneNumber(String whichPart, String phNo) {
        if (StringUtils.isEmpty((CharSequence)phNo)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)whichPart, (CharSequence)AREA_C0DE)) {
            return phNo.substring(0, 3);
        }
        if (StringUtils.equals((CharSequence)whichPart, (CharSequence)PHONE_NUMBER)) {
            return phNo.substring(3);
        }
        return "";
    }

    private boolean convert(OutputStream out, InputStream in) {
        try {
            int r;
            while ((r = in.read()) != -1) {
                out.write(r);
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    protected DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return documentService;
    }
}

