/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineParser;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableFormBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.exception.AccountingLineParserException;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentActionBase;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PurchasingAccountsPayableActionBase
extends KualiAccountingDocumentActionBase {
    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.copy(mapping, form, request, response);
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)kualiDocumentFormBase.getDocument();
        List<PurApItem> items = purapDocument.getItems();
        for (PurApItem item : items) {
            for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                account.setSequenceNumber(0);
            }
        }
        return actionForward;
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        PurchasingAccountsPayableFormBase purapForm = (PurchasingAccountsPayableFormBase)kualiDocumentFormBase;
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)purapForm.getDocument();
        purapForm.refreshAccountSummmary();
        for (Note note : document.getNotes()) {
            note.refreshReferenceObject("attachment");
        }
        ((PurapService)SpringContext.getBean(PurapService.class)).sortBelowTheLine(document);
        this.updateBaseline(document, (PurchasingAccountsPayableFormBase)kualiDocumentFormBase);
    }

    protected <T extends PurchasingAccountsPayableDocument, V extends KualiAccountingDocumentFormBase> void updateBaseline(T document, V form) {
        for (PurApItem item : document.getItems()) {
            item.getBaselineSourceAccountingLines().clear();
            for (PurApAccountingLine sourceAccount : item.getSourceAccountingLines()) {
                item.getBaselineSourceAccountingLines().add(sourceAccount);
            }
        }
    }

    public ActionForward refreshAccountSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purapForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)purapForm.getDocument();
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(document);
        purapForm.refreshAccountSummmary();
        return mapping.findForward("basic");
    }

    protected void uploadAccountingLines(boolean isSource, ActionForm form) throws FileNotFoundException, IOException {
        PurchasingAccountsPayableFormBase purapForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingAccountsPayableDocumentBase purapDocument = (PurchasingAccountsPayableDocumentBase)purapForm.getFinancialDocument();
        PurApAccountingLineParser accountingLineParser = (PurApAccountingLineParser)purapDocument.getAccountingLineParser();
        List importedLines = null;
        String errorPathPrefix = "accountDistributionnewSourceLine";
        try {
            FormFile sourceFile = purapForm.getSourceFile();
            this.checkUploadFile(sourceFile);
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath(errorPathPrefix);
            importedLines = accountingLineParser.importSourceAccountingLines(sourceFile.getFileName(), sourceFile.getInputStream(), purapDocument);
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPathPrefix);
        }
        catch (AccountingLineParserException e) {
            GlobalVariables.getMessageMap().putError(errorPathPrefix, e.getErrorKey(), e.getErrorParameters());
        }
        if (importedLines != null) {
            for (Object line : importedLines) {
                PurApAccountingLine importedLine = (PurApAccountingLine)line;
                ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveNonKeyFields((Object)importedLine);
                ((PurchasingFormBase)purapForm).addAccountDistributionsourceAccountingLine(importedLine);
            }
        }
    }

    public ActionForward insertSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purapForm = (PurchasingAccountsPayableFormBase)form;
        int itemIndex = this.getSelectedLine(request);
        PurApItem item = null;
        if (!this.processCustomInsertAccountingLine(purapForm, request)) {
            PurApAccountingLine line = null;
            boolean rulePassed = false;
            if (itemIndex >= 0) {
                item = ((PurchasingAccountsPayableDocument)purapForm.getDocument()).getItem(itemIndex);
                line = (PurApAccountingLine)((Object)ObjectUtils.deepCopy((Serializable)((Object)item.getNewSourceLine())));
                String errorPrefix = "document.item[" + Integer.toString(itemIndex) + "]." + "newSourceLine";
                rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddAccountingLineEvent(errorPrefix, purapForm.getDocument(), (AccountingLine)line));
            } else if (itemIndex == -2) {
                line = ((PurchasingFormBase)purapForm).getAccountDistributionnewSourceLine();
                String errorPrefix = "accountDistributionnewSourceLine";
                rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddAccountingLineEvent(errorPrefix, purapForm.getDocument(), (AccountingLine)line));
            }
            if (rulePassed) {
                ((PersistenceService)SpringContext.getBean(PersistenceService.class)).retrieveNonKeyFields((Object)line);
                if (itemIndex >= 0) {
                    this.insertAccountingLine(purapForm, item, line);
                    item.resetAccount();
                } else if (itemIndex == -2) {
                    ((PurchasingFormBase)purapForm).addAccountDistributionsourceAccountingLine(line);
                }
            }
        }
        return mapping.findForward("basic");
    }

    protected void insertAccountingLine(PurchasingAccountsPayableFormBase financialDocumentForm, PurApItem item, PurApAccountingLine line) {
        Integer index = item.getSourceAccountingLines().size() + 1;
        line.setSequenceNumber(index);
        item.getSourceAccountingLines().add(line);
    }

    protected void insertAccountingLine(KualiAccountingDocumentFormBase financialDocumentForm, PurApItem item, PurApAccountingLine line) {
        item.getSourceAccountingLines().add(line);
    }

    public boolean processCustomInsertAccountingLine(PurchasingAccountsPayableFormBase purapForm, HttpServletRequest request) {
        return false;
    }

    public ActionForward deleteSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purapForm = (PurchasingAccountsPayableFormBase)form;
        String[] indexes = this.getSelectedLineForAccounts(request);
        int itemIndex = Integer.parseInt(indexes[0]);
        int accountIndex = Integer.parseInt(indexes[1]);
        PurApItem item = ((PurchasingAccountsPayableDocument)purapForm.getDocument()).getItem(itemIndex);
        item.getSourceAccountingLines().remove(accountIndex);
        return mapping.findForward("basic");
    }

    public SourceAccountingLine getSourceAccountingLine(ActionForm form, HttpServletRequest request) {
        SourceAccountingLine line;
        String[] indexes = this.getSelectedLineForAccounts(request);
        int itemIndex = Integer.parseInt(indexes[0]);
        int accountIndex = Integer.parseInt(indexes[1]);
        PurchasingAccountsPayableFormBase purchasingAccountsPayableForm = (PurchasingAccountsPayableFormBase)form;
        if (itemIndex == -2) {
            line = this.customAccountRetrieval(accountIndex, purchasingAccountsPayableForm);
        } else {
            PurApItem item = ((PurchasingAccountsPayableDocument)purchasingAccountsPayableForm.getDocument()).getItem(itemIndex);
            line = (SourceAccountingLine)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)item.getSourceAccountingLines().get(accountIndex))));
        }
        return line;
    }

    protected SourceAccountingLine customAccountRetrieval(int accountIndex, PurchasingAccountsPayableFormBase purchasingAccountsPayableForm) {
        return null;
    }

    protected String[] getSelectedLineForAccounts(HttpServletRequest request) {
        String accountString = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            accountString = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
        }
        return StringUtils.split((String)accountString, (String)":");
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)((PurchasingAccountsPayableFormBase)form).getDocument();
        for (Note note : document.getNotes()) {
            note.refreshReferenceObject("attachment");
        }
        return super.downloadBOAttachment(mapping, form, request, response);
    }

    protected void processAccountingLineOverrides(List accountingLines) {
    }

    public ActionForward calculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward clearAllTaxes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected void customCalculate(PurchasingAccountsPayableDocument purapDoc) {
    }

    public ActionForward showAllAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiForm kualiForm = (KualiForm)form;
        String accountingLineTab = "AccountingLines";
        Map tabStates = kualiForm.getTabStates();
        HashMap<String, String> newTabStates = new HashMap<String, String>();
        for (Map.Entry tabEntry : tabStates.entrySet()) {
            String value;
            if (((String)tabEntry.getKey()).startsWith(accountingLineTab)) {
                newTabStates.put((String)tabEntry.getKey(), "OPEN");
                continue;
            }
            if (tabEntry.getValue() instanceof String) {
                value = (String)tabEntry.getValue();
            } else {
                Object result = tabEntry.getValue();
                value = ((String[])result)[0];
            }
            newTabStates.put((String)tabEntry.getKey(), value);
        }
        kualiForm.setTabStates(newTabStates);
        return mapping.findForward("basic");
    }

    public ActionForward hideAllAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiForm kualiForm = (KualiForm)form;
        String accountingLineTab = "AccountingLines";
        Map tabStates = kualiForm.getTabStates();
        HashMap<String, String> newTabStates = new HashMap<String, String>();
        for (Map.Entry tabEntry : tabStates.entrySet()) {
            String value;
            if (((String)tabEntry.getKey()).startsWith(accountingLineTab)) {
                newTabStates.put((String)tabEntry.getKey(), "CLOSE");
                continue;
            }
            if (tabEntry.getValue() instanceof String) {
                value = (String)tabEntry.getValue();
            } else {
                Object result = tabEntry.getValue();
                value = ((String[])result)[0];
            }
            newTabStates.put((String)tabEntry.getKey(), value);
        }
        kualiForm.setTabStates(newTabStates);
        return mapping.findForward("basic");
    }

    public ActionForward insertBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)((PurchasingAccountsPayableFormBase)form).getDocument();
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated()) {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)document);
        }
        return super.insertBONote(mapping, form, request, response);
    }
}

