/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.document.workflow.KFSDocumentSearchCustomizer;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValue;
import org.kuali.rice.kew.framework.document.search.DocumentSearchResultValues;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class KFSPurapDocumentSearchCustomizer
extends KFSDocumentSearchCustomizer {
    private IdentityManagementService identityManagementService;

    public DocumentSearchResultValues customizeResults(DocumentSearchCriteria documentSearchCriteria, List<DocumentSearchResult> defaultResults) {
        GlobalVariables.getMessageMap().putWarning("documentNumber", "warning.purchaseorder.number.dont.disclose", new String[0]);
        DocumentSearchResultValues.Builder customResultsBuilder = DocumentSearchResultValues.Builder.create();
        ArrayList<DocumentSearchResultValue.Builder> customResultValueBuilders = new ArrayList<DocumentSearchResultValue.Builder>();
        boolean isAuthorizedToViewPurapDocId = false;
        if (defaultResults.size() > 0) {
            for (DocumentAttribute documentAttribute : defaultResults.get(0).getDocumentAttributes()) {
                if (!"purapDocumentIdentifier".equals(documentAttribute.getName())) continue;
                isAuthorizedToViewPurapDocId = this.isAuthorizedToViewPurapDocId(documentSearchCriteria.getDocSearchUserId());
            }
        }
        for (DocumentSearchResult result : defaultResults) {
            ArrayList<DocumentAttributeString.Builder> custAttrBuilders = new ArrayList<DocumentAttributeString.Builder>();
            Document document = result.getDocument();
            for (DocumentAttribute documentAttribute : result.getDocumentAttributes()) {
                if (!"purapDocumentIdentifier".equals(documentAttribute.getName()) || isAuthorizedToViewPurapDocId || document.getStatus().getCategory().equals((Object)DocumentStatusCategory.SUCCESSFUL)) continue;
                DocumentAttributeString.Builder builder = DocumentAttributeString.Builder.create((String)"purapDocumentIdentifier");
                builder.setValue((Object)"********");
                custAttrBuilders.add(builder);
                break;
            }
            DocumentSearchResultValue.Builder builder = DocumentSearchResultValue.Builder.create((String)document.getDocumentId());
            builder.setDocumentAttributes(custAttrBuilders);
            customResultValueBuilders.add(builder);
        }
        customResultsBuilder.setResultValues(customResultValueBuilders);
        return customResultsBuilder.build();
    }

    public boolean isCustomizeResultsEnabled(String documentTypeName) {
        if ("PO".equalsIgnoreCase(documentTypeName) || "POSP".equalsIgnoreCase(documentTypeName)) {
            return true;
        }
        return super.isCustomizeResultsEnabled(documentTypeName);
    }

    protected boolean isAuthorizedToViewPurapDocId(String principalId) {
        if (StringUtils.isBlank((CharSequence)principalId)) {
            return false;
        }
        String namespaceCode = "KR-NS";
        String permissionTemplateName = "Full Unmask Field";
        HashMap roleQualifiers = new HashMap();
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("componentName", "PurchaseOrderDocument");
        permissionDetails.put("propertyName", "purapDocumentIdentifier");
        return this.identityManagementService.isAuthorizedByTemplateName(principalId, namespaceCode, permissionTemplateName, permissionDetails, roleQualifiers);
    }

    public void setIdentityManagementService(IdentityManagementService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }
}

