/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableSummaryAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurApSummaryItem;
import org.kuali.kfs.module.purap.dataaccess.PurApAccountingDao;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.event.PurchasingAccountsPayableItemPreCalculateEvent;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.module.purap.util.SummaryAccount;
import org.kuali.kfs.module.purap.util.UseTaxContainer;
import org.kuali.kfs.sys.businessobject.AccountingLineBase;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.util.ObjectPopulationUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class PurapAccountingServiceImpl
implements PurapAccountingService {
    private static final Logger LOG = LogManager.getLogger(PurapAccountingServiceImpl.class);
    protected static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    protected static final int SCALE = 340;
    protected static final int BIG_DECIMAL_ROUNDING_MODE = 4;
    protected static final int BIG_DECIMAL_SCALE = 2;
    protected static final Boolean ITEM_TYPES_INCLUDED_VALUE = Boolean.TRUE;
    protected static final Boolean ITEM_TYPES_EXCLUDED_VALUE = Boolean.FALSE;
    protected static final Boolean ZERO_TOTALS_RETURNED_VALUE = Boolean.TRUE;
    protected static final Boolean ZERO_TOTALS_NOT_RETURNED_VALUE = Boolean.FALSE;
    protected static final Boolean ALTERNATE_AMOUNT_USED = Boolean.TRUE;
    protected static final Boolean ALTERNATE_AMOUNT_NOT_USED = Boolean.FALSE;
    protected static final Boolean USE_TAX_INCLUDED = Boolean.TRUE;
    protected static final Boolean USE_TAX_EXCLUDED = Boolean.FALSE;
    protected ParameterService parameterService;
    protected PurapService purapService;
    protected PurApAccountingDao purApAccountingDao;
    protected BusinessObjectService businessObjectService;
    private KualiRuleService kualiRuleService;

    protected BigDecimal getLowestPossibleRoundUpNumber() {
        BigDecimal startingDigit = new BigDecimal(0.5);
        startingDigit = startingDigit.movePointLeft(340);
        return startingDigit;
    }

    protected void throwRuntimeException(String methodName, String errorMessage) {
        LOG.error(methodName + "  " + errorMessage);
        throw new RuntimeException(errorMessage);
    }

    @Override
    @Deprecated
    public List<PurApAccountingLine> generateAccountDistributionForProration(List<SourceAccountingLine> accounts, KualiDecimal totalAmount, Integer percentScale) {
        return null;
    }

    @Override
    public List<PurApAccountingLine> generateAccountDistributionForProration(List<SourceAccountingLine> accounts, KualiDecimal totalAmount, Integer percentScale, Class clazz) {
        BigDecimal difference;
        LOG.debug("generateAccountDistributionForProration() started");
        ArrayList<PurApAccountingLine> newAccounts = new ArrayList<PurApAccountingLine>();
        if (totalAmount.isZero()) {
            this.throwRuntimeException("generateAccountDistributionForProration()", "Purchasing/Accounts Payable account distribution for proration does not allow zero dollar total.");
        }
        BigDecimal percentTotal = BigDecimal.ZERO;
        BigDecimal totalAmountBigDecimal = totalAmount.bigDecimalValue();
        for (SourceAccountingLine accountingLine : accounts) {
            PurApAccountingLine newAccountingLine;
            KualiDecimal amt = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)accountingLine.getAmount())) {
                amt = accountingLine.getAmount();
            }
            LOG.debug("generateAccountDistributionForProration() " + accountingLine.getAccountNumber() + " " + amt + "/" + totalAmountBigDecimal);
            BigDecimal pct = amt.bigDecimalValue().divide(totalAmountBigDecimal, (int)percentScale, 4);
            pct = pct.stripTrailingZeros().multiply(ONE_HUNDRED);
            LOG.debug("generateAccountDistributionForProration() pct = " + pct + "  (trailing zeros removed)");
            BigDecimal lowestPossible = this.getLowestPossibleRoundUpNumber();
            if (lowestPossible.compareTo(pct) > 0) continue;
            try {
                newAccountingLine = (PurApAccountingLine)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to create instance of " + clazz.getName());
            }
            ObjectPopulationUtils.populateFromBaseClass(AccountingLineBase.class, (BusinessObject)accountingLine, (BusinessObject)newAccountingLine, PurapConstants.KNOWN_UNCOPYABLE_FIELDS);
            newAccountingLine.setAccountLinePercent(pct);
            LOG.debug("generateAccountDistributionForProration() adding " + newAccountingLine.getAccountLinePercent());
            newAccounts.add(newAccountingLine);
            percentTotal = percentTotal.add(newAccountingLine.getAccountLinePercent());
            LOG.debug("generateAccountDistributionForProration() total = " + percentTotal);
        }
        if (percentTotal.compareTo(BigDecimal.ZERO) == 0) {
            this.throwRuntimeException("generateAccountDistributionForProration()", "Can't round properly due to number of accounts");
        }
        if (ONE_HUNDRED.compareTo(percentTotal) < 0) {
            difference = percentTotal.subtract(ONE_HUNDRED);
            LOG.debug("generateAccountDistributionForProration() Rounding up by " + difference);
            boolean foundAccountToUse = false;
            for (int currentNbr = newAccounts.size() - 1; currentNbr >= 0; --currentNbr) {
                PurApAccountingLine potentialSlushAccount = (PurApAccountingLine)newAccounts.get(currentNbr);
                BigDecimal linePercent = BigDecimal.ZERO;
                if (ObjectUtils.isNotNull((Object)potentialSlushAccount.getAccountLinePercent())) {
                    linePercent = potentialSlushAccount.getAccountLinePercent();
                }
                if (difference.compareTo(linePercent) >= 0) continue;
                potentialSlushAccount.setAccountLinePercent(linePercent.subtract(difference).movePointLeft(2).stripTrailingZeros().movePointRight(2));
                foundAccountToUse = true;
                break;
            }
            if (!foundAccountToUse) {
                this.throwRuntimeException("generateAccountDistributionForProration()", "Can't round properly due to math calculation error");
            }
        } else if (ONE_HUNDRED.compareTo(percentTotal) > 0) {
            difference = ONE_HUNDRED.subtract(percentTotal);
            LOG.debug("generateAccountDistributionForProration() Rounding down by " + difference);
            PurApAccountingLine slushAccount = (PurApAccountingLine)newAccounts.get(newAccounts.size() - 1);
            BigDecimal slushLinePercent = BigDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)slushAccount.getAccountLinePercent())) {
                slushLinePercent = slushAccount.getAccountLinePercent();
            }
            slushAccount.setAccountLinePercent(slushLinePercent.add(difference).movePointLeft(2).stripTrailingZeros().movePointRight(2));
        }
        return newAccounts;
    }

    @Override
    public List<PurApAccountingLine> generateAccountDistributionForProrationWithZeroTotal(PurchasingAccountsPayableDocument purapDoc) {
        LOG.debug("generateAccountDistributionForProrationWithZeroTotal() started");
        List<PurApAccountingLine> accounts = this.generatePercentSummary(purapDoc);
        BigDecimal totalPercentValue = BigDecimal.ZERO;
        for (PurApAccountingLine accountingLine : accounts) {
            BigDecimal linePercent = BigDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)accountingLine.getAccountLinePercent())) {
                linePercent = accountingLine.getAccountLinePercent();
            }
            totalPercentValue = totalPercentValue.add(linePercent).movePointLeft(2).stripTrailingZeros().movePointRight(2);
        }
        if (BigDecimal.ZERO.compareTo(totalPercentValue.remainder(ONE_HUNDRED)) != 0) {
            this.throwRuntimeException("generateAccountDistributionForProrationWithZeroTotal()", "Invalid Percent Total of '" + totalPercentValue + "' does not allow for account distribution (must be multiple of 100)");
        }
        ArrayList<PurApAccountingLine> newAccounts = new ArrayList<PurApAccountingLine>();
        BigDecimal logDisplayOnlyTotal = BigDecimal.ZERO;
        BigDecimal percentUsed = BigDecimal.ZERO;
        int accountListSize = accounts.size();
        int i = 0;
        for (PurApAccountingLine accountingLine : accounts) {
            ++i;
            BigDecimal percentToUse = BigDecimal.ZERO;
            KualiDecimal amt = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)accountingLine.getAmount())) {
                amt = accountingLine.getAmount();
            }
            LOG.debug("generateAccountDistributionForProrationWithZeroTotal() " + accountingLine.getChartOfAccountsCode() + "-" + accountingLine.getAccountNumber() + " " + amt + "/" + percentToUse);
            BigDecimal acctPercent = BigDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)accountingLine.getAccountLinePercent())) {
                acctPercent = accountingLine.getAccountLinePercent();
            }
            if (i != accountListSize || accountListSize == 1) {
                percentToUse = acctPercent.divide(totalPercentValue, 340, 4).multiply(ONE_HUNDRED);
                percentUsed = percentUsed.add(acctPercent.divide(totalPercentValue, 340, 4).multiply(ONE_HUNDRED));
            } else {
                percentToUse = ONE_HUNDRED.subtract(percentUsed);
            }
            PurApAccountingLine newAccountingLine = accountingLine.createBlankAmountsCopy();
            LOG.debug("generateAccountDistributionForProrationWithZeroTotal() pct = " + percentToUse);
            newAccountingLine.setAccountLinePercent(percentToUse.setScale(acctPercent.scale(), 4));
            LOG.debug("generateAccountDistributionForProrationWithZeroTotal() adding " + newAccountingLine.getAccountLinePercent());
            newAccounts.add(newAccountingLine);
            logDisplayOnlyTotal = logDisplayOnlyTotal.add(newAccountingLine.getAccountLinePercent());
            LOG.debug("generateAccountDistributionForProrationWithZeroTotal() total = " + logDisplayOnlyTotal);
        }
        return newAccounts;
    }

    @Override
    public List<SourceAccountingLine> generateSummary(List<PurApItem> items) {
        LOG.debug("generateSummary() started");
        return this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryTaxableAccounts(List<PurApItem> items) {
        LOG.debug("generateSummaryTaxableAccounts() started");
        return this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, true);
    }

    @Override
    public List<SummaryAccount> generateSummaryAccounts(PurchasingAccountsPayableDocument document) {
        LOG.debug("generateSummaryAccounts() started");
        this.updateAccountAmounts(document);
        return this.generateSummaryAccounts(document.getItems(), ZERO_TOTALS_RETURNED_VALUE, USE_TAX_INCLUDED);
    }

    protected List<SummaryAccount> generateSummaryAccounts(List<PurApItem> items, Boolean useZeroTotals, Boolean useTaxIncluded) {
        LOG.debug("generateSummaryAccounts() started");
        ArrayList<SummaryAccount> returnList = new ArrayList<SummaryAccount>();
        List<SourceAccountingLine> sourceLines = this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, useZeroTotals, ALTERNATE_AMOUNT_NOT_USED, useTaxIncluded, false);
        for (SourceAccountingLine sourceAccountingLine : sourceLines) {
            SummaryAccount summaryAccount = new SummaryAccount();
            summaryAccount.setAccount((SourceAccountingLine)ObjectUtils.deepCopy((Serializable)sourceAccountingLine));
            block1: for (PurApItem item : items) {
                List<PurApAccountingLine> itemAccounts = item.getSourceAccountingLines();
                for (PurApAccountingLine purApAccountingLine : itemAccounts) {
                    if (!purApAccountingLine.accountStringsAreEqual(summaryAccount.getAccount())) continue;
                    PurApSummaryItem summaryItem = item.getSummaryItem();
                    KualiDecimal amt = KualiDecimal.ZERO;
                    if (ObjectUtils.isNotNull((Object)purApAccountingLine.getAmount())) {
                        amt = purApAccountingLine.getAmount();
                    }
                    if (summaryItem == null) continue;
                    summaryItem.setEstimatedEncumberanceAmount(amt);
                    summaryAccount.getItems().add(summaryItem);
                    continue block1;
                }
            }
            returnList.add(summaryAccount);
        }
        return returnList;
    }

    @Override
    public List<SummaryAccount> generateSummaryAccountsWithNoZeroTotals(PurchasingAccountsPayableDocument document) {
        LOG.debug("generateSummaryAccountsWithNoZeroTotals() started");
        this.updateAccountAmounts(document);
        return this.generateSummaryAccounts(document.getItems(), ZERO_TOTALS_NOT_RETURNED_VALUE, USE_TAX_INCLUDED);
    }

    @Override
    public List<SummaryAccount> generateSummaryAccountsWithNoZeroTotalsNoUseTax(PurchasingAccountsPayableDocument document) {
        LOG.debug("generateSummaryAccountsWithNoZeroTotalsNoUseTax() started");
        this.updateAccountAmounts(document);
        return this.generateSummaryAccounts(document.getItems(), ZERO_TOTALS_NOT_RETURNED_VALUE, USE_TAX_EXCLUDED);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryWithNoZeroTotals(List<PurApItem> items) {
        LOG.debug("generateSummaryWithNoZeroTotals() started");
        return this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_NOT_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryWithNoZeroTotalsNoUseTax(List<PurApItem> items) {
        LOG.debug("generateSummaryWithNoZeroTotalsNoUseTax() started");
        return this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_NOT_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_EXCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryWithNoZeroTotalsUsingAlternateAmount(List<PurApItem> items) {
        LOG.debug("generateSummaryWithNoZeroTotalsUsingAlternateAmount() started");
        return this.generateAccountSummary(items, null, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_NOT_RETURNED_VALUE, ALTERNATE_AMOUNT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryExcludeItemTypes(List<PurApItem> items, Set excludedItemTypeCodes) {
        LOG.debug("generateSummaryExcludeItemTypes() started");
        return this.generateAccountSummary(items, excludedItemTypeCodes, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryIncludeItemTypesAndNoZeroTotals(List<PurApItem> items, Set includedItemTypeCodes) {
        LOG.debug("generateSummaryIncludeItemTypesAndNoZeroTotals() started");
        return this.generateAccountSummary(items, includedItemTypeCodes, ITEM_TYPES_INCLUDED_VALUE, ZERO_TOTALS_NOT_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryIncludeItemTypes(List<PurApItem> items, Set includedItemTypeCodes) {
        LOG.debug("generateSummaryIncludeItemTypes() started");
        return this.generateAccountSummary(items, includedItemTypeCodes, ITEM_TYPES_INCLUDED_VALUE, ZERO_TOTALS_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    @Override
    public List<SourceAccountingLine> generateSummaryExcludeItemTypesAndNoZeroTotals(List<PurApItem> items, Set excludedItemTypeCodes) {
        LOG.debug("generateSummaryExcludeItemTypesAndNoZeroTotals() started");
        return this.generateAccountSummary(items, excludedItemTypeCodes, ITEM_TYPES_EXCLUDED_VALUE, ZERO_TOTALS_NOT_RETURNED_VALUE, ALTERNATE_AMOUNT_NOT_USED, USE_TAX_INCLUDED, false);
    }

    protected List<SourceAccountingLine> generateAccountSummary(List<PurApItem> items, Set<String> itemTypeCodes, Boolean itemTypeCodesAreIncluded, Boolean useZeroTotals, Boolean useAlternateAmount, Boolean useTaxIncluded, Boolean taxableOnly) {
        LOG.debug("generateAccountSummary() started");
        List<PurApItem> itemsToProcess = this.getProcessablePurapItems(items, itemTypeCodes, itemTypeCodesAreIncluded, useZeroTotals);
        HashMap<PurApAccountingLine, KualiDecimal> accountMap = new HashMap<PurApAccountingLine, KualiDecimal>();
        for (PurApItem currentItem : itemsToProcess) {
            Object document;
            if (!PurApItemUtils.checkItemActive(currentItem)) continue;
            List<PurApAccountingLine> sourceAccountingLines = currentItem.getSourceAccountingLines();
            if (taxableOnly.booleanValue() && !this.purapService.isTaxableForSummary((document = currentItem.getPurapDocument()).isUseTaxIndicator(), this.purapService.getDeliveryState((PurchasingAccountsPayableDocument)document), currentItem)) continue;
            if (!useTaxIncluded.booleanValue()) {
                PurApItem cloneItem = (PurApItem)((Object)ObjectUtils.deepCopy((Serializable)((Object)currentItem)));
                sourceAccountingLines = cloneItem.getSourceAccountingLines();
                this.updateAccountAmountsWithTotal(sourceAccountingLines, currentItem.getTotalRemitAmount());
            }
            for (PurApAccountingLine account : sourceAccountingLines) {
                Object document2;
                if (taxableOnly.booleanValue() && !this.purapService.isAccountingLineTaxable(account, this.purapService.isDeliveryStateTaxable(this.purapService.getDeliveryState((PurchasingAccountsPayableDocument)(document2 = currentItem.getPurapDocument()))))) continue;
                KualiDecimal total = KualiDecimal.ZERO;
                if (accountMap.containsKey(account)) {
                    total = (KualiDecimal)accountMap.get(account);
                }
                if (useAlternateAmount.booleanValue()) {
                    total = (KualiDecimal)total.add((AbstractKualiDecimal)account.getAlternateAmountForGLEntryCreation());
                } else if (ObjectUtils.isNotNull((Object)account.getAmount())) {
                    total = (KualiDecimal)total.add((AbstractKualiDecimal)account.getAmount());
                }
                accountMap.put(account, total);
            }
        }
        Iterator iterator = accountMap.keySet().iterator();
        ArrayList<SourceAccountingLine> sourceAccounts = new ArrayList<SourceAccountingLine>();
        while (iterator.hasNext()) {
            PurApAccountingLine accountToConvert = (PurApAccountingLine)iterator.next();
            if (accountToConvert.isEmpty()) {
                String errorMessage = "Found an 'empty' account in summary generation " + accountToConvert.toString();
                LOG.error("generateAccountSummary() " + errorMessage);
                throw new RuntimeException(errorMessage);
            }
            KualiDecimal sourceLineTotal = (KualiDecimal)accountMap.get(accountToConvert);
            SourceAccountingLine sourceLine = accountToConvert.generateSourceAccountingLine();
            sourceLine.setAmount(sourceLineTotal);
            sourceAccounts.add(sourceLine);
        }
        sourceAccounts.sort((sal1, sal2) -> {
            int compare = 0;
            if (sal1 != null && sal2 != null && sal1.getAccountNumber() != null && sal2.getAccountNumber() != null && (compare = sal1.getAccountNumber().compareTo(sal2.getAccountNumber())) == 0 && sal1.getFinancialObjectCode() != null && sal2.getFinancialObjectCode() != null) {
                compare = sal1.getFinancialObjectCode().compareTo(sal2.getFinancialObjectCode());
            }
            return compare;
        });
        return sourceAccounts;
    }

    protected List<PurApItem> getProcessablePurapItems(List<PurApItem> items, Set itemTypeCodes, Boolean itemTypeCodesAreIncluded, Boolean useZeroTotals) {
        String methodName = "getProcessablePurapItems()";
        ArrayList<PurApItem> newItemList = new ArrayList<PurApItem>();
        if (!ITEM_TYPES_INCLUDED_VALUE.equals(itemTypeCodesAreIncluded) && !ITEM_TYPES_EXCLUDED_VALUE.equals(itemTypeCodesAreIncluded)) {
            this.throwRuntimeException(methodName, "Invalid parameter found while trying to find processable items for dealing with purchasing/accounts payable accounts");
        }
        for (PurApItem currentItem : items) {
            if (itemTypeCodes != null && !itemTypeCodes.isEmpty()) {
                boolean foundMatchInList = false;
                for (Object code : itemTypeCodes) {
                    String itemTypeCode = (String)code;
                    if (!itemTypeCode.equals(currentItem.getItemType().getItemTypeCode())) continue;
                    foundMatchInList = true;
                    break;
                }
                if (foundMatchInList && ITEM_TYPES_EXCLUDED_VALUE.equals(itemTypeCodesAreIncluded) || !foundMatchInList && ITEM_TYPES_INCLUDED_VALUE.equals(itemTypeCodesAreIncluded)) {
                    continue;
                }
            } else if (ITEM_TYPES_INCLUDED_VALUE.equals(itemTypeCodesAreIncluded)) {
                this.throwRuntimeException(methodName, "Invalid parameter and list of items found while trying to find processable items for dealing with purchasing/accounts payable accounts");
            }
            if (ZERO_TOTALS_NOT_RETURNED_VALUE.equals(useZeroTotals) && (ObjectUtils.isNull((Object)currentItem.getExtendedPrice()) || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)currentItem.getExtendedPrice()) == 0)) continue;
            newItemList.add(currentItem);
        }
        return newItemList;
    }

    @Override
    public void updateAccountAmounts(PurchasingAccountsPayableDocument document) {
        PurchasingAccountsPayableDocumentBase purApDocument = (PurchasingAccountsPayableDocumentBase)document;
        String accountDistributionMethod = purApDocument.getAccountDistributionMethod();
        if (document instanceof PaymentRequestDocument && this.purapService.isFullDocumentEntryCompleted(document)) {
            this.convertMoneyToPercent((PaymentRequestDocument)document);
            return;
        }
        document.fixItemReferences();
        if ((document instanceof PaymentRequestDocument || document instanceof VendorCreditMemoDocument) && "S".equalsIgnoreCase(accountDistributionMethod)) {
            if (document instanceof VendorCreditMemoDocument) {
                VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)document;
                cmDocument.updateExtendedPriceOnItems();
                for (PurApItem item : document.getItems()) {
                    for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                        account.setAmount(KualiDecimal.ZERO);
                    }
                }
            }
            for (PurApItem purApItem : document.getItems()) {
                this.updatePreqItemAccountAmounts(purApItem);
            }
            return;
        }
        if ((document instanceof PaymentRequestDocument || document instanceof VendorCreditMemoDocument) && "P".equalsIgnoreCase(accountDistributionMethod)) {
            if (document instanceof VendorCreditMemoDocument) {
                VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)document;
                cmDocument.updateExtendedPriceOnItems();
                for (PurApItem item : document.getItems()) {
                    for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                        account.setAmount(KualiDecimal.ZERO);
                    }
                }
            }
            for (PurApItem purApItem : document.getItems()) {
                boolean rulePassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new PurchasingAccountsPayableItemPreCalculateEvent((Document)document, purApItem));
                if (!rulePassed) continue;
                this.updatePreqProportionalItemAccountAmounts(purApItem);
            }
            return;
        }
        if ("S".equalsIgnoreCase(accountDistributionMethod) && !document.getItems().isEmpty()) {
            this.kualiRuleService.applyRules((KualiDocumentEvent)new PurchasingAccountsPayableItemPreCalculateEvent((Document)document, document.getItems().get(0)));
            return;
        }
        if (!"S".equalsIgnoreCase(accountDistributionMethod)) {
            for (PurApItem purApItem : document.getItems()) {
                boolean rulePassed = this.kualiRuleService.applyRules((KualiDocumentEvent)new PurchasingAccountsPayableItemPreCalculateEvent((Document)document, purApItem));
                if (!rulePassed) continue;
                this.updateItemAccountAmounts(purApItem);
            }
        }
    }

    @Override
    public void updateItemAccountAmounts(PurApItem item) {
        List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
        KualiDecimal totalAmount = item.getTotalAmount();
        this.updateAccountAmountsWithTotal(sourceAccountingLines, totalAmount);
    }

    @Override
    public <T extends PurApAccountingLine> void updateAccountAmountsWithTotal(List<T> sourceAccountingLines, KualiDecimal totalAmount) {
        this.updateAccountAmountsWithTotal(sourceAccountingLines, totalAmount, new KualiDecimal(0));
    }

    @Override
    public <T extends PurApAccountingLine> void updateAccountAmountsWithTotal(List<T> sourceAccountingLines, KualiDecimal totalAmount, KualiDecimal discountAmount) {
        block13: {
            block12: {
                boolean noDiscount = true;
                if (discountAmount != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)discountAmount) != 0) {
                    noDiscount = false;
                }
                if (totalAmount == null || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)totalAmount) == 0) break block12;
                KualiDecimal accountTotal = KualiDecimal.ZERO;
                BigDecimal accountTotalPercent = BigDecimal.ZERO;
                PurApAccountingLine lastAccount = null;
                for (PurApAccountingLine account : sourceAccountingLines) {
                    if (ObjectUtils.isNotNull((Object)account.getAccountLinePercent()) || ObjectUtils.isNotNull((Object)account.getAmount())) {
                        if (ObjectUtils.isNotNull((Object)account.getAmount()) && account.getAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                            KualiDecimal amt = account.getAmount();
                            KualiDecimal calculatedPercent = new KualiDecimal(((KualiDecimal)((KualiDecimal)amt.multiply((AbstractKualiDecimal)new KualiDecimal(100))).divide((AbstractKualiDecimal)totalAmount)).toString());
                            account.setAccountLinePercent(calculatedPercent.bigDecimalValue().setScale(2));
                        }
                        if (ObjectUtils.isNotNull((Object)account.getAccountLinePercent())) {
                            BigDecimal pct = new BigDecimal(account.getAccountLinePercent().toString()).divide(new BigDecimal(100));
                            if (noDiscount) {
                                if (ObjectUtils.isNull((Object)account.getAmount()) || account.getAmount().isZero()) {
                                    account.setAmount(new KualiDecimal(pct.multiply(new BigDecimal(totalAmount.toString())).setScale(2, 4)));
                                }
                            } else {
                                account.setAmount(new KualiDecimal(pct.multiply(new BigDecimal(discountAmount.toString())).setScale(2, 4)));
                            }
                        }
                    }
                    if (ObjectUtils.isNotNull((Object)account.getAmount())) {
                        accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)account.getAmount());
                    }
                    if (ObjectUtils.isNotNull((Object)account.getAccountLinePercent())) {
                        accountTotalPercent = accountTotalPercent.add(account.getAccountLinePercent());
                    }
                    lastAccount = account;
                }
                if (lastAccount == null) break block13;
                KualiDecimal difference = noDiscount ? (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)accountTotal) : (KualiDecimal)discountAmount.subtract((AbstractKualiDecimal)accountTotal);
                if (ObjectUtils.isNotNull((Object)lastAccount.getAmount())) {
                    lastAccount.setAmount((KualiDecimal)lastAccount.getAmount().add((AbstractKualiDecimal)difference));
                }
                BigDecimal percentDifference = new BigDecimal(100).subtract(accountTotalPercent).setScale(2);
                if (!ObjectUtils.isNotNull((Object)lastAccount.getAccountLinePercent())) break block13;
                lastAccount.setAccountLinePercent(lastAccount.getAccountLinePercent().add(percentDifference));
                break block13;
            }
            for (PurApAccountingLine account : sourceAccountingLines) {
                account.setAmount(KualiDecimal.ZERO);
            }
        }
    }

    @Override
    public void updatePreqProportionalItemAccountAmounts(PurApItem item) {
        List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
        KualiDecimal totalAmount = item.getTotalAmount();
        this.updatePreqProporationalAccountAmountsWithTotal(sourceAccountingLines, totalAmount);
    }

    @Override
    public <T extends PurApAccountingLine> void updatePreqProporationalAccountAmountsWithTotal(List<T> sourceAccountingLines, KualiDecimal totalAmount) {
        block7: {
            block6: {
                if (totalAmount == null || KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)totalAmount) == 0) break block6;
                KualiDecimal accountTotal = KualiDecimal.ZERO;
                BigDecimal accountTotalPercent = BigDecimal.ZERO;
                PurApAccountingLine lastAccount = null;
                for (PurApAccountingLine account : sourceAccountingLines) {
                    if ((ObjectUtils.isNotNull((Object)account.getAccountLinePercent()) || ObjectUtils.isNotNull((Object)account.getAmount())) && ObjectUtils.isNotNull((Object)account.getAccountLinePercent())) {
                        BigDecimal pct = new BigDecimal(account.getAccountLinePercent().toString()).divide(new BigDecimal(100));
                        account.setAmount(new KualiDecimal(pct.multiply(new BigDecimal(totalAmount.toString())).setScale(2, 4)));
                    }
                    if (ObjectUtils.isNotNull((Object)account.getAmount())) {
                        accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)account.getAmount());
                    }
                    if (ObjectUtils.isNotNull((Object)account.getAccountLinePercent())) {
                        accountTotalPercent = accountTotalPercent.add(account.getAccountLinePercent());
                    }
                    lastAccount = account;
                }
                if (lastAccount == null) break block7;
                KualiDecimal difference = (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)accountTotal);
                if (ObjectUtils.isNotNull((Object)lastAccount.getAmount())) {
                    lastAccount.setAmount((KualiDecimal)lastAccount.getAmount().add((AbstractKualiDecimal)difference));
                }
                BigDecimal percentDifference = new BigDecimal(100).subtract(accountTotalPercent).setScale(2);
                if (!ObjectUtils.isNotNull((Object)lastAccount.getAccountLinePercent())) break block7;
                lastAccount.setAccountLinePercent(lastAccount.getAccountLinePercent().add(percentDifference));
                break block7;
            }
            for (PurApAccountingLine account : sourceAccountingLines) {
                account.setAmount(KualiDecimal.ZERO);
            }
        }
    }

    @Override
    public void updatePreqItemAccountAmounts(PurApItem item) {
        List<PurApAccountingLine> sourceAccountingLines = item.getSourceAccountingLines();
        KualiDecimal totalAmount = item.getTotalAmount();
        this.updatePreqAccountAmountsWithTotal(sourceAccountingLines, totalAmount);
    }

    @Override
    public <T extends PurApAccountingLine> void updatePreqAccountAmountsWithTotal(List<T> sourceAccountingLines, KualiDecimal totalAmount) {
        if (totalAmount != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)totalAmount) != 0) {
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            PurApAccountingLine lastAccount = null;
            for (PurApAccountingLine account : sourceAccountingLines) {
                if (account.getAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    if (totalAmount.isZero()) {
                        account.setAmount(KualiDecimal.ZERO);
                    } else if (account.getAmount().isGreaterThan((AbstractKualiDecimal)totalAmount)) {
                        account.setAmount(totalAmount);
                    }
                }
                totalAmount = (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)account.getAmount());
            }
            if (totalAmount.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                for (PurApAccountingLine account : sourceAccountingLines) {
                    if (!account.getAmount().isZero() && account.getAccountLinePercent().compareTo(BigDecimal.ZERO) != 1) continue;
                    KualiDecimal priorAmount = account.getAmount();
                    account.setAmount((KualiDecimal)account.getAmount().add((AbstractKualiDecimal)((KualiDecimal)((KualiDecimal)new KualiDecimal(account.getAccountLinePercent()).multiply((AbstractKualiDecimal)totalAmount)).divide((AbstractKualiDecimal)new KualiDecimal(100)))));
                    accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)((KualiDecimal)account.getAmount().subtract((AbstractKualiDecimal)priorAmount)));
                    lastAccount = account;
                }
            }
            if ((accountTotal = (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)accountTotal)).isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && ObjectUtils.isNotNull(lastAccount)) {
                lastAccount.setAmount((KualiDecimal)lastAccount.getAmount().add((AbstractKualiDecimal)accountTotal));
            }
        } else {
            for (PurApAccountingLine account : sourceAccountingLines) {
                account.setAmount(KualiDecimal.ZERO);
            }
        }
    }

    public List<PurApAccountingLine> generatePercentSummary(PurchasingAccountsPayableDocument purapDoc) {
        ArrayList<PurApAccountingLine> accounts = new ArrayList<PurApAccountingLine>();
        for (PurApItem currentItem : purapDoc.getItems()) {
            if (!PurApItemUtils.checkItemActive(currentItem)) continue;
            for (PurApAccountingLine account : currentItem.getSourceAccountingLines()) {
                boolean thisAccountAlreadyInSet = false;
                for (PurApAccountingLine alreadyAddedAccount : accounts) {
                    if (!alreadyAddedAccount.accountStringsAreEqual(account)) continue;
                    BigDecimal alreadyAddedAccountLinePercent = BigDecimal.ZERO;
                    if (ObjectUtils.isNotNull((Object)alreadyAddedAccount.getAccountLinePercent())) {
                        alreadyAddedAccountLinePercent = alreadyAddedAccount.getAccountLinePercent();
                    }
                    BigDecimal accountLinePercent = BigDecimal.ZERO;
                    if (ObjectUtils.isNotNull((Object)account.getAccountLinePercent())) {
                        accountLinePercent = account.getAccountLinePercent();
                    }
                    alreadyAddedAccount.setAccountLinePercent(alreadyAddedAccountLinePercent.add(accountLinePercent));
                    thisAccountAlreadyInSet = true;
                    break;
                }
                if (thisAccountAlreadyInSet) continue;
                PurApAccountingLine accountToAdd = (PurApAccountingLine)((Object)ObjectUtils.deepCopy((Serializable)((Object)account)));
                accounts.add(accountToAdd);
            }
        }
        return accounts;
    }

    @Override
    public void convertMoneyToPercent(PaymentRequestDocument pr) {
        LOG.debug("convertMoneyToPercent() started");
        for (Object item : pr.getItems()) {
            PaymentRequestItem paymentRequestItem = (PaymentRequestItem)item;
            String identifier = paymentRequestItem.getItemIdentifierString();
            if (paymentRequestItem.getTotalAmount() == null || !paymentRequestItem.getTotalAmount().isNonZero()) continue;
            int numOfAccounts = paymentRequestItem.getSourceAccountingLines().size();
            BigDecimal percentTotal = BigDecimal.ZERO;
            BigDecimal percentTotalRoundUp = BigDecimal.ZERO;
            KualiDecimal accountTotal = KualiDecimal.ZERO;
            int accountIdentifier = 0;
            for (PurApAccountingLine purApAccountingLine : paymentRequestItem.getSourceAccountingLines()) {
                ++accountIdentifier;
                PaymentRequestAccount account = (PaymentRequestAccount)purApAccountingLine;
                KualiDecimal accountAmount = KualiDecimal.ZERO;
                if (ObjectUtils.isNotNull((Object)account.getAmount())) {
                    accountAmount = account.getAmount();
                }
                KualiDecimal extendedPrice = paymentRequestItem.getTotalAmount();
                BigDecimal tmpPercent = accountAmount.bigDecimalValue().divide(extendedPrice.bigDecimalValue(), (int)PurapConstants.CREDITMEMO_PRORATION_SCALE, 4);
                if (accountIdentifier == numOfAccounts) {
                    tmpPercent = BigDecimal.ONE.subtract(percentTotal);
                }
                BigDecimal calcAmountBd = tmpPercent.multiply(extendedPrice.bigDecimalValue());
                KualiDecimal calcAmount = new KualiDecimal(calcAmountBd = calcAmountBd.setScale(2, 4));
                if (calcAmount.compareTo((AbstractKualiDecimal)accountAmount) != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("convertMoneyToPercent() Rounding error on " + account);
                    }
                    String param1 = identifier + "." + accountIdentifier;
                    String param2 = calcAmount.bigDecimalValue().subtract(accountAmount.bigDecimalValue()).toString();
                    GlobalVariables.getMessageMap().putError(paymentRequestItem.getItemIdentifierString(), "errors.item.accounting.rounding", new String[]{param1, param2});
                    account.setAmount(calcAmount);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("convertMoneyToPercent() updating percent to " + tmpPercent);
                }
                account.setAccountLinePercent(tmpPercent.multiply(new BigDecimal(100)));
                if (accountIdentifier == numOfAccounts) {
                    account.setAccountLinePercent(new BigDecimal(100).subtract(percentTotalRoundUp));
                }
                accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)calcAmount);
                percentTotal = percentTotal.add(tmpPercent);
                percentTotalRoundUp = percentTotalRoundUp.add(account.getAccountLinePercent());
            }
        }
    }

    @Override
    public void deleteSummaryAccounts(Integer purapDocumentIdentifier, String docType) {
        if ("PREQ".equals(docType)) {
            this.purApAccountingDao.deleteSummaryAccountsbyPaymentRequestIdentifier(purapDocumentIdentifier);
        } else if ("CM".equals(docType)) {
            this.purApAccountingDao.deleteSummaryAccountsbyCreditMemoIdentifier(purapDocumentIdentifier);
        }
    }

    @Override
    public List getAccountsPayableSummaryAccounts(Integer purapDocumentIdentifier, String docType) {
        if ("PREQ".equals(docType)) {
            return this.getSummaryAccountsbyPaymentRequestIdentifier(purapDocumentIdentifier);
        }
        if ("CM".equals(docType)) {
            this.getSummaryAccountsbyCreditMemoIdentifier(purapDocumentIdentifier);
        }
        return null;
    }

    @Override
    public List<PurApAccountingLine> getAccountsFromItem(PurApItem item) {
        return this.purApAccountingDao.getAccountingLinesForItem(item);
    }

    @Override
    public List<SourceAccountingLine> generateSourceAccountsForVendorRemit(PurchasingAccountsPayableDocument document) {
        this.updateAccountAmounts(document);
        return this.generateSummaryWithNoZeroTotalsNoUseTax(document.getItems());
    }

    protected KualiDecimal calculateSumTotal(List<SourceAccountingLine> accounts) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (SourceAccountingLine accountingLine : accounts) {
            KualiDecimal amt = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)accountingLine.getAmount())) {
                amt = accountingLine.getAmount();
            }
            total = (KualiDecimal)total.add((AbstractKualiDecimal)amt);
        }
        return total;
    }

    protected void convertAmtToTax(List<PurApAccountingLine> accounts, KualiDecimal useTax, List<SourceAccountingLine> newSourceLines) {
        KualiDecimal proratedAmt;
        PurApAccountingLine purApAccountingLine;
        BigDecimal HUNDRED = new BigDecimal(100);
        KualiDecimal total = KualiDecimal.ZERO;
        int last = accounts.size() - 1;
        for (int i = 0; i < last; ++i) {
            purApAccountingLine = accounts.get(i);
            BigDecimal linePercent = BigDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)purApAccountingLine.getAccountLinePercent())) {
                linePercent = purApAccountingLine.getAccountLinePercent();
            }
            BigDecimal proratedAmtBD = useTax.bigDecimalValue().multiply(linePercent);
            proratedAmtBD = proratedAmtBD.divide(HUNDRED);
            proratedAmt = new KualiDecimal(proratedAmtBD);
            SourceAccountingLine acctLine = purApAccountingLine.generateSourceAccountingLine();
            acctLine.setAmount(proratedAmt);
            newSourceLines.add(acctLine);
            total = (KualiDecimal)total.add((AbstractKualiDecimal)proratedAmt);
        }
        proratedAmt = (KualiDecimal)useTax.subtract((AbstractKualiDecimal)total);
        purApAccountingLine = accounts.get(last);
        SourceAccountingLine acctLine = purApAccountingLine.generateSourceAccountingLine();
        acctLine.setAmount(proratedAmt);
        newSourceLines.add(acctLine);
    }

    @Override
    public List<UseTaxContainer> generateUseTaxAccount(PurchasingAccountsPayableDocument document) {
        ArrayList<UseTaxContainer> useTaxAccounts = new ArrayList<UseTaxContainer>();
        HashMap<PurApItemUseTax, UseTaxContainer> useTaxItemMap = new HashMap<PurApItemUseTax, UseTaxContainer>();
        Class accountingLineClass = null;
        if (!document.isUseTaxIndicator()) {
            return useTaxAccounts;
        }
        for (PurApItem purApItem : document.getItems()) {
            if (purApItem.getUseTaxItems().isEmpty()) continue;
            if (accountingLineClass == null) {
                accountingLineClass = purApItem.getAccountingLineClass();
            }
            for (PurApItemUseTax itemUseTax : purApItem.getUseTaxItems()) {
                UseTaxContainer useTaxContainer;
                if (useTaxItemMap.containsKey(itemUseTax)) {
                    useTaxContainer = (UseTaxContainer)useTaxItemMap.get(itemUseTax);
                    PurApItemUseTax exisitingItemUseTax = useTaxContainer.getUseTax();
                    KualiDecimal tax = exisitingItemUseTax.getTaxAmount();
                    tax = (KualiDecimal)tax.add((AbstractKualiDecimal)itemUseTax.getTaxAmount());
                    exisitingItemUseTax.setTaxAmount(tax);
                    List<PurApItem> items = useTaxContainer.getItems();
                    items.add(purApItem);
                    useTaxContainer.setItems(items);
                    continue;
                }
                useTaxContainer = new UseTaxContainer(itemUseTax, purApItem);
                useTaxItemMap.put(itemUseTax, useTaxContainer);
                useTaxAccounts.add(useTaxContainer);
            }
        }
        for (UseTaxContainer useTaxContainer : useTaxAccounts) {
            List<SourceAccountingLine> origSourceAccounts = this.generateSummaryWithNoZeroTotals(useTaxContainer.getItems());
            KualiDecimal totalAmount = this.calculateSumTotal(origSourceAccounts);
            List<PurApAccountingLine> accountingLines = this.generateAccountDistributionForProration(origSourceAccounts, totalAmount, PurapConstants.PRORATION_SCALE, accountingLineClass);
            ArrayList<SourceAccountingLine> newSourceLines = new ArrayList<SourceAccountingLine>();
            this.convertAmtToTax(accountingLines, useTaxContainer.getUseTax().getTaxAmount(), newSourceLines);
            useTaxContainer.setAccounts(newSourceLines);
        }
        useTaxAccounts = new ArrayList(useTaxItemMap.values());
        return useTaxAccounts;
    }

    @Override
    public boolean isTaxAccount(PurchasingAccountsPayableDocument document, SourceAccountingLine account) {
        String incomeClassCode;
        boolean isTaxAccount = false;
        if (document instanceof PaymentRequestDocument && StringUtils.isNotEmpty((CharSequence)(incomeClassCode = ((PaymentRequestDocument)document).getTaxClassificationCode()))) {
            String federalChartCode = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_CHART");
            String federalAccountNumber = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_ACCOUNT");
            String federalObjectCode = this.parameterService.getSubParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_FEDERAL_OBJECT_CODE_BY_INCOME_CLASS", incomeClassCode);
            String stateChartCode = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_CHART");
            String stateAccountNumber = this.parameterService.getParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_ACCOUNT");
            String stateObjectCode = this.parameterService.getSubParameterValueAsString(PaymentRequestDocument.class, "NON_RESIDENT_ALIEN_TAX_STATE_OBJECT_CODE_BY_INCOME_CLASS", incomeClassCode);
            String chartCode = account.getChartOfAccountsCode();
            String accountNumber = account.getAccountNumber();
            String objectCode = account.getFinancialObjectCode();
            boolean isFederalAccount = StringUtils.equals((CharSequence)federalChartCode, (CharSequence)chartCode);
            isFederalAccount &= StringUtils.equals((CharSequence)federalAccountNumber, (CharSequence)accountNumber);
            boolean isStateAccount = StringUtils.equals((CharSequence)stateChartCode, (CharSequence)chartCode);
            isStateAccount &= StringUtils.equals((CharSequence)stateAccountNumber, (CharSequence)accountNumber);
            isTaxAccount = (isFederalAccount &= StringUtils.equals((CharSequence)federalObjectCode, (CharSequence)objectCode)) || (isStateAccount &= StringUtils.equals((CharSequence)stateObjectCode, (CharSequence)objectCode));
        }
        return isTaxAccount;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setPurApAccountingDao(PurApAccountingDao purApAccountingDao) {
        this.purApAccountingDao = purApAccountingDao;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    @Override
    public List<SourceAccountingLine> mergeAccountingLineLists(List<SourceAccountingLine> accountingLines1, List<SourceAccountingLine> accountingLines2) {
        ArrayList<SourceAccountingLine> mergedAccountList = new ArrayList<SourceAccountingLine>();
        for (SourceAccountingLine line1 : accountingLines1) {
            KualiDecimal line1Amount = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)line1.getAmount())) {
                line1Amount = line1.getAmount();
            }
            for (SourceAccountingLine line2 : accountingLines2) {
                KualiDecimal line2Amount = KualiDecimal.ZERO;
                if (ObjectUtils.isNotNull((Object)line2.getAmount())) {
                    line2Amount = line2.getAmount();
                }
                if (!line1.equals((Object)line2)) continue;
                KualiDecimal totalAmount = (KualiDecimal)line1Amount.add((AbstractKualiDecimal)line2Amount);
                line1.setAmount(totalAmount);
            }
            mergedAccountList.add(line1);
        }
        return mergedAccountList;
    }

    @Override
    public List getSummaryAccountsbyPaymentRequestIdentifier(Integer paymentRequestIdentifier) {
        if (paymentRequestIdentifier != null) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("paymentRequestIdentifier", paymentRequestIdentifier);
            return new ArrayList(this.businessObjectService.findMatching(AccountsPayableSummaryAccount.class, fieldValues));
        }
        return null;
    }

    @Override
    public List getSummaryAccountsbyCreditMemoIdentifier(Integer creditMemoIdentifier) {
        if (creditMemoIdentifier != null) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("creditMemoIdentifier", creditMemoIdentifier);
            return new ArrayList(this.businessObjectService.findMatching(AccountsPayableSummaryAccount.class, fieldValues));
        }
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }
}

