/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.dataaccess.SensitiveDataDao;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.service.SensitiveDataService;

public class SensitiveDataServiceImpl
implements SensitiveDataService {
    private static final Logger LOG = LogManager.getLogger();
    private SensitiveDataDao sensitiveDataDao;
    private PurchaseOrderDao purchaseOrderDao;
    private BusinessObjectService businessObjectService;

    @Override
    public SensitiveData getSensitiveDataByCode(String sensitiveDataCode) {
        LOG.debug("getSensitiveDataByCode(String) started");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("sensitiveDataCode", sensitiveDataCode);
        return (SensitiveData)this.businessObjectService.findByPrimaryKey(SensitiveData.class, primaryKeys);
    }

    @Override
    public List<SensitiveData> getAllSensitiveDatas() {
        LOG.debug("getSensitiveDataByPoId(Integer) started");
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        Collection sdColl = this.businessObjectService.findAll(SensitiveData.class);
        for (Object sd : sdColl) {
            sds.add((SensitiveData)((Object)sd));
        }
        return sds;
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByRelatedDocId(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        Integer poId = this.purchaseOrderDao.getPurchaseOrderIdForCurrentPurchaseOrderByRelatedDocId(accountsPayablePurchasingDocumentLinkIdentifier);
        return this.getSensitiveDatasAssignedByPoId(poId);
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByPoId(Integer poId) {
        LOG.debug("getSensitiveDatasAssignedByPoId(Integer) started");
        return this.sensitiveDataDao.getSensitiveDatasAssignedByPoId(poId);
    }

    @Override
    public void deletePurchaseOrderSensitiveDatas(Integer poId) {
        LOG.debug("deletePurchaseOrderSensitiveDatas(Integer) started");
        this.sensitiveDataDao.deletePurchaseOrderSensitiveDatas(poId);
    }

    @Override
    public SensitiveDataAssignment getLastSensitiveDataAssignment(Integer poId) {
        LOG.debug("getLastSensitiveDataAssignment(Integer) started");
        return this.sensitiveDataDao.getLastSensitiveDataAssignment(poId);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPurchaseOrderDao(PurchaseOrderDao purchaseOrderDao) {
        this.purchaseOrderDao = purchaseOrderDao;
    }

    public void setSensitiveDataDao(SensitiveDataDao sensitiveDataDao) {
        this.sensitiveDataDao = sensitiveDataDao;
    }
}

