/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.OjbCollectionAware;
import org.kuali.kfs.module.purap.util.PurApObjectUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.orm.ObjectRetrievalFailureException;

public class PurApOjbCollectionHelper {
    public static final int MAX_DEPTH = 2;

    public void processCollections(OjbCollectionAware template, PersistableBusinessObject orig, PersistableBusinessObject copy) {
        this.processCollectionsRecurse(template, orig, copy, 2);
    }

    private void processCollectionsRecurse(OjbCollectionAware template, PersistableBusinessObject orig, PersistableBusinessObject copy, int depth) {
        if (copy == null || depth < 1) {
            return;
        }
        List originalCollections = orig.buildListOfDeletionAwareLists();
        if (originalCollections != null && !originalCollections.isEmpty()) {
            try {
                List copyCollections = copy.buildListOfDeletionAwareLists();
                int size = originalCollections.size();
                if (copyCollections.size() != size) {
                    throw new RuntimeException("size mismatch while attempting to process list of Collections to manage");
                }
                for (int i = 0; i < size; ++i) {
                    Collection origSource = (Collection)originalCollections.get(i);
                    Collection copySource = (Collection)copyCollections.get(i);
                    List list = this.findUnwantedElements(copySource, origSource, template, depth - 1);
                    this.cleanse(template, list);
                }
            }
            catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
                // empty catch block
            }
        }
    }

    public void processCollections2(OjbCollectionAware template, PersistableBusinessObject orig, PersistableBusinessObject copy) {
        if (copy == null) {
            return;
        }
        List originalCollections = orig.buildListOfDeletionAwareLists();
        if (originalCollections != null && !originalCollections.isEmpty()) {
            try {
                List copyCollections = copy.buildListOfDeletionAwareLists();
                int size = originalCollections.size();
                if (copyCollections.size() != size) {
                    throw new RuntimeException("size mismatch while attempting to process list of Collections to manage");
                }
                for (int i = 0; i < size; ++i) {
                    Collection origSource = (Collection)originalCollections.get(i);
                    Collection copySource = (Collection)copyCollections.get(i);
                    List list = this.findUnwantedElements(copySource, origSource, null, 0);
                    this.cleanse(template, list);
                }
            }
            catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
                // empty catch block
            }
        }
    }

    private void cleanse(OjbCollectionAware template, List unwantedItems) {
        if (unwantedItems.size() > 0) {
            for (Object unwantedItem : unwantedItems) {
                template.getPersistenceBrokerTemplate().delete(unwantedItem);
            }
        }
    }

    private List findUnwantedElements(Collection fromList, Collection controlList, OjbCollectionAware template, int depth) {
        ArrayList<PersistableBusinessObject> toRemove = new ArrayList<PersistableBusinessObject>();
        for (Object from : fromList) {
            PersistableBusinessObject copyLine = (PersistableBusinessObject)from;
            PersistableBusinessObject line = (PersistableBusinessObject)PurApObjectUtils.retrieveObjectWithIdentitcalKey(controlList, (BusinessObject)copyLine);
            if (ObjectUtils.isNull((Object)line)) {
                toRemove.add(copyLine);
                continue;
            }
            this.processCollectionsRecurse(template, line, copyLine, depth);
        }
        return toRemove;
    }
}

