/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.ReadableInstant;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.AbstractRelatedView;
import org.kuali.kfs.module.purap.businessobject.BulkReceivingView;
import org.kuali.kfs.module.purap.businessobject.CorrectionReceivingView;
import org.kuali.kfs.module.purap.businessobject.CreditMemoView;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectView;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingView;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApGenericAttributes;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.RequisitionView;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class PurApRelatedViews {
    private String documentNumber;
    private Integer accountsPayablePurchasingDocumentLinkIdentifier;
    private transient List<RequisitionView> relatedRequisitionViews;
    private transient List<PurchaseOrderView> relatedPurchaseOrderViews;
    private transient List<PaymentRequestView> relatedPaymentRequestViews;
    private transient List<PaymentRequestView> paymentHistoryPaymentRequestViews;
    private transient List<CreditMemoView> relatedCreditMemoViews;
    private transient List<CreditMemoView> paymentHistoryCreditMemoViews;
    private transient List<LineItemReceivingView> relatedLineItemReceivingViews;
    private transient List<CorrectionReceivingView> relatedCorrectionReceivingViews;
    private transient List<BulkReceivingView> relatedBulkReceivingViews;
    private transient List<PurchaseOrderViewGroup> groupedRelatedPurchaseOrderViews;
    private transient List<ReceivingViewGroup> groupedRelatedReceivingViews;
    private transient List<ElectronicInvoiceRejectView> relatedRejectViews;

    public PurApRelatedViews(String documentNumber, Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        this.documentNumber = documentNumber;
        this.accountsPayablePurchasingDocumentLinkIdentifier = accountsPayablePurchasingDocumentLinkIdentifier;
    }

    public void resetRelatedViews() {
        this.relatedRequisitionViews = null;
        this.relatedPurchaseOrderViews = null;
        this.relatedPaymentRequestViews = null;
        this.paymentHistoryPaymentRequestViews = null;
        this.relatedCreditMemoViews = null;
        this.paymentHistoryCreditMemoViews = null;
        this.relatedLineItemReceivingViews = null;
        this.relatedCorrectionReceivingViews = null;
        this.relatedBulkReceivingViews = null;
        this.groupedRelatedPurchaseOrderViews = null;
        this.groupedRelatedReceivingViews = null;
        this.relatedRejectViews = null;
    }

    public List updateRelatedView(Class<?> clazz, List<? extends AbstractRelatedView> relatedList, boolean removeCurrentDocument) {
        if (relatedList == null) {
            relatedList = ((PurapService)SpringContext.getBean(PurapService.class)).getRelatedViews(clazz, this.accountsPayablePurchasingDocumentLinkIdentifier);
            if (removeCurrentDocument) {
                for (AbstractRelatedView view : relatedList) {
                    this.maskPONumberIfUnapproved(view);
                    if (!this.documentNumber.equals(view.getDocumentNumber())) continue;
                    relatedList.remove((Object)view);
                    break;
                }
            }
        }
        return relatedList;
    }

    protected void maskPONumberIfUnapproved(AbstractRelatedView view) {
        DocumentStatus documentStatus;
        String poIDstr = "";
        if (ObjectUtils.isNotNull((Object)view.getPurapDocumentIdentifier())) {
            poIDstr = view.getPurapDocumentIdentifier().toString();
        }
        if ("PO".equals(view.getDocumentTypeName()) && !StringUtils.equals((CharSequence)(documentStatus = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatus(view.getDocumentNumber())).getCode(), (CharSequence)DocumentStatus.FINAL.getCode())) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String namespaceCode = "KR-NS";
            String permissionTemplateName = "Full Unmask Field";
            HashMap roleQualifiers = new HashMap();
            HashMap<String, String> permissionDetails = new HashMap<String, String>();
            permissionDetails.put("componentName", PurchaseOrderDocument.class.getSimpleName());
            permissionDetails.put("propertyName", "purapDocumentIdentifier");
            IdentityManagementService identityManagementService = (IdentityManagementService)SpringContext.getBean(IdentityManagementService.class);
            boolean isAuthorized = identityManagementService.isAuthorizedByTemplateName(principalId, namespaceCode, permissionTemplateName, permissionDetails, roleQualifiers);
            if (!isAuthorized) {
                poIDstr = "";
                int strLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(PurApGenericAttributes.class.getName(), "purapDocumentIdentifier");
                for (int i = 0; i < strLength; ++i) {
                    poIDstr = poIDstr.concat("*");
                }
            }
        }
        view.setPoNumberMasked(poIDstr);
    }

    public org.kuali.rice.kew.api.document.Document getWorkflowDocument(String documentId) {
        return KewApiServiceLocator.getWorkflowDocumentService().getDocument(documentId);
    }

    protected Document findDocument(String documentHeaderId) {
        Document document = null;
        try {
            document = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(documentHeaderId);
        }
        catch (UnknownDocumentTypeException | WorkflowException throwable) {
            // empty catch block
        }
        return document;
    }

    public List<RequisitionView> getRelatedRequisitionViews() {
        this.relatedRequisitionViews = this.updateRelatedView(RequisitionView.class, this.relatedRequisitionViews, true);
        return this.relatedRequisitionViews;
    }

    public List<ElectronicInvoiceRejectView> getRelatedRejectViews() {
        this.relatedRejectViews = this.updateRelatedView(ElectronicInvoiceRejectView.class, this.relatedRejectViews, true);
        return this.relatedRejectViews;
    }

    public List<PurchaseOrderView> getRelatedPurchaseOrderViews() {
        if (this.relatedPurchaseOrderViews != null) {
            return this.relatedPurchaseOrderViews;
        }
        this.relatedPurchaseOrderViews = this.updateRelatedView(PurchaseOrderView.class, this.relatedPurchaseOrderViews, true);
        this.relatedPurchaseOrderViews.sort((v1, v2) -> {
            if (v1 != null && v2 != null && v1.getPurapDocumentIdentifier() != null && v2.getPurapDocumentIdentifier() != null) {
                int compare = -v1.getPurapDocumentIdentifier().compareTo(v2.getPurapDocumentIdentifier());
                if (compare == 0) {
                    compare = v1.getPurchaseOrderCurrentIndicator() ? -1 : (v2.getPurchaseOrderCurrentIndicator() ? 1 : -v1.getCreateDate().compareTo((ReadableInstant)v2.getCreateDate()));
                }
                return compare;
            }
            return 0;
        });
        return this.relatedPurchaseOrderViews;
    }

    public List<PurchaseOrderViewGroup> getGroupedRelatedPurchaseOrderViews() {
        if (this.groupedRelatedPurchaseOrderViews != null) {
            return this.groupedRelatedPurchaseOrderViews;
        }
        this.groupedRelatedPurchaseOrderViews = new ArrayList<PurchaseOrderViewGroup>();
        PurchaseOrderViewGroup group = new PurchaseOrderViewGroup();
        int previousPOID = 0;
        this.relatedPurchaseOrderViews = this.getRelatedPurchaseOrderViews();
        for (PurchaseOrderView view : this.relatedPurchaseOrderViews) {
            if (previousPOID == 0) {
                previousPOID = view.getPurapDocumentIdentifier();
            }
            if (view.getPurapDocumentIdentifier() == previousPOID) {
                group.getViews().add(view);
            } else {
                this.groupedRelatedPurchaseOrderViews.add(group);
                group = new PurchaseOrderViewGroup();
                group.getViews().add(view);
                previousPOID = view.getPurapDocumentIdentifier();
            }
            if (this.relatedPurchaseOrderViews.size() != this.relatedPurchaseOrderViews.indexOf((Object)view) + 1) continue;
            this.groupedRelatedPurchaseOrderViews.add(group);
        }
        return this.groupedRelatedPurchaseOrderViews;
    }

    public List<PaymentRequestView> getRelatedPaymentRequestViews() {
        this.relatedPaymentRequestViews = this.updateRelatedView(PaymentRequestView.class, this.relatedPaymentRequestViews, true);
        return this.relatedPaymentRequestViews;
    }

    public List<CreditMemoView> getRelatedCreditMemoViews() {
        this.relatedCreditMemoViews = this.updateRelatedView(CreditMemoView.class, this.relatedCreditMemoViews, true);
        return this.relatedCreditMemoViews;
    }

    public List<PaymentRequestView> getPaymentHistoryPaymentRequestViews() {
        this.paymentHistoryPaymentRequestViews = this.updateRelatedView(PaymentRequestView.class, this.paymentHistoryPaymentRequestViews, false);
        return this.paymentHistoryPaymentRequestViews;
    }

    public List<CreditMemoView> getPaymentHistoryCreditMemoViews() {
        this.paymentHistoryCreditMemoViews = this.updateRelatedView(CreditMemoView.class, this.paymentHistoryCreditMemoViews, false);
        return this.paymentHistoryCreditMemoViews;
    }

    public List<LineItemReceivingView> getRelatedLineItemReceivingViews() {
        this.relatedLineItemReceivingViews = this.updateRelatedView(LineItemReceivingView.class, this.relatedLineItemReceivingViews, true);
        return this.relatedLineItemReceivingViews;
    }

    public List<CorrectionReceivingView> getRelatedCorrectionReceivingViews() {
        this.relatedCorrectionReceivingViews = this.updateRelatedView(CorrectionReceivingView.class, this.relatedCorrectionReceivingViews, true);
        return this.relatedCorrectionReceivingViews;
    }

    public List<BulkReceivingView> getRelatedBulkReceivingViews() {
        this.relatedBulkReceivingViews = this.updateRelatedView(BulkReceivingView.class, this.relatedBulkReceivingViews, true);
        return this.relatedBulkReceivingViews;
    }

    public List<ReceivingViewGroup> getGroupedRelatedReceivingViews() {
        if (this.groupedRelatedReceivingViews != null) {
            return this.groupedRelatedReceivingViews;
        }
        this.groupedRelatedReceivingViews = new ArrayList<ReceivingViewGroup>();
        PurapService purapService = (PurapService)SpringContext.getBean(PurapService.class);
        List liviews = purapService.getRelatedViews(LineItemReceivingView.class, this.accountsPayablePurchasingDocumentLinkIdentifier);
        List crviews = purapService.getRelatedViews(CorrectionReceivingView.class, this.accountsPayablePurchasingDocumentLinkIdentifier);
        for (LineItemReceivingView liview : liviews) {
            ReceivingViewGroup group = new ReceivingViewGroup();
            group.lineItemView = liview;
            for (CorrectionReceivingView crview : crviews) {
                if (!StringUtils.equals((CharSequence)crview.getLineItemReceivingDocumentNumber(), (CharSequence)liview.getDocumentNumber()) || this.documentNumber.equals(crview.getDocumentNumber())) continue;
                group.addCorrectionView(crview);
            }
            this.groupedRelatedReceivingViews.add(group);
        }
        return this.groupedRelatedReceivingViews;
    }

    public class ReceivingViewGroup {
        protected LineItemReceivingView lineItemView;
        protected List<CorrectionReceivingView> correctionViews = new ArrayList<CorrectionReceivingView>();

        protected ReceivingViewGroup() {
        }

        public LineItemReceivingView getLineItemView() {
            return this.lineItemView;
        }

        public List<CorrectionReceivingView> getCorrectionViews() {
            return this.correctionViews;
        }

        public void addCorrectionView(CorrectionReceivingView correctionView) {
            this.correctionViews.add(correctionView);
        }

        public boolean getIsLineItemViewCurrentDocument() {
            return this.lineItemView != null && PurApRelatedViews.this.documentNumber.equals(this.lineItemView.getDocumentNumber());
        }
    }

    public class PurchaseOrderViewGroup {
        protected List<PurchaseOrderView> views = new ArrayList<PurchaseOrderView>();

        protected PurchaseOrderViewGroup() {
        }

        public List<PurchaseOrderView> getViews() {
            return this.views;
        }
    }
}

