/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.util.cxml.B2BPOResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BPunchOutOrderFileType;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponse;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponseFileType;
import org.kuali.kfs.module.purap.util.cxml.PurchaseOrderResponse;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class B2BParserHelper {
    private static Logger LOG = LogManager.getLogger(B2BParserHelper.class);
    private DocumentBuilder builder;
    private static B2BParserHelper _this;
    protected BatchInputFileService batchInputFileService;
    protected PunchOutSetupResponseFileType punchOutSetupResponseFileType;
    protected B2BPunchOutOrderFileType b2BPunchOutOrderFileType;
    protected B2BPOResponseFileType b2BPOResponseFileType;

    private B2BParserHelper() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        builderFactory.setIgnoringElementContentWhitespace(true);
        try {
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static B2BParserHelper getInstance() {
        if (_this == null) {
            _this = new B2BParserHelper();
        }
        return _this;
    }

    public synchronized B2BShoppingCart parseShoppingCartXML(String xmlChunk) {
        Document xmlDoc;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPunchOutOrder");
        B2BPunchOutOrderFileType fileType = this.getB2BPunchOutOrderFileType();
        return (B2BShoppingCart)this.getBatchInputFileService().parse((BatchInputFileType)fileType, xmlDocAsBytes);
    }

    public synchronized PunchOutSetupResponse parsePunchOutSetupResponse(String xmlChunk) {
        Document xmlDoc;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPunchOutResponse");
        PunchOutSetupResponseFileType fileType = this.getPunchOutSetupResponseFileType();
        return (PunchOutSetupResponse)this.getBatchInputFileService().parse((BatchInputFileType)fileType, xmlDocAsBytes);
    }

    public synchronized PurchaseOrderResponse parsePurchaseOrderResponse(String xmlChunk) {
        Document xmlDoc;
        try {
            xmlDoc = this.builder.parse(new ByteArrayInputStream(xmlChunk.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        byte[] xmlDocAsBytes = this.addXMLNameSpace(xmlDoc, "http://www.kuali.org/kfs/purap/b2bPOResponse");
        B2BPOResponseFileType fileType = this.getB2BPOResponseFileType();
        return (PurchaseOrderResponse)this.getBatchInputFileService().parse((BatchInputFileType)fileType, xmlDocAsBytes);
    }

    private byte[] addXMLNameSpace(Document xmlDoc, String nameSpace) {
        Element element = xmlDoc.getDocumentElement();
        element.setAttribute("xmlns", nameSpace);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            LOG.fatal("Failed to serialize xml." + e);
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    protected BatchInputFileService getBatchInputFileService() {
        if (this.batchInputFileService == null) {
            this.batchInputFileService = (BatchInputFileService)SpringContext.getBean(BatchInputFileService.class);
        }
        return this.batchInputFileService;
    }

    protected void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    protected PunchOutSetupResponseFileType getPunchOutSetupResponseFileType() {
        if (this.punchOutSetupResponseFileType == null) {
            this.punchOutSetupResponseFileType = (PunchOutSetupResponseFileType)((Object)SpringContext.getBean(PunchOutSetupResponseFileType.class));
        }
        return this.punchOutSetupResponseFileType;
    }

    protected void setPunchOutSetupResponseFileType(PunchOutSetupResponseFileType punchOutSetupResponseFileType) {
        this.punchOutSetupResponseFileType = punchOutSetupResponseFileType;
    }

    protected B2BPunchOutOrderFileType getB2BPunchOutOrderFileType() {
        if (this.b2BPunchOutOrderFileType == null) {
            this.b2BPunchOutOrderFileType = (B2BPunchOutOrderFileType)((Object)SpringContext.getBean(B2BPunchOutOrderFileType.class));
        }
        return this.b2BPunchOutOrderFileType;
    }

    protected void setB2BPunchOutOrderFileType(B2BPunchOutOrderFileType b2BPunchOutOrderFileType) {
        this.b2BPunchOutOrderFileType = b2BPunchOutOrderFileType;
    }

    protected B2BPOResponseFileType getB2BPOResponseFileType() {
        if (this.b2BPOResponseFileType == null) {
            this.b2BPOResponseFileType = (B2BPOResponseFileType)((Object)SpringContext.getBean(B2BPOResponseFileType.class));
        }
        return this.b2BPOResponseFileType;
    }

    protected void setB2BPOResponseFileType(B2BPOResponseFileType b2BPOResponseFileType) {
        this.b2BPOResponseFileType = b2BPOResponseFileType;
    }
}

