/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.authorization.PurapAccountingLineAuthorizer;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PurapAccountingLineAuthorizerTest {
    private PurapAccountingLineAuthorizer cut;

    @Before
    public void setup() {
        this.cut = new PurapAccountingLineAuthorizer();
    }

    @Test
    public void findTheItemForAccountingLine_notPurApDoc_Null() {
        AccountingLine accountingLine = null;
        AccountingDocument accountingDocMock = (AccountingDocument)Mockito.mock(AccountingDocument.class);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine(accountingDocMock, accountingLine);
        Assert.assertNull((Object)purApItem);
    }

    @Test
    public void findTheItemForAccountingLine_noItems_Null() {
        AccountingLine accountingLine = null;
        PurchasingAccountsPayableDocumentBase accountingDocMock = (PurchasingAccountsPayableDocumentBase)Mockito.mock(PurchasingAccountsPayableDocumentBase.class);
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(Collections.emptyList());
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLine);
        Assert.assertNull((Object)purApItem);
    }

    @Test
    public void findTheItemForAccountingLine_noAccountingLinesInItems_Null() {
        AccountingLine accountingLineMock = (AccountingLine)Mockito.mock(AccountingLine.class);
        PurchasingAccountsPayableDocumentBase accountingDocMock = (PurchasingAccountsPayableDocumentBase)Mockito.mock(PurchasingAccountsPayableDocumentBase.class);
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        purApItems.add((PurApItem)Mockito.mock(PurApItem.class));
        purApItems.add((PurApItem)Mockito.mock(PurApItem.class));
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLineMock);
        Assert.assertNull((Object)purApItem);
    }

    @Test
    public void findTheItemForAccountingLine_noMatchingAccountingLine_Null() {
        AccountingLine accountingLineMock = (AccountingLine)Mockito.mock(AccountingLine.class);
        PurchasingAccountsPayableDocumentBase accountingDocMock = (PurchasingAccountsPayableDocumentBase)Mockito.mock(PurchasingAccountsPayableDocumentBase.class);
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        PurApItem purApItemMock = (PurApItem)Mockito.mock(PurApItem.class);
        ArrayList<PurApAccountingLine> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add((PurApAccountingLine)Mockito.mock(PurApAccountingLine.class));
        sourceAccountingLines.add((PurApAccountingLine)Mockito.mock(PurApAccountingLine.class));
        Mockito.when((Object)purApItemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        purApItems.add(purApItemMock);
        purApItems.add((PurApItem)Mockito.mock(PurApItem.class));
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, accountingLineMock);
        Assert.assertNull((Object)purApItem);
    }

    @Test
    public void findTheItemForAccountingLine_matchingAccountingLine_Returned() {
        PurApAccountingLine accountingLineMock = (PurApAccountingLine)Mockito.mock(PurApAccountingLine.class);
        PurchasingAccountsPayableDocumentBase accountingDocMock = (PurchasingAccountsPayableDocumentBase)Mockito.mock(PurchasingAccountsPayableDocumentBase.class);
        ArrayList<PurApItem> purApItems = new ArrayList<PurApItem>();
        PurApItem purApItemMock = (PurApItem)Mockito.mock(PurApItem.class);
        ArrayList<PurApAccountingLine> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
        sourceAccountingLines.add(accountingLineMock);
        sourceAccountingLines.add((PurApAccountingLine)Mockito.mock(PurApAccountingLine.class));
        Mockito.when((Object)purApItemMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        purApItems.add(purApItemMock);
        purApItems.add((PurApItem)Mockito.mock(PurApItem.class));
        Mockito.when((Object)accountingDocMock.getItems()).thenReturn(purApItems);
        PurApItem purApItem = this.cut.findTheItemForAccountingLine((AccountingDocument)accountingDocMock, (AccountingLine)accountingLineMock);
        Assert.assertEquals(purApItems.get(0), (Object)purApItem);
    }
}

