/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.math.BigDecimal;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.B2BShoppingService;
import org.kuali.kfs.module.purap.fixture.B2BShoppingCartFixture;
import org.kuali.kfs.module.purap.fixture.B2BShoppingCartItemFixture;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

@ConfigureContext(session=UserNameFixture.parke)
public class B2BShoppingServiceIntegTest
extends KualiIntegTestBase {
    public void testCreateRequisitionsFromCxml() {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        boolean enableB2bByDuns = parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_B2B_BY_VENDOR_DUNS_NUMBER_IND");
        RequisitionDocument req = this.createRequisitionFromCxml(enableB2bByDuns);
        B2BShoppingCartItemFixture b2bItem = null;
        if (enableB2bByDuns) {
            b2bItem = B2BShoppingCartItemFixture.B2B_ITEM_USING_VENDOR_DUNS;
            String duns = req.getVendorDetail().getVendorDunsNumber();
            B2BShoppingServiceIntegTest.assertEquals((String)duns, (String)b2bItem.duns);
        } else {
            b2bItem = B2BShoppingCartItemFixture.B2B_ITEM_USING_VENDOR_ID;
            String vendorNumber = req.getVendorNumber();
            B2BShoppingServiceIntegTest.assertEquals((String)vendorNumber, (String)b2bItem.externalSupplierId);
        }
        String supplierID = req.getExternalOrganizationB2bSupplierIdentifier();
        B2BShoppingServiceIntegTest.assertEquals((String)supplierID, (String)b2bItem.systemSupplierID);
        B2BShoppingServiceIntegTest.assertEquals((int)req.getItems().size(), (int)1);
        RequisitionItem reqItem = (RequisitionItem)req.getItem(0);
        B2BShoppingServiceIntegTest.assertNotNull((Object)reqItem);
        B2BShoppingServiceIntegTest.assertEquals((int)reqItem.getItemQuantity().compareTo((AbstractKualiDecimal)new KualiDecimal(b2bItem.quantity)), (int)0);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getItemCatalogNumber(), (String)b2bItem.supplierPartId);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getItemAuxiliaryPartIdentifier(), (String)b2bItem.supplierPartAuxiliaryId);
        B2BShoppingServiceIntegTest.assertEquals((int)reqItem.getItemUnitPrice().compareTo(new BigDecimal(b2bItem.unitPrice)), (int)0);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getItemDescription(), (String)b2bItem.description);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getItemUnitOfMeasureCode(), (String)b2bItem.unitOfMeasure);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getExternalOrganizationB2bProductTypeName(), (String)b2bItem.productSource);
        B2BShoppingServiceIntegTest.assertEquals((String)reqItem.getExternalOrganizationB2bProductReferenceNumber(), (String)b2bItem.systemProductID);
    }

    protected RequisitionDocument createRequisitionFromCxml(boolean enableB2bByDunsNumber) {
        B2BShoppingCartFixture cartFixture = null;
        cartFixture = enableB2bByDunsNumber ? B2BShoppingCartFixture.B2B_CART_USING_VENDOR_DUNS : B2BShoppingCartFixture.B2B_CART_USING_VENDOR_ID;
        B2BShoppingCart cart = cartFixture.createB2BShoppingCart();
        Person user = GlobalVariables.getUserSession().getPerson();
        RequisitionDocument req = null;
        try {
            List reqs = ((B2BShoppingService)SpringContext.getBean(B2BShoppingService.class)).createRequisitionsFromCxml(cart, user);
            B2BShoppingServiceIntegTest.assertNotNull((Object)reqs);
            B2BShoppingServiceIntegTest.assertEquals((int)reqs.size(), (int)1);
            req = (RequisitionDocument)reqs.get(0);
            B2BShoppingServiceIntegTest.assertNotNull((Object)req);
        }
        catch (WorkflowException e) {
            B2BShoppingServiceIntegTest.fail((String)e.getMessage());
        }
        return req;
    }
}

