/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Date;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.service.DisbursementVoucherValidationService;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PaymentRequestDao;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.impl.PaymentRequestServiceImpl;
import org.kuali.kfs.module.purap.document.service.impl.PurapServiceImpl;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PaymentRequestServiceImplTest {
    private static final String DUPLICATE_DV_TEXT = "Duplicate DV Text";
    private static final KualiDecimal INVOICE_AMOUNT = new KualiDecimal(100.0);
    private static final String INVOICE_NUMBER = "a1*2-3.45";
    private static final int PO_ID = 100;
    private static final Date TODAY = Date.valueOf(LocalDate.now());
    private PaymentRequestServiceImpl cut;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private DisbursementVoucherValidationService disbursementVoucherValidationSvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PaymentRequestDao paymentRequestDaoMock;
    @Mock
    private PaymentRequestDocument paymentRequestDocumentMock;
    @Mock
    private PurchaseOrderDocument purchaseOrderDocumentMock;
    private Properties purapResources;
    private Properties fpResources;
    private String expectedDuplicateInvoiceDvWarning;
    private String expectedDuplicateInvoiceDvWarningNoQuestion;
    private String expectedDuplicateInvoicePreqWarning;
    private String expectedDuplicateInvoiceDateAmountDvWarning;
    private String expectedDuplicateInvoiceDateAmountDvWarningNoQuestion;
    private String expectedDuplicateInvoiceDateAmountPreqWarning;
    private String expectedDuplicateInvoiceCancelledOrVoidedPreqToken;
    private String expectedDuplicateInvoiceCancelledPreqToken;
    private String expectedDuplicateInvoiceDateAmountVoidedPreqWarning;
    private String expectedDuplicateInvoiceVoided;
    private String expectedDuplicateInvoiceDateAmountCancelledPreqWarning;
    private String expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockMessages();
        this.setupMockDocuments();
        this.setupMockParameters();
        PurapServiceImpl purapService = new PurapServiceImpl();
        purapService.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.cut = new PaymentRequestServiceImpl();
        this.cut.setConfigurationService(this.configurationSvcMock);
        this.cut.setDisbursementVoucherValidationService(this.disbursementVoucherValidationSvcMock);
        this.cut.setPaymentRequestDao(this.paymentRequestDaoMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setPurapService((PurapService)purapService);
    }

    private void setupMockMessages() {
        this.purapResources = TestDataPreparator.loadPropertiesFromClassPath((String)"org/kuali/kfs/module/purap/purap-resources.properties");
        this.fpResources = TestDataPreparator.loadPropertiesFromClassPath((String)"org/kuali/kfs/fp/fp-resources.properties");
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> this.purapResources.getProperty((String)invocationOnMock.getArguments()[0]));
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("warning.duplicate.invoice.question")).thenReturn((Object)this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDvWarning = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "Payee", "");
        this.expectedDuplicateInvoicePreqWarning = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "for the specified payee", "");
        this.expectedDuplicateInvoiceDateAmountPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceCancelledPreqToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceVoided = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "vendor ID", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "on the specified PO", this.fpResources.getProperty("warning.duplicate.invoice.question"));
    }

    private void setupMockDocuments() {
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purchaseOrderDocumentMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.paymentRequestDocumentMock.getInvoiceNumber()).thenReturn((Object)"A$1%2-345");
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderIdentifier()).thenReturn((Object)100);
        Mockito.when((Object)this.paymentRequestDocumentMock.getVendorInvoiceAmount()).thenReturn((Object)INVOICE_AMOUNT);
        Mockito.when((Object)this.paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)TODAY);
    }

    private void setupMockParameters() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)true);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)true);
    }

    @Test
    public void checkForDuplicatePaymentRequests_nullPO_VALID() {
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void checkForDuplicatePaymentRequests_nullPO_oldInvoiceDate_VALID() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusYears(2L)));
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.purapResources.getProperty("message.invoice.date.a.year.or.more.past"), messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequests_hasPO_VALID() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void checkForDuplicatePaymentRequests_hasPO_oldInvoiceDate_VALID() {
        Mockito.when((Object)this.paymentRequestDocumentMock.getInvoiceDate()).thenReturn((Object)Date.valueOf(LocalDate.now().minusYears(2L)));
        Mockito.when((Object)this.paymentRequestDocumentMock.getPurchaseOrderDocument()).thenReturn((Object)this.purchaseOrderDocumentMock);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.purapResources.getProperty("message.invoice.date.a.year.or.more.past"), messages.get("PREQDuplicateInvoice"));
    }

    private List<PaymentRequestDocument> buildDuplicatePaymentRequests(boolean hasDuplicate, boolean hasCancelledDuplicate, boolean hasVoidedDuplicate) {
        ArrayList<PaymentRequestDocument> duplicatePaymentRequests = new ArrayList<PaymentRequestDocument>();
        if (hasDuplicate) {
            duplicatePaymentRequests.add(this.buildMockPaymentRequestDocument("In Process"));
        }
        if (hasCancelledDuplicate) {
            duplicatePaymentRequests.add(this.buildMockPaymentRequestDocument("Cancelled"));
        }
        if (hasVoidedDuplicate) {
            duplicatePaymentRequests.add(this.buildMockPaymentRequestDocument("Cancelled In Process"));
        }
        return duplicatePaymentRequests;
    }

    private PaymentRequestDocument buildMockPaymentRequestDocument(String applicationDocumentStatus) {
        PaymentRequestDocument duplicatePaymentRequestDocumentMock = (PaymentRequestDocument)Mockito.mock(PaymentRequestDocument.class);
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getInvoiceNumber()).thenReturn((Object)"A12345");
        Mockito.when((Object)duplicatePaymentRequestDocumentMock.getApplicationDocumentStatus()).thenReturn((Object)applicationDocumentStatus);
        return duplicatePaymentRequestDocumentMock;
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Cancelled() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceCancelled = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceCancelled, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Cancelled_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceCancelledNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelled"), "Payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceCancelledNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Voided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceVoidedPayeeToken = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceVoidedPayeeToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_Voided_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceVoidedPayeeTokenNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.voided"), "Payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceVoidedPayeeTokenNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledOrVoided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceCancelledOrVoided = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "Payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceCancelledOrVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledOrVoided_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceCancelledOrVoidedNoQuestion = MessageFormat.format(this.purapResources.getProperty("errors.duplicate.vendor.invoice.cancelledOrVoided"), "Payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceCancelledOrVoidedNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledVoidedAndNormal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateVendorNumberInvoiceNumber_CancelledVoidedAndNormal_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Cancelled() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Cancelled_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelled"), "for the specified payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Voided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_Voided_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountVoidedDvWarningNoQuestion = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.voided"), "for the specified payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountVoidedDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledOrVoided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "for the specified payee", this.fpResources.getProperty("warning.duplicate.invoice.question"));
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledOrVoided_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        String expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning = MessageFormat.format(this.purapResources.getProperty("message.duplicate.invoice.date.amount.cancelledOrVoided"), "for the specified payee", "");
        Assert.assertEquals((Object)expectedDuplicateInvoiceDateAmountCancelledOrVoidedDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledVoidedAndNormal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", true);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePaymentRequestsByDetails_duplicateInvoiceDateInvoiceTotal_CancelledVoidedAndNormal_NO_QUESTION() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByInvoiceAmountInvoiceDate(Integer.valueOf(1), Integer.valueOf(1), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePaymentRequests(Integer.valueOf(1), Integer.valueOf(1), INVOICE_NUMBER, INVOICE_AMOUNT, TODAY, "Payee", "for the specified payee", false);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountDvWarningNoQuestion, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_noDuplicatePreq() {
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_noDuplicatePreq() {
        this.setupDuplicateDvMessages();
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
    }

    private void setupDuplicateDvMessages() {
        HashMap<String, String> duplicateDvMessages = new HashMap<String, String>();
        duplicateDvMessages.put("DvDuplicateInvoice", DUPLICATE_DV_TEXT);
        PurchaseOrderDocument po = this.paymentRequestDocumentMock.getPurchaseOrderDocument();
        String disbVchrPayeeIdNumber = po.getVendorHeaderGeneratedIdentifier() + "-" + po.getVendorDetailAssignedIdentifier();
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(this.paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, this.paymentRequestDocumentMock.getInvoiceDate(), this.paymentRequestDocumentMock.getVendorInvoiceAmount(), true)).thenReturn(duplicateDvMessages);
        Mockito.when((Object)this.disbursementVoucherValidationSvcMock.checkForDuplicateDisbursementVouchers(this.paymentRequestDocumentMock.getInvoiceNumber(), disbVchrPayeeIdNumber, this.paymentRequestDocumentMock.getInvoiceDate(), this.paymentRequestDocumentMock.getVendorInvoiceAmount(), false)).thenReturn(duplicateDvMessages);
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Cancelled() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceCancelledPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Voided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoidedAndNormal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_Cancelled() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_Voided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoided() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_noDuplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoidedAndNormal() {
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Cancelled() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceCancelledPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_Voided() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceVoided, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoided() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceCancelledOrVoidedPreqToken, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byVendorAndInvoiceNumber_CancelledOrVoidedAndNormal() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_Cancelled() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_Voided() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, false, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoided() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(false, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountCancelledOrVoidedPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_byInvoiceDateAndTotal_CancelledOrVoidedAndNormal() {
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, true, true);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByPOIdInvoiceAmountInvoiceDate(Integer.valueOf(100), INVOICE_AMOUNT, TODAY)).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
        Assert.assertEquals((Object)this.expectedDuplicateInvoiceDateAmountPreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_bothChecksDisabled() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)false);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)false);
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_dvCheckEnabled_preqCheckDisabled() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_PAYMENT_REQUEST_IND")).thenReturn((Object)false);
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)DUPLICATE_DV_TEXT, messages.get("DvDuplicateInvoice"));
    }

    @Test
    public void checkForDuplicatePayments_duplicateDv_duplicatePreq_dvCheckDisabled_preqCheckEnabled() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsBoolean(PaymentRequestDocument.class, "DUPLICATE_PAYMENT_CHECK_INCLUDE_DISBURSEMENT_VOUCHER_IND")).thenReturn((Object)false);
        this.setupDuplicateDvMessages();
        List<PaymentRequestDocument> duplicatePaymentRequests = this.buildDuplicatePaymentRequests(true, false, false);
        Mockito.when((Object)this.paymentRequestDaoMock.getActivePaymentRequestsByVendorNumber(Integer.valueOf(1), Integer.valueOf(1))).thenReturn(duplicatePaymentRequests);
        HashMap messages = this.cut.checkForDuplicatePayments(this.paymentRequestDocumentMock);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)this.expectedDuplicateInvoicePreqWarning, messages.get("PREQDuplicateInvoice"));
    }

    @Test
    public void removeTaxItems_noNonresidentTaxItems_nothingRemoved() {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new PaymentRequestItem());
        items.add(this.createPaymentRequestItem("SPHD"));
        Mockito.when((Object)this.paymentRequestDocumentMock.getItems()).thenReturn(items);
        ArrayList expectedItems = new ArrayList(items);
        this.cut.removeTaxItems(this.paymentRequestDocumentMock);
        List actualItems = this.paymentRequestDocumentMock.getItems();
        Assert.assertEquals((long)2L, (long)actualItems.size());
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    private PurApItem createPaymentRequestItem(String itemTypeCode) {
        PaymentRequestItem purApItem = new PaymentRequestItem();
        purApItem.setItemTypeCode(itemTypeCode);
        return purApItem;
    }

    @Test
    public void removeTaxItems_hasNonresidentTaxItems_allNonresidentTaxItemsRemoved() {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new PaymentRequestItem());
        ArrayList<PurApItem> expectedItems = new ArrayList<PurApItem>(items);
        items.add(this.createPaymentRequestItem("FDTX"));
        items.add(this.createPaymentRequestItem("STTX"));
        PurApItem shippingPaymentRequestItem = this.createPaymentRequestItem("SPHD");
        items.add(shippingPaymentRequestItem);
        expectedItems.add(shippingPaymentRequestItem);
        items.add(this.createPaymentRequestItem("FDGR"));
        items.add(this.createPaymentRequestItem("STGR"));
        Mockito.when((Object)this.paymentRequestDocumentMock.getItems()).thenReturn(items);
        this.cut.removeTaxItems(this.paymentRequestDocumentMock);
        List actualItems = this.paymentRequestDocumentMock.getItems();
        Assert.assertEquals((long)2L, (long)actualItems.size());
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }
}

