/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.impl.RequisitionAccountingLineAccessibleValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizer;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.UpdateAccountingLineEvent;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.AutoPopulatingList;

public class RequisitionAccountingLineAccessibleValidationTest {
    private TestableRequisitionAccountingLineAccessibleValidation cutSpy;
    @Mock
    private AccountingLineAuthorizer accountingLineAuthorizerMock;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private FinancialSystemDocumentHeader documentHeaderMock;
    @Mock
    private Person personMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;
    private AccountingLine accountingLineForValidationMock;
    private AccountingLine updatedAccountingLineForValidationMock;
    private RequisitionDocument reqsDocumentSpy;
    private UpdateAccountingLineEvent event;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().clearErrorMessages();
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnAccountingLine((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, null, this.personMock, true, null)).thenReturn((Object)false);
        Mockito.when((Object)this.documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        try (MockedStatic kradServiceLocatorWebMockedStatic = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> documentHeaderBaseClass = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(documentHeaderBaseClass);
            kradServiceLocatorWebMockedStatic.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.reqsDocumentSpy = (RequisitionDocument)Mockito.spy(RequisitionDocument.class);
        }
        Mockito.when((Object)this.reqsDocumentSpy.getDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        Mockito.when((Object)this.reqsDocumentSpy.getFinancialSystemDocumentHeader()).thenReturn((Object)this.documentHeaderMock);
        this.accountingLineForValidationMock = this.setupAccountingLine("5000");
        this.updatedAccountingLineForValidationMock = this.setupAccountingLine("7000");
        this.event = new UpdateAccountingLineEvent("", (Document)this.reqsDocumentSpy, this.accountingLineForValidationMock, this.updatedAccountingLineForValidationMock);
        Mockito.when((Object)this.workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocumentMock.isApprovalRequested()).thenReturn((Object)true);
        this.cutSpy = (TestableRequisitionAccountingLineAccessibleValidation)((Object)Mockito.spy((Object)((Object)new TestableRequisitionAccountingLineAccessibleValidation())));
        this.cutSpy.setAccountingDocumentForValidation((AccountingDocument)this.reqsDocumentSpy);
        this.cutSpy.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cutSpy.setAccountingLineForValidation(this.accountingLineForValidationMock);
        ((TestableRequisitionAccountingLineAccessibleValidation)((Object)Mockito.doReturn((Object)this.accountingLineAuthorizerMock).when((Object)this.cutSpy))).lookupAccountingLineAuthorizer();
    }

    private AccountingLine setupAccountingLine(String financialObjectCode) {
        AccountingLine accountingLine = (AccountingLine)Mockito.mock(RequisitionAccount.class);
        Mockito.when((Object)accountingLine.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountingLine.getAccountNumber()).thenReturn((Object)"1031400");
        Mockito.when((Object)accountingLine.getFinancialObjectCode()).thenReturn((Object)financialObjectCode);
        Mockito.when((Object)accountingLine.getValuesMap()).thenCallRealMethod();
        Mockito.when((Object)accountingLine.isLike((AccountingLine)ArgumentMatchers.any())).thenCallRealMethod();
        ((AccountingLine)Mockito.doNothing().when((Object)accountingLine)).refreshReferenceObject((String)ArgumentMatchers.any());
        return accountingLine;
    }

    @Test
    public void validate_onlyUpdatedObjectCode_VALID() {
        boolean actual;
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, "items.sourceAccountingLines", "financialObjectCode", false, true, this.personMock, new HashSet())).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn(Mockito.mock(PersistenceStructureService.class));
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
        }
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void validate_moreThanObjectCodeChanged_INVALID() {
        Mockito.when((Object)this.updatedAccountingLineForValidationMock.getChartOfAccountsCode()).thenReturn((Object)"BA");
        Mockito.when((Object)this.accountingLineAuthorizerMock.hasEditPermissionOnField((AccountingDocument)this.reqsDocumentSpy, this.accountingLineForValidationMock, null, "financialObjectCode", false, true, this.personMock, new HashSet())).thenReturn((Object)true);
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic kradServiceLocatorMockedStatic = Mockito.mockStatic(KRADServiceLocator.class);
             MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            MessageMap messageMap = new MessageMap();
            globalVariablesMockedStatic.when(GlobalVariables::getMessageMap).thenReturn((Object)messageMap);
            kradServiceLocatorMockedStatic.when(KRADServiceLocator::getPersistenceStructureService).thenReturn(Mockito.mock(PersistenceStructureService.class));
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn((Object)this.accountSvcMock);
            boolean actual = this.cutSpy.validate((AttributedDocumentEvent)this.event);
            Assert.assertFalse((boolean)actual);
            Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("accountNumber")).get(0);
            Assert.assertEquals((Object)"error.accountingLine.inaccessibleUpdate", (Object)errorMessage.getErrorKey());
            String[] messageParameters = errorMessage.getMessageParameters();
            Assert.assertEquals((long)3L, (long)messageParameters.length);
            Assert.assertNull((Object)messageParameters[0]);
            Assert.assertEquals((Object)"BL-1031400", (Object)messageParameters[1]);
            Assert.assertNull((Object)messageParameters[2]);
        }
    }

    public static class TestableRequisitionAccountingLineAccessibleValidation
    extends RequisitionAccountingLineAccessibleValidation {
        protected AccountingLineAuthorizer lookupAccountingLineAuthorizer() {
            return null;
        }
    }
}

