/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoAccountPercentBetween0And100Validation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoAccountPercentBetween0And100ValidationTest {
    private VendorCreditMemoAccountPercentBetween0And100Validation cut;
    @Mock
    private PurApAccountingLine accountingLineMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new VendorCreditMemoAccountPercentBetween0And100Validation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validate_100Percent() {
        Mockito.when((Object)this.accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("100"));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
    }

    @Test
    public void validate_PercentTooHigh() {
        Mockito.when((Object)this.accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("101"));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }

    @Test
    public void validate_PercentZero() {
        Mockito.when((Object)this.accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("0"));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }

    @Test
    public void validate_PercentNegative() {
        Mockito.when((Object)this.accountingLineMock.getAccountLinePercent()).thenReturn((Object)new BigDecimal("-1"));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("accountLinePercent", "errors.creditMemo.line.percent"));
    }
}

