/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoObjectCodeValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.impl.parameter.AlwaysSucceedParameterEvaluatorImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoObjectCodeValidationTest {
    private VendorCreditMemoObjectCodeValidation cut;
    @Mock
    private ObjectCode objectCodeMock;
    @Mock
    private PurApAccountingLine accountingLineMock;
    @Mock
    private ParameterEvaluatorService parameterEvaluatorSvcMock;
    @Mock
    private ParameterEvaluator alwaysFailParameterEvaluatorMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.parameterEvaluatorSvcMock.getParameterEvaluator(VendorCreditMemoDocument.class, "VALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "INVALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "AS", "INV")).thenReturn((Object)AlwaysSucceedParameterEvaluatorImpl.getInstance());
        Mockito.when((Object)this.parameterEvaluatorSvcMock.getParameterEvaluator(VendorCreditMemoDocument.class, "VALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "INVALID_OBJECT_LEVELS_BY_OBJECT_TYPE", "XX", "XXX")).thenReturn((Object)this.alwaysFailParameterEvaluatorMock);
        Mockito.when((Object)this.accountingLineMock.getObjectCode()).thenReturn((Object)this.objectCodeMock);
        this.cut = new VendorCreditMemoObjectCodeValidation();
        this.cut.setParameterEvaluatorService(this.parameterEvaluatorSvcMock);
    }

    @Test
    public void validate_validObjectCode() {
        Mockito.when((Object)this.objectCodeMock.getFinancialObjectTypeCode()).thenReturn((Object)"AS");
        Mockito.when((Object)this.objectCodeMock.getFinancialObjectLevelCode()).thenReturn((Object)"INV");
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
    }

    @Test
    public void validate_invalidObjectCode() {
        Mockito.when((Object)this.objectCodeMock.getFinancialObjectTypeCode()).thenReturn((Object)"XX");
        Mockito.when((Object)this.objectCodeMock.getFinancialObjectLevelCode()).thenReturn((Object)"XXX");
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AddAccountingLineEvent("", null, (AccountingLine)this.accountingLineMock)));
    }
}

