/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.impl.CreditMemoServiceImpl;
import org.kuali.kfs.module.purap.document.validation.impl.VendorCreditMemoPurchaseOrderForInvoicedItemsValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class VendorCreditMemoPurchaseOrderForInvoicedItemsValidationTest {
    private static final int PO_ID = 1001;
    private VendorCreditMemoPurchaseOrderForInvoicedItemsValidation cut;
    @Mock
    private VendorCreditMemoDocument creditMemoDocMock;
    @Mock
    private PurchaseOrderItem poItemMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupCreditMemoDocMock();
        this.setupPurchaseOrderSvcMock();
        this.cut = new VendorCreditMemoPurchaseOrderForInvoicedItemsValidation();
        this.cut.setCreditMemoService((CreditMemoService)new CreditMemoServiceImpl());
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupCreditMemoDocMock() {
        Mockito.when((Object)this.creditMemoDocMock.getPurchaseOrderIdentifier()).thenReturn((Object)1001);
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)true);
    }

    private void setupPurchaseOrderSvcMock() {
        PurchaseOrderDocument purchaseOrderDocMock = (PurchaseOrderDocument)Mockito.mock(PurchaseOrderDocument.class);
        Mockito.when((Object)purchaseOrderDocMock.getPurapDocumentIdentifier()).thenReturn((Object)1001);
        Mockito.when((Object)purchaseOrderDocMock.getApplicationDocumentStatus()).thenReturn((Object)"Open");
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        Mockito.when((Object)this.poItemMock.getItemType()).thenReturn((Object)itemType);
        Mockito.when((Object)this.poItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)purchaseOrderDocMock.getItems()).thenReturn(Collections.singletonList(this.poItemMock));
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(1001))).thenReturn((Object)purchaseOrderDocMock);
    }

    @Test
    public void validate_SourceNotPO() {
        Mockito.when((Object)this.creditMemoDocMock.isSourceDocumentPurchaseOrder()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_InvoicedTotalQuantityGreaterThanZero() {
        Mockito.when((Object)this.poItemMock.getItemInvoicedTotalQuantity()).thenReturn((Object)new KualiDecimal(1));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }

    @Test
    public void validate_ZeroUnitPriceAndOutstandingEncumberedAmount() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    public void validate_WithUnitPriceLessEqualOutstandingEncumberedAmount() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)this.poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(1));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    public void validate_NullUnitPrice() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(0.5));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    public void validate_WithUnitPriceLessThanOutstandingEncumberedAmount() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)this.poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(0.5));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    public void validate_WithUnitPriceEqualToOutstandingEncumberedAmount() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)this.poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(1));
        Assert.assertFalse((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().fieldHasMessage("document.purchaseOrderIdentifier", "errors.creditMemo.po.noItems"));
    }

    @Test
    public void validate_WithUnitPriceGreaterThanOutstandingEncumberedAmount() {
        Mockito.when((Object)this.poItemMock.getItemOutstandingEncumberedAmount()).thenReturn((Object)new KualiDecimal(1));
        Mockito.when((Object)this.poItemMock.getItemUnitPrice()).thenReturn((Object)new BigDecimal(2));
        Assert.assertTrue((boolean)this.cut.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.creditMemoDocMock)));
    }
}

