/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.fixture.PurapTestConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum ItemFieldsFixture {
    ALL_FIELDS_ABOVE_QUANTITY_BASED("ITEM", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_QUANTITY_ABOVE_QUANTITY_BASED("ITEM", null, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_UOM_ABOVE_QUANTITY_BASED("ITEM", PurapTestConstants.ItemsAccounts.QUANTITY, null, "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_DESC_ABOVE_QUANTITY_BASED("ITEM", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", null, PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_UNIT_PRICE_ABOVE_QUANTITY_BASED("ITEM", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", null, 1),
    ALL_FIELDS_ABOVE_SERVICE("SRVC", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_QUANTITY_ABOVE_SERVICE("SRVC", null, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_UOM_ABOVE_SERVICE("SRVC", PurapTestConstants.ItemsAccounts.QUANTITY, null, "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_DESC_ABOVE_SERVICE("SRVC", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", null, PurapTestConstants.ItemsAccounts.UNIT_PRICE, 1),
    NO_UNIT_PRICE_ABOVE_SERVICE("SRVC", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", null, 1),
    ALL_FIELDS_BELOW("SPHD", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NO_QUANTITY_BELOW("SPHD", null, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NO_UOM_BELOW("SPHD", PurapTestConstants.ItemsAccounts.QUANTITY, null, "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NO_DESC_BELOW("SPHD", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", null, PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NO_UNIT_PRICE_BELOW("SPHD", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", null, null),
    NEGATIVE_UNIT_PRICE_QUANTITY_BASED("ITEM", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.NEGATIVE_UNIT_PRICE, null),
    POSITIVE_UNIT_PRICE_DISCOUNT("ORDS", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NEGATIVE_UNIT_PRICE_DISCOUNT("ORDS", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.NEGATIVE_UNIT_PRICE, null),
    POSITIVE_UNIT_PRICE_TRADEIN("TRDI", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.UNIT_PRICE, null),
    NEGATIVE_UNIT_PRICE_TRADEIN("TRDI", PurapTestConstants.ItemsAccounts.QUANTITY, "EA", "Test item description", PurapTestConstants.ItemsAccounts.NEGATIVE_UNIT_PRICE, null);

    ItemType itemType = new ItemType();
    String itemTypeCode;
    KualiDecimal itemQuantity;
    String uomCode;
    String itemDescription;
    BigDecimal itemUnitPrice;
    Integer itemLineNumber;

    private ItemFieldsFixture(String itemTypeCode, KualiDecimal itemQuantity, String uomCode, String itemDescription, BigDecimal itemUnitPrice, Integer itemLineNumber) {
        this.itemTypeCode = itemTypeCode;
        this.itemQuantity = itemQuantity;
        this.uomCode = uomCode;
        this.itemDescription = itemDescription;
        this.itemUnitPrice = itemUnitPrice;
        this.itemLineNumber = itemLineNumber;
        this.itemType.setItemTypeCode(itemTypeCode);
    }

    public RequisitionItem populateRequisitionItem() {
        RequisitionItem item = new RequisitionItem();
        item.setItemTypeCode(this.itemTypeCode);
        item.setItemQuantity(this.itemQuantity);
        item.setItemUnitOfMeasureCode(this.uomCode);
        item.setItemDescription(this.itemDescription);
        item.setItemUnitPrice(this.itemUnitPrice);
        item.setItemLineNumber(this.itemLineNumber);
        return item;
    }
}

