/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.PurchasingAccountsPayableDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchasingDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionItemFixture;
import org.kuali.kfs.module.purap.fixture.TaxTestCaseFixture;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.fixture.CommodityCodeFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum RequisitionDocumentFixture {
    REQ_ONLY_REQUIRED_FIELDS(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}),
    REQ_TWO_ITEMS(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1, RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_2}),
    REQ_ONLY_REQUIRED_FIELDS_MULTIPLE_ACCOUNTS(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_3}),
    REQ_WITH_NEGATIVE_AMOUNT(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_ITEM_NEGATIVE_AMOUNT}),
    REQ_VALID_NO_APO_OVER_LIMIT(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO}),
    REQ_VALID_NO_APO_RESTRICTED_ITEM(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO_RESTRICTED_ITEM}),
    REQ_NO_APO_VALID(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO}),
    REQ_NO_APO_VALID_2(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO}),
    REQ_APO_VALID(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}),
    REQ_MULTI_QUANTITY(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_MULTI_QUANTITY, PurchasingDocumentFixture.REQ_MULTI, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_MULTI_ITEM_QUANTITY}),
    REQ_MULTI_NON_QUANTITY(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_MULTI_NON_QUANTITY, PurchasingDocumentFixture.REQ_MULTI, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_MULTI_ITEM_NON_QUANTITY}),
    REQ_ALTERNATE_APO(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ALTERNATE_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1, RequisitionItemFixture.REQ_SERVICE_APO_ITEM_1, RequisitionItemFixture.REQ_FREIGHT_ITEM_1}),
    REQ_APO_INVALID_ALTERNATE_VENDOR_NAMES(null, null, null, "NFL Shop", "Dicks Sporting Goods", null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}),
    REQ_APO_INVALID_TOTAL_NOT_GREATER_THAN_ZERO(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO_TOTAL_NOT_GREATER_THAN_ZERO}),
    REQ_APO_INVALID_CONTAINS_RESTRICTED_ITEM(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO_CONTAIN_RESTRICTED_ITEM}),
    REQ_APO_INVALID_ERROR_RETRIEVING_VENDOR_FROM_DATABASE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_VENDOR_NOT_IN_DATABASE, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_APO_INVALID_WITH_RESTRICTED_VENDOR(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_RESTRICTED_VENDOR, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}),
    REQ_APO_INVALID_PAYMENT_TYPE_RECURRING(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_WITH_RECURRING_PAYMENT_TYPE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_APO_INVALID_PO_TOTAL_LIMIT_NON_ZERO(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_WITH_PO_TOTAL_LIMIT_NON_ZERO, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_APO_INVALID_FAILS_CAPITAL_ASSET_RULE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_INVALID_CAPITAL_ASSET}),
    REQ_APO_INVALID_APPROVAL_OUTSIDE_ALLOWED_DATE_RANGE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_VALID_VENDOR_FAX_NUMBER(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_VALID_VENDOR_FAX_NUMBER, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_B2B_WITH_DEBARRED_VENDOR(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_DEBARRED_VENDOR, PurchasingDocumentFixture.REQ_B2B_VENDOR, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_B2B_WITH_INACTIVE_VENDOR(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_INACTIVE_VENDOR, PurchasingDocumentFixture.REQ_B2B_VENDOR, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_B2B_WITH_DV_VENDOR(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_DV_VENDOR, PurchasingDocumentFixture.REQ_B2B_VENDOR, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_B2B_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTER(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTERS, PurchasingDocumentFixture.REQ_B2B_VENDOR, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_B2B_WITH_PO_VENDOR(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_B2B_VENDOR_NO_TOTAL_LIMIT, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_B2B_ITEM_1}),
    REQ_INVALID_VENDOR_FAX_NUMBER_CONTAINS_LETTER(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_INVALID_VENDOR_FAX_NUMBER_CONTAINS_LETTER, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_INVALID_VENDOR_FAX_NUMBER_BAD_FORMAT(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_INVALID_VENDOR_FAX_NUMBER_BAD_FORMAT, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTER(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_INVALID_US_VENDOR_ZIP_CODE_CONTAINS_LETTERS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_INVALID_US_VENDOR_ZIP_CODE_BAD_FORMAT(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_INVALID_US_VENDOR_ZIP_CODE_BAD_FORMAT, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_INVALID_NON_US_VENDOR_ZIP_CODE_CONTAINS_LETTER(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_INVALID_NON_US_VENDOR_ZIP_CODE_CONTAINS_LETTERS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_VALID_US_VENDOR_ZIP_CODE_WITH_4_TRAILING_NUMBERS(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_WITH_VALID_US_VENDOR_ZIP_CODE_WITH_4_TRAILING_NUMBERS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_PO_BEGIN_DATE_AFTER_END_DATE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_PO_BEGIN_DATE_AFTER_END_DATE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_PO_BEGIN_DATE_NO_END_DATE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_PO_BEGIN_DATE_NO_END_DATE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_PO_END_DATE_NO_BEGIN_DATE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_PO_END_DATE_NO_BEGIN_DATE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_PO_BEGIN_DATE_AND_END_DATE_NO_RECURRING_PAYMENT_TYPE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_WITH_BEGIN_AND_END_DATE_WITHOUT_RECURRING_PAYMENT_TYPE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_RECURRING_PAYMENT_TYPE_WITHOUT_BEGIN_NOR_END_DATE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_WITH_RECURRING_PAYMENT_TYPE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_WITH_RECURRING_PAYMENT_TYPE_BEGIN_AND_END_DATE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_WITH_RECURRING_PAYMENT_TYPE_BEGIN_AND_END_DATE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_APO_ITEM_1}),
    REQ_NO_APO_VALID_WITH_BASIC_ACTIVE_COMMODITY_CODE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_VALID_APO, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_NO_APO_BASIC_ACTIVE_COMMODITY_CODE}),
    REQ_INVALID_ITEM_QUANTITY_BASED_NO_QUANTITY(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_INVALID_QUANTITY_BASED_NO_QUANTITY}),
    REQ_TAX(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_TAX, PurchasingDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}),
    REQ_PERFORMANCE(null, null, null, null, null, null, null, null, null, PurchasingAccountsPayableDocumentFixture.REQ_ONLY_REQUIRED_FIELDS, PurchasingDocumentFixture.REQ_PERFORMANCE, new RequisitionItemFixture[]{RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE, RequisitionItemFixture.REQ_ITEM_PERFORMANCE});

    public final String requisitionOrganizationReference1Text;
    public final String requisitionOrganizationReference2Text;
    public final String requisitionOrganizationReference3Text;
    public final String alternate1VendorName;
    public final String alternate2VendorName;
    public final String alternate3VendorName;
    public final String alternate4VendorName;
    public final String alternate5VendorName;
    public final KualiDecimal organizationAutomaticPurchaseOrderLimit;
    private PurchasingAccountsPayableDocumentFixture purapDocumentFixture;
    private PurchasingDocumentFixture purchasingDocumentFixture;
    private RequisitionItemFixture[] requisitionItemFixtures;

    private RequisitionDocumentFixture(String requisitionOrganizationReference1Text, String requisitionOrganizationReference2Text, String requisitionOrganizationReference3Text, String alternate1VendorName, String alternate2VendorName, String alternate3VendorName, String alternate4VendorName, String alternate5VendorName, KualiDecimal organizationAutomaticPurchaseOrderLimit, PurchasingAccountsPayableDocumentFixture purapDocumentFixture, PurchasingDocumentFixture purchasingDocumentFixture, RequisitionItemFixture[] requisitionItemFixtures) {
        this.requisitionOrganizationReference1Text = requisitionOrganizationReference1Text;
        this.requisitionOrganizationReference2Text = requisitionOrganizationReference2Text;
        this.requisitionOrganizationReference3Text = requisitionOrganizationReference3Text;
        this.alternate1VendorName = alternate1VendorName;
        this.alternate2VendorName = alternate2VendorName;
        this.alternate3VendorName = alternate3VendorName;
        this.alternate4VendorName = alternate4VendorName;
        this.alternate5VendorName = alternate5VendorName;
        this.organizationAutomaticPurchaseOrderLimit = organizationAutomaticPurchaseOrderLimit;
        this.purapDocumentFixture = purapDocumentFixture;
        this.purchasingDocumentFixture = purchasingDocumentFixture;
        this.requisitionItemFixtures = requisitionItemFixtures;
    }

    public RequisitionDocument createRequisitionDocument() {
        RequisitionDocument doc = this.purchasingDocumentFixture.createRequisitionDocument(this.purapDocumentFixture);
        doc.setRequisitionOrganizationReference1Text(this.requisitionOrganizationReference1Text);
        doc.setRequisitionOrganizationReference2Text(this.requisitionOrganizationReference2Text);
        doc.setRequisitionOrganizationReference3Text(this.requisitionOrganizationReference3Text);
        doc.setAlternate1VendorName(this.alternate1VendorName);
        doc.setAlternate2VendorName(this.alternate2VendorName);
        doc.setAlternate3VendorName(this.alternate3VendorName);
        doc.setAlternate4VendorName(this.alternate4VendorName);
        doc.setAlternate5VendorName(this.alternate5VendorName);
        doc.setOrganizationAutomaticPurchaseOrderLimit(this.organizationAutomaticPurchaseOrderLimit);
        for (RequisitionItemFixture requisitionItemFixture : this.requisitionItemFixtures) {
            requisitionItemFixture.addTo(doc);
        }
        doc.fixItemReferences();
        doc.setAccountDistributionMethod("S");
        doc.refreshNonUpdateableReferences();
        return doc;
    }

    public RequisitionDocument createRequisitionDocumentForTax(TaxTestCaseFixture taxTestCaseFixture) {
        String parameterSuffix;
        RequisitionDocument doc = this.createRequisitionDocument();
        doc.getItem(0).getItemType().setTaxableIndicator(taxTestCaseFixture.isItemTypeTaxable());
        doc.setDeliveryStateCode("IN");
        if (taxTestCaseFixture.isItemTaxAmountNull()) {
            doc.getItem(0).setItemTaxAmount(null);
        } else {
            doc.getItem(0).setItemTaxAmount(new KualiDecimal(100));
        }
        doc.setUseTaxIndicator(taxTestCaseFixture.isUseTax());
        if (taxTestCaseFixture.isCommodityCodeNull()) {
            ((RequisitionItem)doc.getItem(0)).setPurchasingCommodityCode(null);
            ((RequisitionItem)doc.getItem(0)).setCommodityCode(null);
        } else {
            ((RequisitionItem)doc.getItem(0)).setCommodityCode(CommodityCodeFixture.COMMODITY_CODE_BASIC_ACTIVE.createCommodityCode());
        }
        String INVALID_VALUE = "XX";
        String fundGroupCode = ((PurApAccountingLine)doc.getItem(0).getSourceAccountingLines().get(0)).getAccount().getSubFundGroup().getFundGroupCode();
        String subFundGroupCode = ((PurApAccountingLine)doc.getItem(0).getSourceAccountingLines().get(0)).getAccount().getSubFundGroup().getSubFundGroupCode();
        String objectLevelCode = ((PurApAccountingLine)doc.getItem(0).getSourceAccountingLines().get(0)).getObjectCode().getFinancialObjectLevelCode();
        String consolidationObjectCode = ((PurApAccountingLine)doc.getItem(0).getSourceAccountingLines().get(0)).getObjectCode().getFinancialObjectLevel().getFinancialConsolidationObjectCode();
        if (taxTestCaseFixture.isDeliveryStateTaxable()) {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"TAXABLE_DELIVERY_STATES", (String)doc.getDeliveryStateCode());
            parameterSuffix = "FOR_TAXABLE_STATES";
        } else {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"TAXABLE_DELIVERY_STATES", (String)INVALID_VALUE);
            parameterSuffix = "FOR_NON_TAXABLE_STATES";
        }
        if (taxTestCaseFixture.isFundGroupCodeTaxable()) {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_FUND_GROUPS_" + parameterSuffix), (String)fundGroupCode);
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_SUB_FUND_GROUPS_" + parameterSuffix), (String)subFundGroupCode);
        } else {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_FUND_GROUPS_" + parameterSuffix), (String)INVALID_VALUE);
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_SUB_FUND_GROUPS_" + parameterSuffix), (String)INVALID_VALUE);
        }
        if (taxTestCaseFixture.isObjectCodeTaxable()) {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_OBJECT_LEVELS_" + parameterSuffix), (String)objectLevelCode);
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_OBJECT_CONSOLIDATIONS_" + parameterSuffix), (String)consolidationObjectCode);
        } else {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_OBJECT_LEVELS_" + parameterSuffix), (String)INVALID_VALUE);
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)("TAXABLE_OBJECT_CONSOLIDATIONS_" + parameterSuffix), (String)INVALID_VALUE);
        }
        if (taxTestCaseFixture.isSalesTaxEnabled()) {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"Y");
        } else {
            IntegTestUtils.setSystemParameter(KfsParameterConstants.PURCHASING_DOCUMENT.class, (String)"ENABLE_SALES_TAX_IND", (String)"N");
        }
        return doc;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("requisitionOrganizationReference1Text", (Object)this.requisitionOrganizationReference1Text).append("requisitionOrganizationReference2Text", (Object)this.requisitionOrganizationReference2Text).append("requisitionOrganizationReference3Text", (Object)this.requisitionOrganizationReference3Text).append("alternate1VendorName", (Object)this.alternate1VendorName).append("alternate2VendorName", (Object)this.alternate2VendorName).append("alternate3VendorName", (Object)this.alternate3VendorName).append("alternate4VendorName", (Object)this.alternate4VendorName).append("alternate5VendorName", (Object)this.alternate5VendorName).append("organizationAutomaticPurchaseOrderLimit", (Object)this.organizationAutomaticPurchaseOrderLimit).append("purapDocumentFixture", (Object)this.purapDocumentFixture).append("purchasingDocumentFixture", (Object)this.purchasingDocumentFixture).append("requisitionItemFixtures", (Object[])this.requisitionItemFixtures).toString();
    }
}

