/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomizeGeneralLedgerPendingEntryTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchasingAccountsPayableDocument purapDocMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    @Mock
    private ObjectCodeService objectCodeSvcMock;
    @Mock
    private PaymentRequestService paymentRequestSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setObjectCodeService(this.objectCodeSvcMock);
        this.cut.setPaymentRequestService(this.paymentRequestSvcMock);
    }

    @Test
    public void poDocumentSameYearNonEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void poDocumentNextYearNonEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2017);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2017), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2017L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void poDocumentSameYearNonEncumbranceReferenceDocPositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, Integer.valueOf(100), "D", "PO", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals((Object)"100", (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals((Object)"PO", (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void poDocumentSameYearEncumbrancePositive() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PO", true);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void poDocumentSameYearNonEncumbranceNegativeDebit() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "D", "PO", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"C", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void poDocumentSameYearNonEncumbranceNegativeCredit() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.purapDocMock.getPostingYear()).thenReturn((Object)2016);
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("-100")), explicitEntry, null, "C", "PO", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidDocType() {
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "BAD", true);
    }

    @Test
    public void preqDocumentSameYearNonEncumbrancePositiveNoBackpost() {
        this.purapDocMock = (PurchasingAccountsPayableDocument)Mockito.mock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)((PaymentRequestDocument)this.purapDocMock).getAlternateVendorHeaderGeneratedIdentifier()).thenReturn(null);
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void preqDocumentSameYearNonEncumbrancePositiveBackpost() {
        this.purapDocMock = (PurchasingAccountsPayableDocument)Mockito.mock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)((PaymentRequestDocument)this.purapDocMock).getAlternateVendorHeaderGeneratedIdentifier()).thenReturn(null);
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2015L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void preqDocumentSameYearNonEncumbrancePositiveAlternativeVendor() {
        PurchaseOrderDocument purchaseOrderDocument = (PurchaseOrderDocument)Mockito.mock(PurchaseOrderDocument.class);
        this.purapDocMock = (PurchasingAccountsPayableDocument)Mockito.mock(PaymentRequestDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2015), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        Mockito.when((Object)this.paymentRequestSvcMock.allowBackpost((PaymentRequestDocument)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)((PaymentRequestDocument)this.purapDocMock).getAlternateVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)((PaymentRequestDocument)this.purapDocMock).getAlternateVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purapDocMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)this.purapDocMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)1);
        Mockito.when((Object)((PaymentRequestDocument)this.purapDocMock).getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocument);
        Mockito.when((Object)purchaseOrderDocument.getAlternateVendorName()).thenReturn((Object)"HP Corporation");
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "PREQ", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2015L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"12", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void cmDocumentSameYearNonEncumbrancePositiveNotAlternativeVendor() {
        this.purapDocMock = (PurchasingAccountsPayableDocument)Mockito.mock(VendorCreditMemoDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        Mockito.when((Object)((VendorCreditMemoDocument)this.purapDocMock).isSourceDocumentPaymentRequest()).thenReturn((Object)false);
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"ACME Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    @Test
    public void cmDocumentSameYearNonEncumbrancePositiveAlternativeVendor() {
        PurchaseOrderDocument purchaseOrderDocMock = (PurchaseOrderDocument)Mockito.mock(PurchaseOrderDocument.class);
        PaymentRequestDocument paymentRequestDocMock = (PaymentRequestDocument)Mockito.mock(PaymentRequestDocument.class);
        this.purapDocMock = (PurchasingAccountsPayableDocument)Mockito.mock(VendorCreditMemoDocument.class);
        GeneralLedgerPendingEntry explicitEntry = this.getGeneralLedgerPendingEntry();
        Mockito.when((Object)this.purapDocMock.getDocumentNumber()).thenReturn((Object)"DOC1234");
        Mockito.when((Object)this.purapDocMock.getVendorName()).thenReturn((Object)"ACME Corporation");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)this.getUniversityDate());
        Mockito.when((Object)this.objectCodeSvcMock.getByPrimaryId(Integer.valueOf(2016), "BL", "4166")).thenReturn((Object)this.getObjectCode());
        Mockito.when((Object)((VendorCreditMemoDocument)this.purapDocMock).isSourceDocumentPaymentRequest()).thenReturn((Object)true);
        Mockito.when((Object)((VendorCreditMemoDocument)this.purapDocMock).getPaymentRequestDocument()).thenReturn((Object)paymentRequestDocMock);
        Mockito.when((Object)paymentRequestDocMock.getAlternateVendorHeaderGeneratedIdentifier()).thenReturn((Object)111);
        Mockito.when((Object)paymentRequestDocMock.getAlternateVendorDetailAssignedIdentifier()).thenReturn((Object)222);
        Mockito.when((Object)paymentRequestDocMock.getVendorHeaderGeneratedIdentifier()).thenReturn((Object)111);
        Mockito.when((Object)paymentRequestDocMock.getVendorDetailAssignedIdentifier()).thenReturn((Object)222);
        Mockito.when((Object)((VendorCreditMemoDocument)this.purapDocMock).getPurchaseOrderDocument()).thenReturn((Object)purchaseOrderDocMock);
        Mockito.when((Object)purchaseOrderDocMock.getAlternateVendorName()).thenReturn((Object)"HP Corporation");
        this.cut.customizeGeneralLedgerPendingEntry(this.purapDocMock, this.getPurchaseOrderAccountingLine(new KualiDecimal("100")), explicitEntry, null, "D", "CM", false);
        Assert.assertEquals((Object)"DOC1234", (Object)explicitEntry.getDocumentNumber());
        Assert.assertEquals((Object)"HP Corporation", (Object)explicitEntry.getTransactionLedgerEntryDescription());
        Assert.assertEquals((Object)"01", (Object)explicitEntry.getFinancialSystemOriginationCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentNumber());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialDocumentTypeCode());
        Assert.assertEquals(null, (Object)explicitEntry.getReferenceFinancialSystemOriginationCode());
        Assert.assertEquals((long)2016L, (long)explicitEntry.getUniversityFiscalYear().intValue());
        Assert.assertEquals((Object)"03", (Object)explicitEntry.getUniversityFiscalPeriodCode());
        Assert.assertEquals((Object)"EX", (Object)explicitEntry.getFinancialObjectTypeCode());
        Assert.assertEquals((Object)"D", (Object)explicitEntry.getTransactionDebitCreditCode());
        Assert.assertEquals((Object)"AC", (Object)explicitEntry.getFinancialBalanceTypeCode());
    }

    private GeneralLedgerPendingEntry getGeneralLedgerPendingEntry() {
        GeneralLedgerPendingEntry g = new GeneralLedgerPendingEntry();
        g.setUniversityFiscalYear(Integer.valueOf(2016));
        g.setChartOfAccountsCode("BL");
        g.setAccountNumber("7654321");
        g.setFinancialObjectCode("4166");
        g.setFinancialSubObjectCode("321");
        g.setFinancialBalanceTypeCode("AC");
        return g;
    }

    private UniversityDate getUniversityDate() {
        UniversityDate d = new UniversityDate();
        d.setUniversityFiscalYear(Integer.valueOf(2016));
        d.setUniversityFiscalAccountingPeriod("03");
        return d;
    }

    private ObjectCode getObjectCode() {
        ObjectCode o = new ObjectCode();
        o.setUniversityFiscalYear(Integer.valueOf(2016));
        o.setChartOfAccountsCode("BL");
        o.setFinancialObjectCode("4166");
        o.setFinancialObjectTypeCode("EX");
        return o;
    }

    private AccountingLine getPurchaseOrderAccountingLine(KualiDecimal amount) {
        PurchaseOrderAccount p = new PurchaseOrderAccount();
        p.setAmount(amount);
        return p;
    }
}

